/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.expressions.bool.BooleanExpressions;
import com.android.tools.idea.observable.ui.SelectedRadioButtonProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.Token;
import com.android.tools.idea.run.ConfigurationSpecificEditor;
import com.android.tools.idea.run.editor.AndroidTestExtraParamsDialog;
import com.android.tools.idea.testartifacts.instrumented.AndroidInheritingClassBrowser;
import com.android.tools.idea.testartifacts.instrumented.AndroidInheritingClassVisibilityChecker;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestClassBrowser;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestClassVisibilityChecker;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.MethodListDlg;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestRunParameters
implements ConfigurationSpecificEditor<AndroidTestRunConfiguration> {
    private JRadioButton myAllInPackageTestButton;
    private JRadioButton myClassTestButton;
    private JRadioButton myMethodTestButton;
    private JRadioButton myAllInModuleTestButton;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myTestPackageComponent;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myTestClassComponent;
    private LabeledComponent<SimpleEditorTextFieldWithBrowseButton> myTestMethodComponent;
    private JPanel myContentPanel;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myInstrumentationClassComponent;
    private LabeledComponent<SimpleEditorTextFieldWithBrowseButton> myInstrumentationArgsComponent;
    private LabeledComponent myTestRegexComponent;
    private final Project myProject;
    private final ConfigurationModuleSelector myModuleSelector;
    private final boolean canSelectInstrumentationRunnerClass;
    private final ContentWrapper myContentWrapper;
    private final BindingsManager myBindingsManager;
    private final SelectedRadioButtonProperty<Integer> mySelectedTestType;
    private final TextProperty myTestPackage;
    private final TextProperty myTestClass;
    private final TextProperty myTestMethod;
    private final TextProperty myTestRegex;
    private final TextProperty myInstrumentationClass;
    private final TextProperty myInstrumentationArgs;
    private String myUserModifiedInstrumentationExtraParams = "";

    public TestRunParameters(Project project, ConfigurationModuleSelector moduleSelector2) {
        try {
            this.setupUI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.myProject = project;
        this.myModuleSelector = moduleSelector2;
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem(project);
        TestRunParametersToken token = TestRunParametersToken.EP_NAME.getExtensionList().stream().filter(it -> it.isApplicable(projectSystem)).findFirst().orElse(null);
        this.canSelectInstrumentationRunnerClass = token == null || token.canSelectInstrumentationRunnerClass(projectSystem);
        this.myBindingsManager = new BindingsManager();
        this.mySelectedTestType = new SelectedRadioButtonProperty<Integer>(0, new Integer[]{0, 1, 2, 3}, this.myAllInModuleTestButton, this.myAllInPackageTestButton, this.myClassTestButton, this.myMethodTestButton);
        this.myBindingsManager.bind(new VisibleProperty((JComponent)this.myTestPackageComponent), this.mySelectedTestType.isEqualTo(1));
        this.myBindingsManager.bind(new VisibleProperty((JComponent)this.myTestClassComponent), BooleanExpressions.any(this.mySelectedTestType.isEqualTo(2), this.mySelectedTestType.isEqualTo(3)));
        this.myBindingsManager.bind(new VisibleProperty((JComponent)this.myTestMethodComponent), this.mySelectedTestType.isEqualTo(3));
        this.myBindingsManager.bind(new VisibleProperty((JComponent)this.myTestRegexComponent), this.mySelectedTestType.isEqualTo(0));
        EditorTextFieldWithBrowseButton testPackageEditorText = new EditorTextFieldWithBrowseButton(project, false);
        new BrowseModuleValueActionListener<EditorTextField>(this.myProject){

            protected String showDialog() {
                Module module = TestRunParameters.this.myModuleSelector.getModule();
                if (module == null) {
                    Messages.showErrorDialog((Component)TestRunParameters.this.myContentPanel, (String)ExecutionBundle.message((String)"module.not.specified.error.text", (Object[])new Object[0]));
                    return null;
                }
                PackageChooserDialog dialog2 = new PackageChooserDialog(ExecutionBundle.message((String)"choose.package.dialog.title", (Object[])new Object[0]), TestRunParametersToken.getModuleForPackageChooser(module));
                dialog2.selectPackage(((EditorTextFieldWithBrowseButton)TestRunParameters.this.myTestPackageComponent.getComponent()).getText());
                dialog2.show();
                PsiPackage aPackage = dialog2.getSelectedPackage();
                return aPackage != null ? aPackage.getQualifiedName() : null;
            }
        }.setField((ComponentWithBrowseButton)testPackageEditorText);
        this.myTestPackage = new TextProperty((EditorTextField)testPackageEditorText.getChildComponent());
        this.myTestPackageComponent.setComponent((JComponent)testPackageEditorText);
        EditorTextFieldWithBrowseButton testClassEditorText = new EditorTextFieldWithBrowseButton(project, true, (JavaCodeFragment.VisibilityChecker)new AndroidTestClassVisibilityChecker(moduleSelector2));
        new AndroidTestClassBrowser(project, moduleSelector2, AndroidBundle.message("android.browse.test.class.dialog.title", new Object[0]), false).setField((ComponentWithBrowseButton)testClassEditorText);
        this.myTestClass = new TextProperty((EditorTextField)testClassEditorText.getChildComponent());
        this.myTestClassComponent.setComponent((JComponent)testClassEditorText);
        SimpleEditorTextFieldWithBrowseButton testMethodEditorText = new SimpleEditorTextFieldWithBrowseButton();
        new BrowseModuleValueActionListener<EditorTextField>(this.myProject){

            protected String showDialog() {
                PsiMethod method2;
                String className = ((EditorTextFieldWithBrowseButton)TestRunParameters.this.myTestClassComponent.getComponent()).getText();
                if (className.trim().isEmpty()) {
                    Messages.showMessageDialog((Component)this.getField(), (String)ExecutionBundle.message((String)"set.class.name.message", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"cannot.browse.method.dialog.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                    return null;
                }
                PsiClass testClass = TestRunParameters.this.myModuleSelector.findClass(className);
                if (testClass == null) {
                    Messages.showMessageDialog((Component)this.getField(), (String)ExecutionBundle.message((String)"class.does.not.exists.error.message", (Object[])new Object[]{className}), (String)ExecutionBundle.message((String)"cannot.browse.method.dialog.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                    return null;
                }
                MethodListDlg dialog2 = new MethodListDlg(testClass, (Condition)new JUnitUtil.TestMethodFilter(testClass), this.getField());
                if (dialog2.showAndGet() && (method2 = dialog2.getSelected()) != null) {
                    return method2.getName();
                }
                return null;
            }
        }.setField((ComponentWithBrowseButton)testMethodEditorText);
        this.myTestMethod = new TextProperty((EditorTextField)testMethodEditorText.getChildComponent());
        this.myTestMethodComponent.setComponent((JComponent)((Object)testMethodEditorText));
        EditorTextField testRegexEditorText = new EditorTextField();
        this.myTestRegex = new TextProperty(testRegexEditorText);
        this.myTestRegexComponent.setComponent((JComponent)testRegexEditorText);
        EditorTextFieldWithBrowseButton instrClassEditorText = new EditorTextFieldWithBrowseButton(project, true, (JavaCodeFragment.VisibilityChecker)new AndroidInheritingClassVisibilityChecker(this.myProject, moduleSelector2, "android.app.Instrumentation"));
        new AndroidInheritingClassBrowser(project, moduleSelector2, "android.app.Instrumentation", AndroidBundle.message("android.browse.instrumentation.class.dialog.title", new Object[0]), true).setField((ComponentWithBrowseButton)instrClassEditorText);
        instrClassEditorText.setEnabled(this.canSelectInstrumentationRunnerClass);
        this.myInstrumentationClass = new TextProperty((EditorTextField)instrClassEditorText.getChildComponent());
        this.myInstrumentationClassComponent.setComponent((JComponent)instrClassEditorText);
        SimpleEditorTextFieldWithBrowseButton instrArgsTextField = new SimpleEditorTextFieldWithBrowseButton();
        new BrowseModuleValueActionListener<EditorTextField>(this.myProject){

            @Nullable
            protected String showDialog() {
                Module module = TestRunParameters.this.myModuleSelector.getModule();
                if (module == null) {
                    Messages.showErrorDialog((Component)TestRunParameters.this.myContentPanel, (String)ExecutionBundle.message((String)"module.not.specified.error.text", (Object[])new Object[0]));
                    return null;
                }
                AndroidTestExtraParamsDialog dialog2 = new AndroidTestExtraParamsDialog(this.getProject(), AndroidFacet.getInstance((Module)module), TestRunParameters.this.myInstrumentationArgs.get());
                if (dialog2.showAndGet()) {
                    TestRunParameters.this.myUserModifiedInstrumentationExtraParams = dialog2.getUserModifiedInstrumentationExtraParams();
                    TestRunParameters.this.myInstrumentationArgs.set(dialog2.getInstrumentationExtraParams());
                    TestRunParameters.this.myContentWrapper.fireStateChanged();
                }
                return null;
            }
        }.setField((ComponentWithBrowseButton)instrArgsTextField);
        ((EditorTextField)instrArgsTextField.getChildComponent()).setEnabled(false);
        this.myInstrumentationArgs = new TextProperty((EditorTextField)instrArgsTextField.getChildComponent());
        this.myInstrumentationArgsComponent.setComponent((JComponent)((Object)instrArgsTextField));
        this.myContentWrapper = new ContentWrapper();
        this.myContentWrapper.add(this.myContentPanel);
    }

    @Override
    public void applyTo(AndroidTestRunConfiguration configuration2) {
        configuration2.TESTING_TYPE = this.mySelectedTestType.get();
        configuration2.PACKAGE_NAME = this.myTestPackage.get();
        configuration2.CLASS_NAME = this.myTestClass.get();
        configuration2.METHOD_NAME = this.myTestMethod.get();
        configuration2.TEST_NAME_REGEX = this.myTestRegex.get();
        configuration2.INSTRUMENTATION_RUNNER_CLASS = this.canSelectInstrumentationRunnerClass ? this.myInstrumentationClass.get() : "";
        configuration2.EXTRA_OPTIONS = this.myUserModifiedInstrumentationExtraParams;
    }

    @Override
    public void resetFrom(AndroidTestRunConfiguration configuration2) {
        AndroidFacet androidFacet = Optional.ofNullable(this.myModuleSelector.getModule()).map(AndroidFacet::getInstance).orElse(null);
        this.mySelectedTestType.set(configuration2.TESTING_TYPE);
        this.myTestPackage.set(configuration2.PACKAGE_NAME);
        this.myTestClass.set(configuration2.CLASS_NAME);
        this.myTestMethod.set(configuration2.METHOD_NAME);
        this.myTestRegex.set(configuration2.TEST_NAME_REGEX);
        this.myInstrumentationClass.set(this.canSelectInstrumentationRunnerClass ? configuration2.INSTRUMENTATION_RUNNER_CLASS : AndroidTestRunConfiguration.getDefaultInstrumentationRunner(androidFacet));
        this.myInstrumentationArgs.set(configuration2.getExtraInstrumentationOptions(androidFacet));
        this.myUserModifiedInstrumentationExtraParams = configuration2.EXTRA_OPTIONS;
    }

    @Override
    public Component getComponent() {
        return this.myContentWrapper;
    }

    public void dispose() {
        this.myBindingsManager.releaseAll();
    }

    private void setupUI() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(7, 6, new Insets(0, 0, 0, 0), -1, -1));
        this.myAllInPackageTestButton = new JRadioButton();
        this.myAllInPackageTestButton.setActionCommand(ExecutionBundle.message((String)"jnit.configuration.all.tests.in.package.radio", (Object[])new Object[0]));
        this.loadButtonText(this.myAllInPackageTestButton, AndroidBundle.message("android.run.configuration.all.in.package.radio", new Object[0]));
        this.myContentPanel.add((Component)this.myAllInPackageTestButton, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myClassTestButton = new JRadioButton();
        this.myClassTestButton.setActionCommand(ExecutionBundle.message((String)"junit.configuration.test.class.radio", (Object[])new Object[0]));
        this.myClassTestButton.setEnabled(true);
        this.myClassTestButton.setSelected(false);
        this.loadButtonText(this.myClassTestButton, AndroidBundle.message("android.run.configuration.class.radio", new Object[0]));
        this.myContentPanel.add((Component)this.myClassTestButton, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myMethodTestButton = new JRadioButton();
        this.myMethodTestButton.setActionCommand(ExecutionBundle.message((String)"junit.configuration.test.method.radio", (Object[])new Object[0]));
        this.myMethodTestButton.setSelected(false);
        this.loadButtonText(this.myMethodTestButton, AndroidBundle.message("android.run.configuration.method.radio", new Object[0]));
        this.myContentPanel.add((Component)this.myMethodTestButton, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setHorizontalAlignment(2);
        jBLabel1.setHorizontalTextPosition(2);
        jBLabel1.setIconTextGap(4);
        this.loadLabelText((JLabel)jBLabel1, ExecutionBundle.message((String)"junit.configuration.configure.junit.test.label", (Object[])new Object[0]));
        this.myContentPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myContentPanel.add((Component)spacer1, new GridConstraints(0, 5, 1, 1, 0, 1, 5, 1, null, null, null, 0, false));
        this.myAllInModuleTestButton = new JRadioButton();
        this.loadButtonText(this.myAllInModuleTestButton, AndroidBundle.message("android.run.configuration.all.in.module.radio", new Object[0]));
        this.myContentPanel.add((Component)this.myAllInModuleTestButton, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myTestPackageComponent = new LabeledComponent();
        this.myTestPackageComponent.setComponentClass("javax.swing.JPanel");
        this.myTestPackageComponent.setLabelLocation("West");
        this.myTestPackageComponent.setText(AndroidBundle.message("android.run.configuration.package.label", new Object[0]));
        this.myContentPanel.add((Component)this.myTestPackageComponent, new GridConstraints(1, 0, 1, 6, 0, 1, 3, 0, null, null, null, 0, false));
        this.myTestClassComponent = new LabeledComponent();
        this.myTestClassComponent.setComponentClass("javax.swing.JPanel");
        this.myTestClassComponent.setLabelLocation("West");
        this.myTestClassComponent.setText(AndroidBundle.message("android.run.configuration.class.label", new Object[0]));
        this.myContentPanel.add((Component)this.myTestClassComponent, new GridConstraints(2, 0, 1, 6, 0, 1, 3, 0, null, null, null, 0, false));
        this.myTestMethodComponent = new LabeledComponent();
        this.myTestMethodComponent.setComponentClass("javax.swing.JPanel");
        this.myTestMethodComponent.setLabelLocation("West");
        this.myTestMethodComponent.setText(AndroidBundle.message("android.run.configuration.method.label", new Object[0]));
        this.myContentPanel.add((Component)this.myTestMethodComponent, new GridConstraints(3, 0, 1, 6, 0, 1, 3, 0, null, null, null, 0, false));
        this.myTestRegexComponent = new LabeledComponent();
        this.myTestRegexComponent.setComponentClass("javax.swing.JPanel");
        this.myTestRegexComponent.setLabelLocation("West");
        this.myTestRegexComponent.setText("Regex");
        this.myContentPanel.add((Component)this.myTestRegexComponent, new GridConstraints(4, 0, 1, 6, 0, 1, 3, 0, null, null, null, 0, false));
        this.myInstrumentationClassComponent = new LabeledComponent();
        this.myInstrumentationClassComponent.setComponentClass("javax.swing.JPanel");
        this.myInstrumentationClassComponent.setEnabled(true);
        this.myInstrumentationClassComponent.setLabelLocation("West");
        this.myInstrumentationClassComponent.setText(AndroidBundle.message("android.test.run.configuration.instrumentation.label", new Object[0]));
        this.myContentPanel.add((Component)this.myInstrumentationClassComponent, new GridConstraints(5, 0, 1, 6, 0, 1, 3, 0, null, null, null, 0, false));
        this.myInstrumentationArgsComponent = new LabeledComponent();
        this.myInstrumentationArgsComponent.setComponentClass("javax.swing.JPanel");
        this.myInstrumentationArgsComponent.setLabelLocation("West");
        this.myInstrumentationArgsComponent.setText("Instrumentation arguments");
        this.myContentPanel.add((Component)this.myInstrumentationArgsComponent, new GridConstraints(6, 0, 1, 6, 0, 1, 3, 0, null, null, null, 0, false));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myAllInModuleTestButton);
        buttonGroup.add(this.myAllInPackageTestButton);
        buttonGroup.add(this.myClassTestButton);
        buttonGroup.add(this.myMethodTestButton);
    }

    private void loadLabelText(JLabel component, String text2) {
        TextWithMnemonic textWithMnemonic = TextWithMnemonic.parse((String)text2);
        component.setText(textWithMnemonic.getText());
        if (textWithMnemonic.hasMnemonic()) {
            component.setDisplayedMnemonic(textWithMnemonic.getMnemonicCode());
            component.setDisplayedMnemonicIndex(textWithMnemonic.getMnemonicIndex());
        }
    }

    private void loadButtonText(AbstractButton component, String text2) {
        TextWithMnemonic textWithMnemonic = TextWithMnemonic.parse((String)text2);
        component.setText(textWithMnemonic.getText());
        if (textWithMnemonic.hasMnemonic()) {
            component.setMnemonic(textWithMnemonic.getMnemonicCode());
            component.setDisplayedMnemonicIndex(textWithMnemonic.getMnemonicIndex());
        }
    }

    public static interface TestRunParametersToken<P extends AndroidProjectSystem>
    extends Token {
        public static final ExtensionPointName<TestRunParametersToken<AndroidProjectSystem>> EP_NAME = new ExtensionPointName("com.android.tools.idea.run.editor.testRunParametersToken");

        public boolean canSelectInstrumentationRunnerClass(@NotNull P var1);

        @NotNull
        default public Module getModuleForPackageChooser(@NotNull P projectSystem, @NotNull Module module) {
            return module;
        }

        @NotNull
        public static Module getModuleForPackageChooser(@NotNull Module module) {
            Project project = module.getProject();
            AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem(project);
            return EP_NAME.getExtensionList().stream().filter(it -> it.isApplicable(projectSystem)).findFirst().map(it -> it.getModuleForPackageChooser(projectSystem, module)).orElse(module);
        }
    }

    private static class SimpleEditorTextFieldWithBrowseButton
    extends ComponentWithBrowseButton<EditorTextField>
    implements TextAccessor {
        SimpleEditorTextFieldWithBrowseButton() {
            super((JComponent)new EditorTextField(), null);
        }

        public void setText(String text2) {
            ((EditorTextField)this.getChildComponent()).setText(StringUtil.notNullize((String)text2));
        }

        @NotNull
        public String getText() {
            return ((EditorTextField)this.getChildComponent()).getText();
        }
    }

    private static class ContentWrapper
    extends JPanel
    implements UserActivityProviderComponent {
        private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        private ContentWrapper() {
            super(new BorderLayout());
        }

        public void addChangeListener(@NotNull ChangeListener changeListener) {
            this.myListeners.add(changeListener);
        }

        public void removeChangeListener(@NotNull ChangeListener changeListener) {
            this.myListeners.remove(changeListener);
        }

        public void fireStateChanged() {
            for (ChangeListener listener2 : this.myListeners) {
                listener2.stateChanged(new ChangeEvent(this));
            }
        }
    }
}

