/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.profiler;

import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CpuProfilerConfigsState", storages={@Storage(value="cpuProfilingConfigs.xml")})
public class CpuProfilerConfigsState
implements PersistentStateComponent<CpuProfilerConfigsState> {
    @NotNull
    private List<CpuProfilerConfig> myUserConfigs = new ArrayList<CpuProfilerConfig>();
    @NotNull
    private List<CpuProfilerConfig> myTaskConfigs = new ArrayList<CpuProfilerConfig>();

    @NotNull
    public static CpuProfilerConfigsState getInstance(Project project) {
        return (CpuProfilerConfigsState)project.getService(CpuProfilerConfigsState.class);
    }

    @NotNull
    public List<CpuProfilerConfig> getUserConfigs() {
        return this.myUserConfigs;
    }

    public void setUserConfigs(@NotNull List<CpuProfilerConfig> configs) {
        this.myUserConfigs = configs;
    }

    @NotNull
    public List<CpuProfilerConfig> getSavedTaskConfigsIfPresentOrDefault() {
        if (this.myTaskConfigs.isEmpty()) {
            return CpuProfilerConfigsState.getTaskDefaultConfigs();
        }
        return this.myTaskConfigs;
    }

    @NotNull
    public List<CpuProfilerConfig> getTaskConfigs() {
        return this.myTaskConfigs;
    }

    public void setTaskConfigs(@NotNull List<CpuProfilerConfig> configs) {
        this.myTaskConfigs = configs;
    }

    public boolean addUserConfig(@NotNull CpuProfilerConfig config) {
        if (this.getConfigByName(config.getName()) == null) {
            this.myUserConfigs.add(config);
            return true;
        }
        return false;
    }

    public CpuProfilerConfig getNativeAllocationsConfigForTaskConfig() {
        Optional<CpuProfilerConfig> nativeAllocationsConfig = this.myTaskConfigs.stream().filter(x -> CpuProfilerConfig.Technology.NATIVE_ALLOCATIONS.getName().equals(x.getName())).findFirst();
        if (!nativeAllocationsConfig.isPresent()) {
            return new CpuProfilerConfig(CpuProfilerConfig.Technology.NATIVE_ALLOCATIONS);
        }
        return nativeAllocationsConfig.get();
    }

    @NotNull
    public static List<CpuProfilerConfig> getDefaultConfigs() {
        ImmutableList.Builder configs = new ImmutableList.Builder().add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.SAMPLED_NATIVE)).add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.SYSTEM_TRACE)).add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.INSTRUMENTED_JAVA)).add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.SAMPLED_JAVA));
        return configs.build();
    }

    @NotNull
    public static List<CpuProfilerConfig> getTaskDefaultConfigs() {
        ImmutableList.Builder configs = new ImmutableList.Builder().add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.SAMPLED_NATIVE)).add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.INSTRUMENTED_JAVA)).add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.SAMPLED_JAVA)).add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.NATIVE_ALLOCATIONS)).add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.SYSTEM_TRACE));
        return configs.build();
    }

    @NotNull
    public List<CpuProfilerConfig> getConfigs() {
        return ImmutableList.builder().addAll(this.getSavedTaskConfigsIfPresentOrDefault()).addAll(this.getUserConfigs()).build();
    }

    @Nullable
    public CpuProfilerConfig getConfigByName(@NotNull String name2) {
        return this.getConfigs().stream().filter(c -> name2.equals(c.getName())).findFirst().orElse(null);
    }

    @Nullable
    public CpuProfilerConfigsState getState() {
        return this;
    }

    public void loadState(CpuProfilerConfigsState state2) {
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }
}

