/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.InstallOptions;
import com.android.tools.deployer.model.App;
import com.android.tools.deployer.tasks.Canceller;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.tasks.AbstractDeployTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DeployTask
extends AbstractDeployTask {
    private static final Logger LOG = Logger.getInstance(DeployTask.class);
    public static final String ID = "DEPLOY";
    private final String[] userInstallOptions;
    private final boolean installOnAllUsers;

    public DeployTask(@NotNull Project project, @NotNull Collection<ApkInfo> packages, String userInstallOptions, boolean installOnAllUsers, boolean alwaysInstallWithPm, boolean allowAssumeVerified, boolean hasMakeBeforeRun) {
        super(project, packages, false, alwaysInstallWithPm, allowAssumeVerified, hasMakeBeforeRun);
        if (userInstallOptions != null && !userInstallOptions.isEmpty()) {
            userInstallOptions = userInstallOptions.trim();
            this.userInstallOptions = userInstallOptions.split("\\s");
        } else {
            this.userInstallOptions = new String[0];
        }
        this.installOnAllUsers = installOnAllUsers;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    protected Deployer.Result perform(IDevice device2, Deployer deployer, @NotNull ApkInfo apkInfo, @NotNull Canceller canceller) throws DeployerException {
        boolean isDontKillNeed;
        Set<ApkInfo.AppInstallOption> requiredInstallOptions;
        InstallOptions.Builder options = InstallOptions.builder().setAllowDebuggable();
        if (!this.installOnAllUsers && device2.getVersion().isAtLeast(24)) {
            options.setInstallOnUser("current");
        }
        if (device2.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
            options.setGrantAllPermissions();
        }
        if ((requiredInstallOptions = apkInfo.getRequiredInstallOptions()).contains((Object)ApkInfo.AppInstallOption.GRANT_ALL_PERMISSIONS) && device2.getVersion().isAtLeast(ApkInfo.AppInstallOption.GRANT_ALL_PERMISSIONS.minSupportedApiLevel)) {
            options.setGrantAllPermissions();
        }
        if (requiredInstallOptions.contains((Object)ApkInfo.AppInstallOption.FORCE_QUERYABLE) && device2.getVersion().isAtLeast(ApkInfo.AppInstallOption.FORCE_QUERYABLE.minSupportedApiLevel)) {
            options.setForceQueryable();
        }
        if (device2.getVersion().isAtLeast(28)) {
            options.setInstallFullApk();
        }
        boolean isDontKillSupported = device2.getVersion().isAtLeast(24);
        boolean bl = isDontKillNeed = (Boolean)StudioFlags.INSTALL_USE_PM_TERMINATE.get() == false || !device2.getVersion().isAtLeast(33);
        if (isDontKillSupported && isDontKillNeed) {
            options.setDontKill();
        }
        boolean useAssumeVerified = this.myAllowAssumeVerified && device2.getVersion().isAtLeast(35);
        options.setShouldUseAssumeVerified(useAssumeVerified);
        if (this.userInstallOptions != null) {
            options.setUserInstallOptions(this.userInstallOptions);
        }
        options.setSkipVerification(device2, apkInfo.getApplicationId());
        LOG.info("Installing application: " + apkInfo.getApplicationId());
        Deployer.InstallMode installMode = Deployer.InstallMode.DELTA;
        if (!((Boolean)StudioFlags.DELTA_INSTALL.get()).booleanValue()) {
            installMode = Deployer.InstallMode.FULL;
        }
        options.setCancelChecker(canceller);
        App app = DeployTask.getAppToInstall(apkInfo);
        Deployer.Result result2 = deployer.install(app, options.build(), installMode);
        if (!result2.skippedInstall && isDontKillSupported && isDontKillNeed) {
            device2.forceStop(app.getAppId());
        }
        return result2;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Install";
    }

    @Override
    @NotNull
    protected String createSkippedApkInstallMessage(List<String> skippedApkList, boolean all) {
        if (all) {
            return "App restart successful without requiring a re-install.";
        }
        return "App restart successful without re-installing the following APK(s): " + skippedApkList.stream().collect(Collectors.joining(", "));
    }
}

