/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.util.EmbeddedDistributionPaths;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Jdks {
    @NotNull
    private static final Logger LOG = Logger.getInstance(Jdks.class);
    @NotNull
    private final IdeInfo myIdeInfo;

    @NotNull
    public static Jdks getInstance() {
        return (Jdks)ApplicationManager.getApplication().getService(Jdks.class);
    }

    public Jdks() {
        this(IdeInfo.getInstance());
    }

    @NonInjectable
    @VisibleForTesting
    public Jdks(@NotNull IdeInfo ideInfo) {
        this.myIdeInfo = ideInfo;
    }

    @Nullable
    public JavaSdkVersion findVersion(@NotNull Path jdkRoot) {
        return this.getVersion(jdkRoot.toString());
    }

    @Nullable
    public JavaSdkVersion getVersion(@NotNull String jdkRoot) {
        String version2 = JavaSdk.getInstance().getVersionString(jdkRoot);
        return StringUtil.isEmpty((String)version2) ? null : JavaSdkVersion.fromVersionString((String)version2);
    }

    @Nullable
    public Sdk createAndAddJdk(@NotNull String jdkHomePath) {
        VirtualFile sdkHome = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)jdkHomePath));
        if (sdkHome == null) {
            LOG.error(String.format("Unable to create JDK from path '%1$s'", jdkHomePath));
            return null;
        }
        Sdk newSdk = SdkConfigurationUtil.setupSdk((Sdk[])ProjectJdkTable.getInstance().getAllJdks(), (VirtualFile)sdkHome, (SdkType)JavaSdk.getInstance(), (boolean)true, null, null);
        if (newSdk != null) {
            ApplicationManager.getApplication().invokeAndWait(() -> SdkConfigurationUtil.addSdk((Sdk)newSdk));
        }
        return newSdk;
    }

    @Nullable
    public Sdk createEmbeddedJdk() {
        if (this.myIdeInfo.isAndroidStudio()) {
            Path path = EmbeddedDistributionPaths.getInstance().tryToGetEmbeddedJdkPath();
            if (path == null) {
                return null;
            }
            Sdk jdk = this.createAndAddJdk(path.toString());
            assert (jdk != null);
            return jdk;
        }
        return null;
    }
}

