/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install;

import com.android.repository.api.InstallerFactory;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.installer.BasicInstallerFactory;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.install.StudioSdkInstallListenerFactory;
import com.google.common.annotations.VisibleForTesting;
import org.jetbrains.annotations.NotNull;

public final class StudioSdkInstallerUtil {
    private final SettingsController mySettingsController;

    @NotNull
    public static InstallerFactory createInstallerFactory(@NotNull AndroidSdkHandler sdkHandler) {
        return new StudioSdkInstallerUtil().doCreateInstallerFactory(sdkHandler);
    }

    @VisibleForTesting
    @NotNull
    InstallerFactory doCreateInstallerFactory(@NotNull AndroidSdkHandler sdkHandler) {
        BasicInstallerFactory factory2 = new BasicInstallerFactory();
        factory2.setListenerFactory((InstallerFactory.StatusChangeListenerFactory)new StudioSdkInstallListenerFactory(sdkHandler));
        return factory2;
    }

    private StudioSdkInstallerUtil() {
        this(StudioSettingsController.getInstance());
    }

    @VisibleForTesting
    StudioSdkInstallerUtil(@NotNull SettingsController settingsController) {
        this.mySettingsController = settingsController;
    }
}

