/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.ProgressIndicator;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.wizard.AehdWizardController;
import com.android.tools.idea.sdk.wizard.legacy.LicenseAgreementStep;
import com.android.tools.idea.welcome.install.AehdSdkComponentTreeNode;
import com.android.tools.idea.welcome.wizard.FirstRunWizardTracker;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.welcome.wizard.deprecated.AbstractProgressStep;
import com.android.tools.idea.welcome.wizard.deprecated.AehdInstallInfoStep;
import com.android.tools.idea.welcome.wizard.deprecated.AehdUninstallInfoStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.google.wireless.android.sdk.stats.SetupWizardEvent;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class AehdWizard
extends DynamicWizard {
    @NotNull
    private final AehdPath myAehdPath;
    @NotNull
    private final AehdSdkComponentTreeNode.InstallationIntention myInstallationIntention;
    @NotNull
    private final AehdWizardController myAehdWizardController;
    @NotNull
    private final FirstRunWizardTracker myTracker;

    public AehdWizard(@NotNull AehdSdkComponentTreeNode.InstallationIntention installationIntention, @NotNull AehdWizardController aehdWizardController, @NotNull FirstRunWizardTracker tracker) {
        super(null, null, "AEHD");
        this.myInstallationIntention = installationIntention;
        this.myTracker = tracker;
        this.myAehdPath = new AehdPath();
        this.myAehdWizardController = aehdWizardController;
        this.addPath(this.myAehdPath);
    }

    @Override
    public void init() {
        this.myTracker.trackWizardStarted();
        super.init();
    }

    @Override
    public void performFinishingActions() {
    }

    @Override
    public void doCancelAction() {
        if (this.myAehdPath.canPerformFinishingActions()) {
            this.doFinishAction();
            return;
        }
        this.myAehdWizardController.handleCancel(this.myInstallationIntention, this.myAehdPath.myAehdSdkComponentTreeNode, LOG);
        super.doCancelAction();
        this.myTracker.trackWizardFinished(SetupWizardEvent.CompletionStatus.CANCELED);
    }

    @Override
    public void doFinishAction() {
        if (!this.myAehdPath.canPerformFinishingActions()) {
            this.doCancelAction();
            return;
        }
        super.doFinishAction();
        this.myTracker.trackWizardFinished(SetupWizardEvent.CompletionStatus.FINISHED);
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        return "Finishing install...";
    }

    @Override
    protected String getWizardActionDescription() {
        return "AEHD Installation";
    }

    private class AehdPath
    extends DynamicWizardPath {
        @NotNull
        SetupProgressStep mySetupProgressStep;
        @NotNull
        AehdSdkComponentTreeNode myAehdSdkComponentTreeNode;
        private LicenseAgreementStep myLicenseAgreementStep;

        private AehdPath() {
        }

        @Override
        protected void init() {
            this.myAehdSdkComponentTreeNode = new AehdSdkComponentTreeNode(AehdWizard.this.myInstallationIntention);
            this.addStep(this.getInfoStep(AehdWizard.this.myInstallationIntention));
            if (AehdWizard.this.myInstallationIntention != AehdSdkComponentTreeNode.InstallationIntention.UNINSTALL) {
                this.myLicenseAgreementStep = new LicenseAgreementStep(this.getWizard().getDisposable(), () -> this.myAehdSdkComponentTreeNode.getRequiredSdkPackages(), () -> ((AndroidSdks)AndroidSdks.getInstance()).tryToChooseSdkHandler(), AehdWizard.this.myTracker);
                this.addStep(this.myLicenseAgreementStep);
            }
            this.mySetupProgressStep = new SetupProgressStep(this.getWizard().getDisposable(), this.myAehdSdkComponentTreeNode, AehdWizard.this.myHost, AehdWizard.this.myAehdWizardController, AehdWizard.this.myTracker);
            this.addStep(this.mySetupProgressStep);
        }

        @Override
        @NotNull
        public String getPathName() {
            return "AEHD Path";
        }

        @Override
        public boolean canPerformFinishingActions() {
            return this.mySetupProgressStep.isSuccessfullyCompleted();
        }

        @Override
        public boolean performFinishingActions() {
            if (this.myLicenseAgreementStep != null) {
                this.myLicenseAgreementStep.performFinishingActions();
            }
            return true;
        }

        private DynamicWizardStep getInfoStep(AehdSdkComponentTreeNode.InstallationIntention installationIntention) {
            return switch (installationIntention) {
                default -> throw new MatchException(null, null);
                case AehdSdkComponentTreeNode.InstallationIntention.UNINSTALL -> new AehdUninstallInfoStep(AehdWizard.this.myTracker);
                case AehdSdkComponentTreeNode.InstallationIntention.INSTALL_WITH_UPDATES, AehdSdkComponentTreeNode.InstallationIntention.INSTALL_WITHOUT_UPDATES, AehdSdkComponentTreeNode.InstallationIntention.CONFIGURE_ONLY -> new AehdInstallInfoStep(AehdWizard.this.myTracker);
            };
        }
    }

    private static class SetupProgressStep
    extends AbstractProgressStep
    implements ProgressStep {
        @NotNull
        private AehdSdkComponentTreeNode myAehdSdkComponentTreeNode;
        @NotNull
        private final AtomicBoolean myIsSuccessfullyCompleted = new AtomicBoolean(false);
        @NotNull
        private DynamicWizardHost myHost;
        @NotNull
        private StudioLoggerProgressIndicator myProgressIndicator;
        @NotNull
        private final AehdWizardController myAehdWizardController;

        SetupProgressStep(@NotNull Disposable parentDisposable, @NotNull AehdSdkComponentTreeNode aehdSdkComponentTreeNode, @NotNull DynamicWizardHost host, @NotNull AehdWizardController aehdWizardController, @NotNull FirstRunWizardTracker tracker) {
            super(parentDisposable, "Invoking installer", tracker);
            this.myAehdSdkComponentTreeNode = aehdSdkComponentTreeNode;
            this.myHost = host;
            this.myProgressIndicator = new StudioLoggerProgressIndicator(this.getClass());
            this.myAehdWizardController = aehdWizardController;
        }

        @Override
        public boolean canGoNext() {
            return false;
        }

        public boolean isSuccessfullyCompleted() {
            return this.myIsSuccessfullyCompleted.get();
        }

        @Override
        protected void execute() {
            this.myHost.runSensitiveOperation(this.getProgressIndicator(), true, () -> {
                this.myTracker.trackInstallingComponentsStarted();
                try {
                    this.myTracker.trackSdkComponentsToInstall(List.of(this.myAehdSdkComponentTreeNode.sdkComponentsMetricKind()));
                    boolean success = this.myAehdWizardController.setupAehd(this.myAehdSdkComponentTreeNode, this, (ProgressIndicator)this.myProgressIndicator);
                    this.myIsSuccessfullyCompleted.set(success);
                }
                catch (Exception e) {
                    DynamicWizard.LOG.warn("Exception caught while trying to configure AEHD", (Throwable)e);
                    this.showConsole();
                    this.print(e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                }
                finally {
                    if (this.isCanceled()) {
                        this.myTracker.trackInstallingComponentsFinished(SetupWizardEvent.SdkInstallationMetrics.SdkInstallationResult.CANCELED);
                    } else if (this.myIsSuccessfullyCompleted.get()) {
                        this.myTracker.trackInstallingComponentsFinished(SetupWizardEvent.SdkInstallationMetrics.SdkInstallationResult.SUCCESS);
                    } else {
                        this.myTracker.trackInstallingComponentsFinished(SetupWizardEvent.SdkInstallationMetrics.SdkInstallationResult.ERROR);
                    }
                }
            });
        }

        @Override
        public boolean canGoPrevious() {
            return false;
        }

        @Override
        protected SetupWizardEvent.WizardStep.WizardStepKind getWizardStepKind() {
            return SetupWizardEvent.WizardStep.WizardStepKind.INSTALL_SDK;
        }
    }
}

