/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.License;
import com.android.repository.api.RemotePackage;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LicenseAgreementStep
extends ModelWizardStep<LicenseAgreementModel> {
    private JTextPane myLicenseTextField;
    private Tree myChangeTree;
    private JBRadioButton myDeclineRadioButton;
    private JBRadioButton myAcceptRadioButton;
    private JPanel myRootPanel;
    private Splitter splitter;
    private JPanel optionsPanel;
    private JBScrollPane myTreeScroll;
    private JBScrollPane myLicensePane;
    private DefaultTreeModel myTreeModel = new DefaultTreeModel(null);
    @Nullable
    private String myCurrentLicense;
    private final Map<String, Boolean> myAcceptances = Maps.newHashMap();
    private final Set<String> myVisibleLicenses = Sets.newHashSet();
    private final Supplier<Collection<RemotePackage>> myInstallRequestsSupplier;
    private final BoolProperty myAllLicensesAreAccepted = new BoolValueProperty();
    private final boolean mySelectedByDefault;

    public LicenseAgreementStep(@NotNull LicenseAgreementModel model, @NotNull Supplier<Collection<RemotePackage>> installRequestsSupplier) {
        this(model, installRequestsSupplier, JBUI.emptyInsets(), false);
    }

    public LicenseAgreementStep(@NotNull LicenseAgreementModel model, @NotNull Supplier<Collection<RemotePackage>> installRequestsSupplier, @NotNull JBInsets borderInsets) {
        this(model, installRequestsSupplier, borderInsets, false);
    }

    public LicenseAgreementStep(@NotNull LicenseAgreementModel model, @NotNull Supplier<Collection<RemotePackage>> installRequestsSupplier, @NotNull JBInsets borderInsets, boolean selectedByDefault) {
        super(model, "License Agreement");
        this.setupUI(borderInsets);
        this.myInstallRequestsSupplier = installRequestsSupplier;
        this.mySelectedByDefault = selectedByDefault;
        if (this.mySelectedByDefault) {
            boolean isTesting;
            boolean bl = isTesting = GuiTestingService.getInstance().isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode();
            if (!isTesting) {
                throw new IllegalStateException("Licenses can only be selected by default when running tests");
            }
        }
    }

    public void reload() {
        this.setChanges(this.createChangesList());
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard2) {
        this.createUI();
        this.initUI();
    }

    private void createUI() {
        this.splitter.setHonorComponentsMinimumSize(true);
        ButtonGroup optionsGroup = new ButtonGroup();
        optionsGroup.add((AbstractButton)this.myDeclineRadioButton);
        optionsGroup.add((AbstractButton)this.myAcceptRadioButton);
        this.myRootPanel.add((Component)this.splitter, "Center");
        this.myRootPanel.add((Component)this.optionsPanel, "South");
        this.myLicenseTextField.setFont(StartupUiUtil.getLabelFont());
    }

    private void initUI() {
        this.myChangeTree.setModel((TreeModel)this.myTreeModel);
        this.myChangeTree.setShowsRootHandles(false);
        this.myLicenseTextField.setEditable(false);
        SelectedProperty accepted = new SelectedProperty((AbstractButton)this.myAcceptRadioButton);
        accepted.addListener(() -> {
            this.myAcceptances.put(this.myCurrentLicense, accepted.get());
            this.checkAllLicensesAreAccepted();
            this.myChangeTree.repaint();
        });
        this.myChangeTree.addTreeSelectionListener(this.createTreeSelectionListener());
        this.myChangeTree.setCellRenderer((TreeCellRenderer)this.createCellRenderer());
        this.setChanges(this.createChangesList());
    }

    private TreeSelectionListener createTreeSelectionListener() {
        return e -> {
            DefaultMutableTreeNode selected = (DefaultMutableTreeNode)this.myChangeTree.getLastSelectedPathComponent();
            if (selected != null && selected.isRoot()) {
                return;
            }
            if (selected != null && !selected.isLeaf()) {
                License license = (License)selected.getUserObject();
                this.myLicenseTextField.setText(license.getValue());
                this.myCurrentLicense = license.getId();
            } else if (selected != null && !selected.isRoot()) {
                Change change = (Change)selected.getUserObject();
                this.myLicenseTextField.setText(change.license.getValue());
                this.myCurrentLicense = change.license.getId();
            }
            if (this.myAcceptances.get(this.myCurrentLicense).booleanValue()) {
                this.myAcceptRadioButton.setSelected(true);
            } else {
                this.myDeclineRadioButton.setSelected(true);
            }
            this.myLicenseTextField.setCaretPosition(0);
        };
    }

    private ColoredTreeCellRenderer createCellRenderer() {
        return new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (row == 0) {
                    this.append("Licenses", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
                if (!leaf) {
                    License license = (License)node.getUserObject();
                    this.appendLicenseText(license, license.getId());
                } else {
                    Change change = (Change)node.getUserObject();
                    if (change == null) {
                        return;
                    }
                    this.appendLicenseText(change.license, change.toString());
                    this.setIcon(AllIcons.Actions.Download);
                }
            }

            private void appendLicenseText(@Nullable License license, String text2) {
                boolean notAccepted;
                boolean bl = notAccepted = license != null && LicenseAgreementStep.this.myAcceptances.get(license.getId()) == false;
                if (notAccepted) {
                    this.append("*", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.append(text2, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else {
                    this.append(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        };
    }

    private void expandTree() {
        for (int i = 0; i < this.myChangeTree.getRowCount(); ++i) {
            this.myChangeTree.expandRow(i);
        }
    }

    private void setChanges(List<Change> changes) {
        HashMap licenseNodeMap = Maps.newHashMap();
        this.myVisibleLicenses.clear();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultMutableTreeNode firstChild = null;
        for (Change change : changes) {
            String licenseRef = change.license.getId();
            this.myVisibleLicenses.add(licenseRef);
            if (!licenseNodeMap.containsKey(licenseRef)) {
                DefaultMutableTreeNode n = new DefaultMutableTreeNode(change.license);
                if (firstChild == null) {
                    firstChild = n;
                }
                licenseNodeMap.put(licenseRef, n);
                this.myAcceptances.put(licenseRef, this.mySelectedByDefault);
                root.add(n);
            }
            ((DefaultMutableTreeNode)licenseNodeMap.get(licenseRef)).add(new DefaultMutableTreeNode(change));
        }
        this.myTreeModel = new DefaultTreeModel(root);
        this.myChangeTree.setModel((TreeModel)this.myTreeModel);
        this.expandTree();
        if (firstChild != null) {
            this.myChangeTree.setSelectionPath(new TreePath(firstChild.getPath()));
        }
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myRootPanel;
    }

    @Override
    protected boolean shouldShow() {
        return !this.myVisibleLicenses.isEmpty() && !((LicenseAgreementModel)this.getModel()).getLicenses().isEmpty();
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myChangeTree;
    }

    private void checkAllLicensesAreAccepted() {
        this.myAllLicensesAreAccepted.set(true);
        for (String licenseRef : this.myVisibleLicenses) {
            if (this.myAcceptances.get(licenseRef).booleanValue()) continue;
            this.myAllLicensesAreAccepted.set(false);
            break;
        }
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myAllLicensesAreAccepted;
    }

    private List<Change> createChangesList() {
        Optional<Path> sdkRoot = ((LicenseAgreementModel)this.getModel()).getSdkRoot().get();
        if (sdkRoot.isEmpty()) {
            return Collections.emptyList();
        }
        ((LicenseAgreementModel)this.getModel()).getLicenses().clear();
        ArrayList<Change> toReturn = new ArrayList<Change>();
        Collection<RemotePackage> installRequests = this.myInstallRequestsSupplier.get();
        if (installRequests != null) {
            for (RemotePackage p : installRequests) {
                License license = p.getLicense();
                if (license == null) continue;
                ((LicenseAgreementModel)this.getModel()).getLicenses().add(license);
                if (license.checkAccepted(sdkRoot.get())) continue;
                toReturn.add(new Change(p, license));
            }
        }
        return toReturn;
    }

    private void createUIComponents() {
        this.optionsPanel = new JPanel(new FlowLayout(4));
    }

    private void setupUI(JBInsets borderInsets) {
        this.createUIComponents();
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout(new BorderLayout(0, 0));
        this.myRootPanel.setBorder(JBUI.Borders.empty((Insets)borderInsets));
        this.myRootPanel.setMaximumSize(new Dimension(1250, 937));
        this.myRootPanel.setMinimumSize(new Dimension(230, 160));
        this.myRootPanel.setPreferredSize(new Dimension(230, 160));
        this.splitter = new Splitter();
        this.splitter.setLayout((LayoutManager)new FlowLayout(1, 5, 5));
        this.splitter.setMaximumSize(new Dimension(1250, 937));
        this.splitter.setPreferredSize(new Dimension(230, 160));
        this.splitter.setProportion(0.3f);
        this.splitter.setShowDividerControls(false);
        this.splitter.setShowDividerIcon(false);
        this.myRootPanel.add((Component)this.splitter, "Center");
        this.myTreeScroll = new JBScrollPane();
        this.splitter.add((Component)this.myTreeScroll);
        this.myChangeTree = new Tree();
        this.myTreeScroll.setViewportView((Component)this.myChangeTree);
        this.myLicensePane = new JBScrollPane();
        this.splitter.add((Component)this.myLicensePane);
        this.myLicenseTextField = new JTextPane();
        this.myLicenseTextField.setAutoscrolls(false);
        this.myLicenseTextField.setEditable(false);
        this.myLicenseTextField.setMaximumSize(new Dimension(1250, 937));
        this.myLicenseTextField.setPreferredSize(new Dimension(230, 160));
        this.myLicenseTextField.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.FALSE);
        this.myLicenseTextField.putClientProperty("charset", "");
        this.myLicensePane.setViewportView((Component)this.myLicenseTextField);
        this.optionsPanel.setLayout(new FlowLayout(1, 5, 5));
        this.myRootPanel.add((Component)this.optionsPanel, "South");
        this.myDeclineRadioButton = new JBRadioButton();
        this.myDeclineRadioButton.setText("Decline");
        this.optionsPanel.add((Component)this.myDeclineRadioButton);
        this.myAcceptRadioButton = new JBRadioButton();
        this.myAcceptRadioButton.setText("Accept");
        this.optionsPanel.add((Component)this.myAcceptRadioButton);
        this.splitter.setFirstComponent((JComponent)this.myTreeScroll);
        this.splitter.setSecondComponent((JComponent)this.myLicensePane);
    }

    public JComponent getRootComponent() {
        return this.myRootPanel;
    }

    private static final class Change {
        public RemotePackage myPackage;
        public License license;

        public Change(@NotNull RemotePackage p, @NotNull License license) {
            this.myPackage = p;
            this.license = license;
        }

        public String toString() {
            return this.myPackage.getDisplayName();
        }
    }
}

