/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.live;

import androidx.sqlite.inspection.SqliteInspectorProtocol;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.sqlite.DatabaseInspectorMessenger;
import com.android.tools.idea.sqlite.databaseConnection.DatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.LazyLiveSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.LiveSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.PagedLiveSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.UtilsKt;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteStatementType;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/live/LiveDatabaseConnection;", "Lcom/android/tools/idea/sqlite/databaseConnection/DatabaseConnection;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "messenger", "Lcom/android/tools/idea/sqlite/DatabaseInspectorMessenger;", "id", "", "taskExecutor", "Ljava/util/concurrent/Executor;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/sqlite/DatabaseInspectorMessenger;ILjava/util/concurrent/Executor;)V", "close", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "readSchema", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "query", "Lcom/android/tools/idea/sqlite/databaseConnection/SqliteResultSet;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "execute", "app-inspection.inspectors.database"})
public final class LiveDatabaseConnection
implements DatabaseConnection {
    @NotNull
    private final DatabaseInspectorMessenger messenger;
    private final int id;
    @NotNull
    private final Executor taskExecutor;

    public LiveDatabaseConnection(@NotNull Disposable parentDisposable, @NotNull DatabaseInspectorMessenger messenger, int id2, @NotNull Executor taskExecutor) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)messenger, (String)"messenger");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        this.messenger = messenger;
        this.id = id2;
        this.taskExecutor = taskExecutor;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> close() {
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<SqliteSchema> readSchema() {
        SqliteInspectorProtocol.Command commands = SqliteInspectorProtocol.Command.newBuilder().setGetSchema(SqliteInspectorProtocol.GetSchemaCommand.newBuilder().setDatabaseId(this.id)).build();
        Intrinsics.checkNotNull((Object)commands);
        ListenableFuture<SqliteInspectorProtocol.Response> responseFuture = this.messenger.sendCommandAsync(commands);
        return FutureUtils.transform(responseFuture, (Executor)this.taskExecutor, LiveDatabaseConnection::readSchema$lambda$0);
    }

    @Override
    @NotNull
    public ListenableFuture<SqliteResultSet> query(@NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        LiveSqliteResultSet resultSet = switch (WhenMappings.$EnumSwitchMapping$0[sqliteStatement.getStatementType().ordinal()]) {
            case 1 -> new PagedLiveSqliteResultSet(sqliteStatement, this.messenger, this.id, this.taskExecutor);
            case 2, 3 -> new LazyLiveSqliteResultSet(sqliteStatement, this.messenger, this.id, this.taskExecutor);
            default -> throw new IllegalArgumentException("SqliteStatement must be of type SELECT, EXPLAIN or PRAGMA, but is " + sqliteStatement.getStatementType());
        };
        Disposer.register((Disposable)this, (Disposable)resultSet);
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)resultSet);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> execute(@NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        SqliteInspectorProtocol.Command queryCommand = UtilsKt.buildQueryCommand$default(sqliteStatement, this.id, null, 4, null);
        ListenableFuture<SqliteInspectorProtocol.Response> responseFuture = this.messenger.sendCommandAsync(queryCommand);
        return FutureUtils.transform(responseFuture, (Executor)this.taskExecutor, LiveDatabaseConnection::execute$lambda$1);
    }

    @Override
    public void dispose() {
        DatabaseConnection.super.dispose();
    }

    private static final SqliteSchema readSchema$lambda$0(SqliteInspectorProtocol.Response response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        List list = response2.getGetSchema().getTablesList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTablesList(...)");
        return UtilsKt.toSqliteSchema(list);
    }

    private static final Unit execute$lambda$1(SqliteInspectorProtocol.Response it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SqliteStatementType.values().length];
            try {
                nArray[SqliteStatementType.SELECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteStatementType.EXPLAIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteStatementType.PRAGMA_QUERY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

