/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.live;

import androidx.sqlite.inspection.SqliteInspectorProtocol;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.protobuf.ProtocolStringList;
import com.android.tools.idea.sqlite.DatabaseInspectorMessenger;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSetKt;
import com.android.tools.idea.sqlite.databaseConnection.live.LiveSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.UtilsKt;
import com.android.tools.idea.sqlite.model.ResultSetSqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteQueryResult;
import com.android.tools.idea.sqlite.model.SqliteRow;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/live/PagedLiveSqliteResultSet;", "Lcom/android/tools/idea/sqlite/databaseConnection/live/LiveSqliteResultSet;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "messenger", "Lcom/android/tools/idea/sqlite/DatabaseInspectorMessenger;", "connectionId", "", "taskExecutor", "Ljava/util/concurrent/Executor;", "<init>", "(Lcom/android/tools/idea/sqlite/model/SqliteStatement;Lcom/android/tools/idea/sqlite/DatabaseInspectorMessenger;ILjava/util/concurrent/Executor;)V", "columns", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "Lcom/android/tools/idea/sqlite/model/ResultSetSqliteColumn;", "getColumns", "()Lcom/google/common/util/concurrent/ListenableFuture;", "totalRowCount", "getTotalRowCount", "getRowBatch", "Lcom/android/tools/idea/sqlite/model/SqliteQueryResult;", "rowOffset", "rowBatchSize", "responseSizeByteLimitHint", "", "(IILjava/lang/Long;)Lcom/google/common/util/concurrent/ListenableFuture;", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nPagedLiveSqliteResultSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagedLiveSqliteResultSet.kt\ncom/android/tools/idea/sqlite/databaseConnection/live/PagedLiveSqliteResultSet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1563#2:71\n1634#2,2:72\n1573#2:74\n1604#2,4:75\n1636#2:79\n*S KotlinDebug\n*F\n+ 1 PagedLiveSqliteResultSet.kt\ncom/android/tools/idea/sqlite/databaseConnection/live/PagedLiveSqliteResultSet\n*L\n59#1:71\n59#1:72,2\n61#1:74\n61#1:75,4\n59#1:79\n*E\n"})
public final class PagedLiveSqliteResultSet
extends LiveSqliteResultSet {
    @NotNull
    private final SqliteStatement sqliteStatement;
    @NotNull
    private final Executor taskExecutor;

    public PagedLiveSqliteResultSet(@NotNull SqliteStatement sqliteStatement, @NotNull DatabaseInspectorMessenger messenger, int connectionId, @NotNull Executor taskExecutor) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        Intrinsics.checkNotNullParameter((Object)messenger, (String)"messenger");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        super(sqliteStatement, messenger, connectionId, taskExecutor);
        this.sqliteStatement = sqliteStatement;
        this.taskExecutor = taskExecutor;
    }

    @Override
    @NotNull
    public ListenableFuture<List<ResultSetSqliteColumn>> getColumns() {
        return UtilsKt.mapToColumns((ListenableFuture<SqliteInspectorProtocol.Response>)LiveSqliteResultSet.sendQueryCommand$default(this, this.toSelectLimitOffset(this.sqliteStatement, 0, 1), null, 2, null), this.taskExecutor);
    }

    @Override
    @NotNull
    public ListenableFuture<Integer> getTotalRowCount() {
        return FutureUtils.transform((ListenableFuture)LiveSqliteResultSet.sendQueryCommand$default(this, this.toRowCountStatement(this.sqliteStatement), null, 2, null), (Executor)this.taskExecutor, PagedLiveSqliteResultSet::_get_totalRowCount_$lambda$0);
    }

    @Override
    @NotNull
    public ListenableFuture<SqliteQueryResult> getRowBatch(int rowOffset, int rowBatchSize, @Nullable Long responseSizeByteLimitHint) {
        SqliteResultSetKt.checkOffsetAndSize(rowOffset, rowBatchSize);
        return FutureUtils.transform(this.sendQueryCommand(this.toSelectLimitOffset(this.sqliteStatement, rowOffset, rowBatchSize), responseSizeByteLimitHint), (Executor)this.taskExecutor, PagedLiveSqliteResultSet::getRowBatch$lambda$3);
    }

    private static final int _get_totalRowCount_$lambda$0(SqliteInspectorProtocol.Response response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        List list = response2.getQuery().getRowsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRowsList(...)");
        Object object = (SqliteInspectorProtocol.Row)CollectionsKt.firstOrNull((List)list);
        return object != null && (object = object.getValuesList()) != null && (object = (SqliteInspectorProtocol.CellValue)CollectionsKt.firstOrNull((List)object)) != null ? (int)object.getLongValue() : 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final SqliteQueryResult getRowBatch$lambda$3(SqliteInspectorProtocol.Response response2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        SqliteInspectorProtocol.QueryResponse query = response2.getQuery();
        ProtocolStringList columnNames = query.getColumnNamesList();
        List list = query.getRowsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRowsList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapIndexedTo$iv$iv;
            void it;
            SqliteInspectorProtocol.Row row = (SqliteInspectorProtocol.Row)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            List list2 = it.getValuesList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValuesList(...)");
            Iterable $this$mapIndexed$iv = list2;
            boolean $i$f$mapIndexed = false;
            Iterable iterable2 = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                void index;
                void cellValue;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                SqliteInspectorProtocol.CellValue cellValue2 = (SqliteInspectorProtocol.CellValue)item$iv$iv2;
                int n2 = n;
                Collection collection3 = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)cellValue);
                Object object = columnNames.get((int)index);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                collection3.add(UtilsKt.toSqliteColumnValue((SqliteInspectorProtocol.CellValue)cellValue, (String)object));
            }
            List sqliteColumnValues = (List)destination$iv$iv2;
            collection2.add(new SqliteRow(sqliteColumnValues));
        }
        List rows = (List)destination$iv$iv;
        return new SqliteQueryResult(rows, query.getIsForcedConnection());
    }
}

