/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.model;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.sqlite.model.DatabaseInspectorModel;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.intellij.openapi.application.ApplicationManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\f\u0010\u001d\u001a\u00020\u0014*\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/sqlite/model/DatabaseInspectorModelImpl;", "Lcom/android/tools/idea/sqlite/model/DatabaseInspectorModel;", "<init>", "()V", "listeners", "", "Lcom/android/tools/idea/sqlite/model/DatabaseInspectorModel$Listener;", "openDatabases", "", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId$Key;", "Lcom/android/tools/idea/sqlite/model/DatabaseInspectorModelImpl$OpenDatabase;", "closeDatabases", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "getOpenDatabaseIds", "", "getCloseDatabaseIds", "getDatabaseSchema", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "databaseId", "addDatabaseSchema", "", "sqliteSchema", "removeDatabaseSchema", "updateSchema", "newSchema", "clearDatabases", "addListener", "modelListener", "removeListener", "onDatabasesChanged", "OpenDatabase", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nDatabaseInspectorModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseInspectorModel.kt\ncom/android/tools/idea/sqlite/model/DatabaseInspectorModelImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1563#2:143\n1634#2,3:144\n1869#2,2:147\n1869#2,2:149\n1869#2,2:151\n1869#2,2:153\n1563#2:155\n1634#2,3:156\n*S KotlinDebug\n*F\n+ 1 DatabaseInspectorModel.kt\ncom/android/tools/idea/sqlite/model/DatabaseInspectorModelImpl\n*L\n68#1:143\n68#1:144,3\n89#1:147,2\n102#1:149,2\n111#1:151,2\n120#1:153,2\n139#1:155\n139#1:156,3\n*E\n"})
public final class DatabaseInspectorModelImpl
implements DatabaseInspectorModel {
    @NotNull
    private final List<DatabaseInspectorModel.Listener> listeners = new ArrayList();
    @NotNull
    private final Map<SqliteDatabaseId.Key, OpenDatabase> openDatabases = new LinkedHashMap();
    @NotNull
    private final Map<SqliteDatabaseId.Key, SqliteDatabaseId> closeDatabases = new LinkedHashMap();

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SqliteDatabaseId> getOpenDatabaseIds() {
        void $this$mapTo$iv$iv;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Iterable $this$map$iv = this.openDatabases.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OpenDatabase openDatabase = (OpenDatabase)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<SqliteDatabaseId> getCloseDatabaseIds() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return CollectionsKt.toList((Iterable)this.closeDatabases.values());
    }

    @Override
    @Nullable
    public SqliteSchema getDatabaseSchema(@NotNull SqliteDatabaseId databaseId) {
        Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
        ApplicationManager.getApplication().assertIsDispatchThread();
        OpenDatabase openDatabase = this.openDatabases.get(databaseId.key());
        return openDatabase != null ? openDatabase.getSchema() : null;
    }

    @Override
    public void addDatabaseSchema(@NotNull SqliteDatabaseId databaseId, @NotNull SqliteSchema sqliteSchema) {
        Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
        Intrinsics.checkNotNullParameter((Object)sqliteSchema, (String)"sqliteSchema");
        ApplicationManager.getApplication().assertIsDispatchThread();
        SqliteDatabaseId.Key key = databaseId.key();
        this.closeDatabases.remove(key);
        this.openDatabases.put(key, new OpenDatabase(databaseId, sqliteSchema));
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseInspectorModel.Listener it = (DatabaseInspectorModel.Listener)element$iv;
            boolean bl = false;
            this.onDatabasesChanged(it);
        }
    }

    @Override
    public void removeDatabaseSchema(@NotNull SqliteDatabaseId databaseId) {
        Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
        ApplicationManager.getApplication().assertIsDispatchThread();
        SqliteDatabaseId.Key key = databaseId.key();
        this.openDatabases.remove(key);
        if (databaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId) {
            this.closeDatabases.put(key, databaseId);
        }
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseInspectorModel.Listener it = (DatabaseInspectorModel.Listener)element$iv;
            boolean bl = false;
            this.onDatabasesChanged(it);
        }
    }

    @Override
    public void updateSchema(@NotNull SqliteDatabaseId databaseId, @NotNull SqliteSchema newSchema) {
        Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
        Intrinsics.checkNotNullParameter((Object)newSchema, (String)"newSchema");
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.openDatabases.get(databaseId.key());
        if (object == null || (object = ((OpenDatabase)object).getSchema()) == null) {
            return;
        }
        Object oldSchema = object;
        this.openDatabases.put(databaseId.key(), new OpenDatabase(databaseId, newSchema));
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseInspectorModel.Listener it = (DatabaseInspectorModel.Listener)element$iv;
            boolean bl = false;
            it.onSchemaChanged(databaseId, (SqliteSchema)oldSchema, newSchema);
        }
    }

    @Override
    public void clearDatabases() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.openDatabases.clear();
        this.closeDatabases.clear();
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseInspectorModel.Listener it = (DatabaseInspectorModel.Listener)element$iv;
            boolean bl = false;
            it.onDatabasesChanged(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
    }

    @Override
    public void addListener(@NotNull DatabaseInspectorModel.Listener modelListener2) {
        Intrinsics.checkNotNullParameter((Object)modelListener2, (String)"modelListener");
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.listeners.add(modelListener2);
        this.onDatabasesChanged(modelListener2);
    }

    @Override
    public void removeListener(@NotNull DatabaseInspectorModel.Listener modelListener2) {
        Intrinsics.checkNotNullParameter((Object)modelListener2, (String)"modelListener");
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.listeners.remove(modelListener2);
    }

    /*
     * WARNING - void declaration
     */
    private final void onDatabasesChanged(DatabaseInspectorModel.Listener $this$onDatabasesChanged) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.openDatabases.values();
        DatabaseInspectorModel.Listener listener2 = $this$onDatabasesChanged;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OpenDatabase openDatabase = (OpenDatabase)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getId());
        }
        listener2.onDatabasesChanged((List)destination$iv$iv, CollectionsKt.toList((Iterable)this.closeDatabases.values()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/sqlite/model/DatabaseInspectorModelImpl$OpenDatabase;", "", "id", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "schema", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "<init>", "(Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;Lcom/android/tools/idea/sqlite/model/SqliteSchema;)V", "getId", "()Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "getSchema", "()Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "app-inspection.inspectors.database"})
    private static final class OpenDatabase {
        @NotNull
        private final SqliteDatabaseId id;
        @NotNull
        private final SqliteSchema schema;

        public OpenDatabase(@NotNull SqliteDatabaseId id2, @NotNull SqliteSchema schema) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this.id = id2;
            this.schema = schema;
        }

        @NotNull
        public final SqliteDatabaseId getId() {
            return this.id;
        }

        @NotNull
        public final SqliteSchema getSchema() {
            return this.schema;
        }
    }
}

