/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.exportToFile;

import com.android.tools.idea.sqlite.DatabaseInspectorAnalyticsTracker;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.model.Delimiter;
import com.android.tools.idea.sqlite.model.ExportDialogParams;
import com.android.tools.idea.sqlite.model.ExportFormat;
import com.android.tools.idea.sqlite.model.ExportRequest;
import com.android.tools.idea.sqlite.model.ModelKt;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.ui.exportToFile.ExportToFileDialogLayout;
import com.android.tools.idea.sqlite.ui.exportToFile.ExportToFileDialogView;
import com.android.tools.idea.sqlite.ui.exportToFile.IOUtils;
import com.intellij.CommonBundle;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.jgoodies.common.base.Strings;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0014J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u001aH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\u001aH\u0002J\n\u0010,\u001a\u0004\u0018\u00010-H\u0002J\n\u0010.\u001a\u0004\u0018\u00010-H\u0002J\b\u0010/\u001a\u00020\u0016H\u0002J\b\u00100\u001a\u00020\u001aH\u0002J\b\u00101\u001a\u00020\u0016H\u0002J\b\u00102\u001a\u00020*H\u0002J\n\u00103\u001a\u0004\u0018\u000104H\u0002J\u0018\u00105\u001a\u0002062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u00107\u001a\u00020-H\u0002J\b\u00108\u001a\u00020\u001aH\u0014J\u0010\u0010=\u001a\u00020:2\u0006\u00109\u001a\u00020\u0016H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0018\u00109\u001a\u00020\u0016*\u00020:8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0018\u0010>\u001a\u00020\u0016*\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0018\u00109\u001a\u00020\u0016*\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010@\u00a8\u0006A"}, d2={"Lcom/android/tools/idea/sqlite/ui/exportToFile/ExportToFileDialogViewImpl;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lcom/android/tools/idea/sqlite/ui/exportToFile/ExportToFileDialogView;", "project", "Lcom/intellij/openapi/project/Project;", "params", "Lcom/android/tools/idea/sqlite/model/ExportDialogParams;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/sqlite/model/ExportDialogParams;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "listeners", "", "Lcom/android/tools/idea/sqlite/ui/exportToFile/ExportToFileDialogView$Listener;", "analyticsTracker", "Lcom/android/tools/idea/sqlite/DatabaseInspectorAnalyticsTracker;", "formatButtonGroup", "Ljavax/swing/ButtonGroup;", "delimiterLabel", "Lcom/intellij/ui/components/JBLabel;", "delimiterComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "", "saveLocationTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "show", "", "getHelpId", "addListener", "listener", "removeListener", "getStyle", "Lcom/intellij/openapi/ui/DialogWrapper$DialogStyle;", "createCenterPanel", "Ljavax/swing/JComponent;", "setUpSaveLocationValidation", "locationTextField", "Ljavax/swing/JTextField;", "showSaveFileDialog", "createFormatButton", "Ljavax/swing/JRadioButton;", "format", "Lcom/android/tools/idea/sqlite/model/ExportFormat;", "updateDelimiterEnabled", "parseSaveLocationTextFieldPath", "Ljava/nio/file/Path;", "createSuggestedPath", "createFileName", "updateDestinationExtension", "selectedFormatExtension", "selectedFormat", "createExportRequest", "Lcom/android/tools/idea/sqlite/model/ExportRequest;", "showConfirmOverwriteDialog", "", "file", "doOKAction", "displayName", "Lcom/android/tools/idea/sqlite/model/Delimiter;", "getDisplayName", "(Lcom/android/tools/idea/sqlite/model/Delimiter;)Ljava/lang/String;", "delimiterFromDisplayName", "fileExtension", "getFileExtension", "(Lcom/android/tools/idea/sqlite/model/ExportFormat;)Ljava/lang/String;", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nExportToFileDialogViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportToFileDialogViewImpl.kt\ncom/android/tools/idea/sqlite/ui/exportToFile/ExportToFileDialogViewImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,466:1\n1869#2,2:467\n1869#2,2:482\n127#3,2:469\n183#3,2:480\n11228#4:471\n11563#4,3:472\n1137#4,2:484\n37#5:475\n36#5,3:476\n1#6:479\n*S KotlinDebug\n*F\n+ 1 ExportToFileDialogViewImpl.kt\ncom/android/tools/idea/sqlite/ui/exportToFile/ExportToFileDialogViewImpl\n*L\n125#1:467,2\n383#1:482,2\n132#1:469,2\n316#1:480,2\n135#1:471\n135#1:472,3\n401#1:484,2\n135#1:475\n135#1:476,3\n*E\n"})
public final class ExportToFileDialogViewImpl
extends DialogWrapper
implements ExportToFileDialogView {
    @NotNull
    private final Project project;
    @NotNull
    private final ExportDialogParams params;
    @NotNull
    private final List<ExportToFileDialogView.Listener> listeners;
    @NotNull
    private final DatabaseInspectorAnalyticsTracker analyticsTracker;
    private ButtonGroup formatButtonGroup;
    private JBLabel delimiterLabel;
    private ComboBox<String> delimiterComboBox;
    private TextFieldWithBrowseButton saveLocationTextField;

    public ExportToFileDialogViewImpl(@NotNull Project project, @NotNull ExportDialogParams params2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        super(project, true);
        this.project = project;
        this.params = params2;
        this.listeners = new ArrayList();
        this.analyticsTracker = DatabaseInspectorAnalyticsTracker.Companion.getInstance(this.project);
        ExportDialogParams exportDialogParams = this.params;
        if (exportDialogParams instanceof ExportDialogParams.ExportDatabaseDialogParams) {
            string = "Database";
        } else if (exportDialogParams instanceof ExportDialogParams.ExportTableDialogParams) {
            string = "Table";
        } else if (exportDialogParams instanceof ExportDialogParams.ExportQueryResultsDialogParams) {
            string = "Query Results";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String source2 = string;
        this.setTitle("Export " + source2);
        this.setOKButtonText("Export");
        this.setCancelButtonText("Cancel");
        super.init();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void show() {
        this.analyticsTracker.trackExportDialogOpened(this.params.getActionOrigin());
        super.show();
    }

    @NotNull
    protected String getHelpId() {
        return "org.jetbrains.android./r/studio-ui/db-inspector-help";
    }

    @Override
    public void addListener(@NotNull ExportToFileDialogView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull ExportToFileDialogView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        return DialogWrapper.DialogStyle.COMPACT;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        ComboBox<String> comboBox2;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Object e2;
        Delimiter[] $this$first$iv;
        JRadioButton formatCsvRadioButton;
        JRadioButton formatSqlRadioButton;
        JRadioButton formatDbRadioButton;
        JBLabel formatLabel;
        block15: {
            boolean bl;
            formatLabel = new JBLabel("File type:");
            this.formatButtonGroup = new ButtonGroup();
            formatDbRadioButton = this.createFormatButton(ExportFormat.DB.INSTANCE);
            formatSqlRadioButton = this.createFormatButton(ExportFormat.SQL.INSTANCE);
            formatCsvRadioButton = this.createFormatButton(new ExportFormat.CSV(Delimiter.SEMICOLON));
            Object[] objectArray = new JRadioButton[]{formatDbRadioButton, formatSqlRadioButton, formatCsvRadioButton};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                JRadioButton button = (JRadioButton)t;
                bl = false;
                ButtonGroup buttonGroup = this.formatButtonGroup;
                if (buttonGroup == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"formatButtonGroup");
                    buttonGroup = null;
                }
                buttonGroup.add(button);
                button.addActionListener(arg_0 -> ExportToFileDialogViewImpl.createCenterPanel$lambda$1$lambda$0(this, arg_0));
            }
            ButtonGroup buttonGroup = this.formatButtonGroup;
            if (buttonGroup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"formatButtonGroup");
                buttonGroup = null;
            }
            Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getElements(...)");
            $this$forEach$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
            boolean $i$f$first = false;
            for (Object e2 : $this$first$iv) {
                AbstractButton it = (AbstractButton)e2;
                bl = false;
                if (!it.isVisible()) continue;
                break block15;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        ((AbstractButton)e2).setSelected(true);
        $this$first$iv = Delimiter.values();
        ExportToFileDialogViewImpl exportToFileDialogViewImpl = this;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection collection2 = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var13_19 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection3 = collection2;
            boolean bl = false;
            collection3.add(this.getDisplayName((Delimiter)it));
        }
        $this$map$iv = (List)collection2;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        exportToFileDialogViewImpl.delimiterComboBox = new ComboBox(objectArray);
        this.delimiterLabel = new JBLabel(DatabaseInspectorBundle.INSTANCE.message("export.dialog.delimiter.label", new String[0]));
        JBLabel jBLabel = this.delimiterLabel;
        if (jBLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delimiterLabel");
            jBLabel = null;
        }
        if ((comboBox2 = this.delimiterComboBox) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delimiterComboBox");
            comboBox2 = null;
        }
        jBLabel.setLabelFor((Component)comboBox2);
        this.updateDelimiterEnabled();
        this.saveLocationTextField = new TextFieldWithBrowseButton();
        JBLabel saveLocationLabel = new JBLabel(DatabaseInspectorBundle.INSTANCE.message("export.dialog.output.location.label", new String[0]));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.saveLocationTextField;
        if (textFieldWithBrowseButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton2 = null;
        }
        saveLocationLabel.setLabelFor((Component)textFieldWithBrowseButton2);
        Path path = this.createSuggestedPath();
        if (path != null) {
            Path path2 = path;
            boolean bl = false;
            TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.saveLocationTextField;
            if (textFieldWithBrowseButton3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
                textFieldWithBrowseButton3 = null;
            }
            textFieldWithBrowseButton3.setText(((Object)path2).toString());
        }
        if ((textFieldWithBrowseButton = this.saveLocationTextField) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton = null;
        }
        textFieldWithBrowseButton.addActionListener(arg_0 -> ExportToFileDialogViewImpl.createCenterPanel$lambda$5(this, arg_0));
        TextFieldWithBrowseButton textFieldWithBrowseButton4 = this.saveLocationTextField;
        if (textFieldWithBrowseButton4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton4 = null;
        }
        JTextField jTextField = textFieldWithBrowseButton4.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextField(...)");
        this.setUpSaveLocationValidation(jTextField);
        JComponent jComponent = (JComponent)formatLabel;
        JComponent jComponent2 = formatDbRadioButton;
        JComponent jComponent3 = formatSqlRadioButton;
        JComponent jComponent4 = formatCsvRadioButton;
        JBLabel jBLabel2 = this.delimiterLabel;
        if (jBLabel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delimiterLabel");
            jBLabel2 = null;
        }
        JComponent jComponent5 = (JComponent)jBLabel2;
        ComboBox<String> comboBox3 = this.delimiterComboBox;
        if (comboBox3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delimiterComboBox");
            comboBox3 = null;
        }
        JComponent jComponent6 = (JComponent)comboBox3;
        JComponent jComponent7 = (JComponent)saveLocationLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton5 = this.saveLocationTextField;
        if (textFieldWithBrowseButton5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton5 = null;
        }
        return ExportToFileDialogLayout.INSTANCE.createLayout(jComponent, jComponent2, jComponent3, jComponent4, jComponent5, jComponent6, jComponent7, (JComponent)textFieldWithBrowseButton5);
    }

    private final void setUpSaveLocationValidation(JTextField locationTextField) {
        new ComponentValidator(this.getDisposable()).withValidator(() -> ExportToFileDialogViewImpl.setUpSaveLocationValidation$lambda$6(this, locationTextField)).installOn((JComponent)locationTextField);
        locationTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(locationTextField){
            final /* synthetic */ JTextField $locationTextField;
            {
                this.$locationTextField = $locationTextField;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ExportToFileDialogViewImpl.access$setUpSaveLocationValidation$runValidator(this.$locationTextField);
            }
        });
        ExportToFileDialogViewImpl.setUpSaveLocationValidation$runValidator(locationTextField);
    }

    /*
     * Unable to fully structure code
     */
    private final void showSaveFileDialog() {
        v0 = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save As...", "", this.selectedFormatExtension()), (Component)this.getContentPanel());
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"createSaveFileDialog(...)");
        dialog = v0;
        pathSuggestion = this.createSuggestedPath();
        if (pathSuggestion == null) {
            v1 = IOUtils.INSTANCE.getDefaultBaseDir();
        } else {
            v2 = new LinkOption[]{};
            v1 = Files.isDirectory(pathSuggestion, Arrays.copyOf(v2, v2.length)) != false ? pathSuggestion : (pathSuggestion.getParent() == null ? IOUtils.INSTANCE.getDefaultBaseDir() : pathSuggestion.getParent());
        }
        parent = v1;
        if (pathSuggestion == null) ** GOTO lbl-1000
        v3 = new LinkOption[]{};
        if (Files.isDirectory(pathSuggestion, Arrays.copyOf(v3, v3.length))) lbl-1000:
        // 2 sources

        {
            v4 = this.createFileName();
        } else {
            v4 = pathSuggestion.getFileName().toString();
        }
        fileName = v4;
        v5 = selectedFile = dialog.save(parent, fileName);
        if (v5 != null) {
            it = v5;
            $i$a$-let-ExportToFileDialogViewImpl$showSaveFileDialog$1 = false;
            v6 = this.saveLocationTextField;
            if (v6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
                v6 = null;
            }
            v6.setText(it.getFile().getAbsolutePath());
        }
        this.toFront();
    }

    private final JRadioButton createFormatButton(ExportFormat format) {
        JRadioButton jRadioButton;
        boolean isSupported = ModelKt.isInMemoryDatabase(this.params.getSrcDatabase()) ? format instanceof ExportFormat.CSV : (format instanceof ExportFormat.DB ? this.params instanceof ExportDialogParams.ExportDatabaseDialogParams : (format instanceof ExportFormat.SQL ? !(this.params instanceof ExportDialogParams.ExportQueryResultsDialogParams) : format instanceof ExportFormat.CSV));
        JRadioButton $this$createFormatButton_u24lambda_u2410 = jRadioButton = new JRadioButton(this.getDisplayName(format));
        boolean bl = false;
        $this$createFormatButton_u24lambda_u2410.setVisible(isSupported);
        $this$createFormatButton_u24lambda_u2410.setEnabled(isSupported);
        return jRadioButton;
    }

    private final void updateDelimiterEnabled() {
        boolean enabled = this.selectedFormat() instanceof ExportFormat.CSV;
        JBLabel jBLabel = this.delimiterLabel;
        if (jBLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delimiterLabel");
            jBLabel = null;
        }
        jBLabel.setEnabled(enabled);
        ComboBox<String> comboBox2 = this.delimiterComboBox;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delimiterComboBox");
            comboBox2 = null;
        }
        comboBox2.setEnabled(enabled);
    }

    private final Path parseSaveLocationTextFieldPath() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.saveLocationTextField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton = null;
        }
        String string = textFieldWithBrowseButton.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return IOUtils.INSTANCE.pathFromText(string);
    }

    private final Path createSuggestedPath() {
        Path path = this.parseSaveLocationTextFieldPath();
        if (path != null) {
            Path it = path;
            boolean bl = false;
            return it;
        }
        Path path2 = IOUtils.INSTANCE.getDefaultBaseDir();
        if (path2 == null) {
            return null;
        }
        Path baseDir2 = path2;
        String fileName = this.createFileName();
        return baseDir2.resolve(fileName);
    }

    private final String createFileName() {
        Object object;
        String databaseName = this.params.getSrcDatabase().getName();
        ExportDialogParams exportDialogParams = this.params;
        if (exportDialogParams instanceof ExportDialogParams.ExportDatabaseDialogParams) {
            object = databaseName;
        } else if (exportDialogParams instanceof ExportDialogParams.ExportTableDialogParams) {
            object = databaseName + "-" + ((ExportDialogParams.ExportTableDialogParams)this.params).getSrcTable();
        } else if (exportDialogParams instanceof ExportDialogParams.ExportQueryResultsDialogParams) {
            object = databaseName + "-query-results";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string = FileUtil.sanitizeFileName((String)object, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sanitizeFileName(...)");
        String baseFileName = string;
        String extension = this.selectedFormatExtension();
        Object extensionPart = StringsKt.isBlank((CharSequence)extension) ? "" : "." + extension;
        return baseFileName + (String)extensionPart;
    }

    private final void updateDestinationExtension() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.saveLocationTextField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton = null;
        }
        String string = textFieldWithBrowseButton.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            return;
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.saveLocationTextField;
        if (textFieldWithBrowseButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton2 = null;
        }
        File currentPath = new File(textFieldWithBrowseButton2.getText());
        String fileName = currentPath.getName();
        String fileNameNoExt = FilesKt.getNameWithoutExtension((File)currentPath);
        String newExtension = this.selectedFormatExtension();
        String newFileName2 = fileNameNoExt + "." + newExtension;
        String string2 = currentPath.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String currentPathStr = string2;
        CharSequence charSequence = currentPathStr;
        Intrinsics.checkNotNull((Object)fileName);
        int fileNameLocation = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)fileName, (int)0, (boolean)false, (int)6, null);
        String string3 = currentPathStr.substring(0, fileNameLocation);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String newPath = string3 + newFileName2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.saveLocationTextField;
        if (textFieldWithBrowseButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton3 = null;
        }
        textFieldWithBrowseButton3.setText(newPath);
    }

    private final String selectedFormatExtension() {
        ExportFormat selectedFormat = this.selectedFormat();
        if (this.params instanceof ExportDialogParams.ExportDatabaseDialogParams && selectedFormat instanceof ExportFormat.CSV) {
            return "zip";
        }
        return this.getFileExtension(selectedFormat);
    }

    private final ExportFormat selectedFormat() {
        ExportFormat exportFormat;
        String buttonText;
        Object v2;
        block9: {
            ButtonGroup buttonGroup = this.formatButtonGroup;
            if (buttonGroup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"formatButtonGroup");
                buttonGroup = null;
            }
            Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getElements(...)");
            Sequence $this$firstOrNull$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AbstractButton it = (AbstractButton)element$iv;
                boolean bl = false;
                if (!it.isSelected()) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        AbstractButton abstractButton = v2;
        String string = buttonText = abstractButton != null ? abstractButton.getText() : null;
        if (Intrinsics.areEqual((Object)string, (Object)this.getDisplayName(ExportFormat.DB.INSTANCE))) {
            exportFormat = ExportFormat.DB.INSTANCE;
        } else if (Intrinsics.areEqual((Object)string, (Object)this.getDisplayName(ExportFormat.SQL.INSTANCE))) {
            exportFormat = ExportFormat.SQL.INSTANCE;
        } else if (Intrinsics.areEqual((Object)string, (Object)this.getDisplayName(new ExportFormat.CSV(Delimiter.SEMICOLON)))) {
            ComboBox<String> comboBox2 = this.delimiterComboBox;
            if (comboBox2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delimiterComboBox");
                comboBox2 = null;
            }
            Object object = comboBox2.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
            exportFormat = new ExportFormat.CSV(this.delimiterFromDisplayName((String)object));
        } else {
            throw new IllegalStateException("Expected an export format to be selected.");
        }
        return exportFormat;
    }

    private final ExportRequest createExportRequest() {
        ExportRequest exportRequest;
        ExportDialogParams exportDialogParams;
        Path path;
        Path path2;
        ExportFormat format;
        Path dstPath;
        block12: {
            block11: {
                dstPath = this.parseSaveLocationTextFieldPath();
                format = this.selectedFormat();
                if (dstPath == null || !IOUtils.INSTANCE.isValidDestinationFilePath(dstPath)) break block11;
                TextFieldWithBrowseButton textFieldWithBrowseButton = this.saveLocationTextField;
                if (textFieldWithBrowseButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
                    textFieldWithBrowseButton = null;
                }
                String string = textFieldWithBrowseButton.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!IOUtils.INSTANCE.endsWithSeparatorChar(string) && this.showConfirmOverwriteDialog(this.project, dstPath)) break block12;
            }
            return null;
        }
        Path it = path2 = dstPath;
        boolean bl = false;
        Path path3 = ((CharSequence)PathsKt.getExtension((Path)it)).length() > 0 ? path2 : null;
        if (path3 == null) {
            path3 = path = Path.of(((Object)dstPath).toString() + "." + this.selectedFormatExtension(), new String[0]);
        }
        if ((exportDialogParams = this.params) instanceof ExportDialogParams.ExportDatabaseDialogParams) {
            SqliteDatabaseId sqliteDatabaseId = ((ExportDialogParams.ExportDatabaseDialogParams)this.params).getSrcDatabase();
            Intrinsics.checkNotNull((Object)path);
            exportRequest = new ExportRequest.ExportDatabaseRequest(sqliteDatabaseId, format, path);
        } else if (exportDialogParams instanceof ExportDialogParams.ExportTableDialogParams) {
            SqliteDatabaseId sqliteDatabaseId = ((ExportDialogParams.ExportTableDialogParams)this.params).getSrcDatabase();
            String string = ((ExportDialogParams.ExportTableDialogParams)this.params).getSrcTable();
            Intrinsics.checkNotNull((Object)path);
            exportRequest = new ExportRequest.ExportTableRequest(sqliteDatabaseId, string, format, path);
        } else if (exportDialogParams instanceof ExportDialogParams.ExportQueryResultsDialogParams) {
            SqliteDatabaseId sqliteDatabaseId = ((ExportDialogParams.ExportQueryResultsDialogParams)this.params).getSrcDatabase();
            SqliteStatement sqliteStatement = ((ExportDialogParams.ExportQueryResultsDialogParams)this.params).getQuery();
            Intrinsics.checkNotNull((Object)path);
            exportRequest = new ExportRequest.ExportQueryResultsRequest(sqliteDatabaseId, sqliteStatement, format, path);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return exportRequest;
    }

    private final boolean showConfirmOverwriteDialog(Project project, Path file) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return true;
        }
        String[] stringArray = new String[]{((Object)file.getFileName()).toString(), ((Object)file.getParent()).toString()};
        int result2 = Messages.showYesNoDialog((Project)project, (String)DatabaseInspectorBundle.INSTANCE.message("export.dialog.file.already.exists.overwrite.prompt", stringArray), (String)DatabaseInspectorBundle.INSTANCE.message("export.dialog.file.already.exists.overwrite.title", new String[0]), (String)CommonBundle.message((String)"button.overwrite", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
        return result2 == 0;
    }

    protected void doOKAction() {
        block1: {
            ExportRequest exportRequest = this.createExportRequest();
            if (exportRequest == null) break block1;
            ExportRequest params2 = exportRequest;
            boolean bl = false;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ExportToFileDialogView.Listener it = (ExportToFileDialogView.Listener)element$iv;
                boolean bl2 = false;
                it.exportRequestSubmitted(params2);
            }
            super.doOKAction();
        }
    }

    private final String getDisplayName(Delimiter $this$displayName) {
        return DatabaseInspectorBundle.INSTANCE.message(switch (WhenMappings.$EnumSwitchMapping$0[$this$displayName.ordinal()]) {
            case 1 -> "export.dialog.delimiter.semicolon.label";
            case 2 -> "export.dialog.delimiter.tab.label";
            case 3 -> "export.dialog.delimiter.comma.label";
            case 4 -> "export.dialog.delimiter.vertical_bar.label";
            case 5 -> "export.dialog.delimiter.space.label";
            default -> throw new NoWhenBranchMatchedException();
        }, new String[0]);
    }

    private final Delimiter delimiterFromDisplayName(String displayName) {
        Delimiter element$iv;
        block2: {
            Delimiter[] $this$first$iv = Delimiter.values();
            boolean $i$f$first = false;
            int n = $this$first$iv.length;
            for (int i = 0; i < n; ++i) {
                Delimiter it = element$iv = $this$first$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)this.getDisplayName(it), (Object)displayName)) {
                    continue;
                }
                break block2;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        return element$iv;
    }

    private final String getFileExtension(ExportFormat $this$fileExtension) {
        String string;
        ExportFormat exportFormat = $this$fileExtension;
        if (Intrinsics.areEqual((Object)exportFormat, (Object)ExportFormat.DB.INSTANCE)) {
            string = "db";
        } else if (Intrinsics.areEqual((Object)exportFormat, (Object)ExportFormat.SQL.INSTANCE)) {
            string = "sql";
        } else if (exportFormat instanceof ExportFormat.CSV) {
            string = "csv";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String getDisplayName(ExportFormat $this$displayName) {
        String string;
        ExportFormat exportFormat = $this$displayName;
        if (Intrinsics.areEqual((Object)exportFormat, (Object)ExportFormat.DB.INSTANCE)) {
            string = "DB";
        } else if (Intrinsics.areEqual((Object)exportFormat, (Object)ExportFormat.SQL.INSTANCE)) {
            string = "SQL";
        } else if (exportFormat instanceof ExportFormat.CSV) {
            string = "CSV";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final void createCenterPanel$lambda$1$lambda$0(ExportToFileDialogViewImpl this$0, ActionEvent it) {
        this$0.updateDelimiterEnabled();
        this$0.updateDestinationExtension();
    }

    private static final void createCenterPanel$lambda$5(ExportToFileDialogViewImpl this$0, ActionEvent it) {
        this$0.showSaveFileDialog();
    }

    private static final ValidationInfo setUpSaveLocationValidation$getValidationError(ExportToFileDialogViewImpl this$0, JTextField $locationTextField) {
        String string;
        Path path = this$0.parseSaveLocationTextFieldPath();
        String pathString = $locationTextField.getText();
        if (IOUtils.INSTANCE.isValidDestinationFilePath(path)) {
            Intrinsics.checkNotNull((Object)pathString);
            if (!IOUtils.INSTANCE.endsWithSeparatorChar(pathString)) {
                return null;
            }
        }
        if (Strings.isBlank((String)pathString)) {
            string = "Path not defined";
        } else {
            Intrinsics.checkNotNull((Object)pathString);
            if (IOUtils.INSTANCE.endsWithSeparatorChar(pathString)) {
                string = "File name not specified";
            } else if (path == null) {
                string = "Path is invalid";
            } else {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    string = "Path is an existing directory";
                } else if (path.getParent() == null) {
                    string = "Parent directory not defined";
                } else {
                    Path path2 = path.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
                    Path path3 = path2;
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    string = !Files.exists(path3, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) ? "Parent directory does not exist" : "Path is invalid";
                }
            }
        }
        String errorMessage = string;
        return new ValidationInfo(errorMessage, (JComponent)$locationTextField);
    }

    private static final ValidationInfo setUpSaveLocationValidation$lambda$6(ExportToFileDialogViewImpl this$0, JTextField $locationTextField) {
        ValidationInfo validationError = ExportToFileDialogViewImpl.setUpSaveLocationValidation$getValidationError(this$0, $locationTextField);
        this$0.setOKActionEnabled(validationError == null);
        return validationError;
    }

    private static final Unit setUpSaveLocationValidation$runValidator$lambda$7(ComponentValidator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.revalidate();
        return Unit.INSTANCE;
    }

    private static final void setUpSaveLocationValidation$runValidator$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void setUpSaveLocationValidation$runValidator(JTextField $locationTextField) {
        ComponentValidator.getInstance((JComponent)$locationTextField).ifPresent(arg_0 -> ExportToFileDialogViewImpl.setUpSaveLocationValidation$runValidator$lambda$8(ExportToFileDialogViewImpl::setUpSaveLocationValidation$runValidator$lambda$7, arg_0));
    }

    public static final /* synthetic */ void access$setUpSaveLocationValidation$runValidator(JTextField $locationTextField) {
        ExportToFileDialogViewImpl.setUpSaveLocationValidation$runValidator($locationTextField);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Delimiter.values().length];
            try {
                nArray[Delimiter.SEMICOLON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Delimiter.TAB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Delimiter.COMMA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Delimiter.VERTICAL_BAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Delimiter.SPACE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

