/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.sdklib.deviceprovisioner.DeviceType;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.ui.NotificationHolderPanel;
import com.android.tools.adtui.util.AwtUtilsKt;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.streaming.actions.HardwareInputStateStorage;
import com.android.tools.idea.streaming.core.ContextMenuHandler;
import com.android.tools.idea.streaming.core.DeviceId;
import com.android.tools.idea.streaming.core.DeviceInputListenerManager;
import com.android.tools.idea.streaming.core.MouseWheelUtilsKt;
import com.android.tools.idea.streaming.core.StreamingContextMenuAdvertisementCloser;
import com.android.tools.idea.streaming.core.StreamingLoadingPanel;
import com.android.tools.idea.streaming.core.StreamingUtilsKt;
import com.android.tools.idea.streaming.core.ZoomablePanel;
import com.android.tools.idea.streaming.xr.AbstractXrInputController;
import com.intellij.ide.DataManager;
import com.intellij.ide.KeyboardAwareFocusOwner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\b\u009b\u0001\u009c\u0001\u009d\u0001\u009e\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010S\u001a\u00020TH\u0002J \u0010U\u001a\u00020T2\u0006\u0010V\u001a\u00020W2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010X\u001a\u00020DH\u0004J0\u0010Y\u001a\u00020T2\u0006\u0010Z\u001a\u00020W2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\u00072\u0006\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020aH\u0002J\u0018\u0010b\u001a\u00020c2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\u0007H\u0002J\u001c\u0010d\u001a\u00020T*\u00020e2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\u0007H\u0002J\u001c\u0010f\u001a\u00020T*\u00020e2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\u0007H\u0002J\u000e\u0010g\u001a\u00020T2\u0006\u0010h\u001a\u00020\tJ\u0006\u0010i\u001a\u00020TJ\r\u0010j\u001a\u00020TH\u0000\u00a2\u0006\u0002\bkJ,\u0010l\u001a\u00020T2\u0006\u0010m\u001a\u00020\t2\n\b\u0002\u0010n\u001a\u0004\u0018\u00010o2\u000e\b\u0002\u0010p\u001a\b\u0018\u00010qR\u00020\u0000H\u0004J\b\u0010r\u001a\u00020TH\u0004J\n\u0010s\u001a\u0004\u0018\u00010tH\u0002J\u000f\u0010u\u001a\u0004\u0018\u00010vH\u0000\u00a2\u0006\u0002\bwJ\u0010\u0010x\u001a\u00020a2\u0006\u0010\u001b\u001a\u00020aH\u0004J\u0018\u0010y\u001a\u00020T2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010z\u001a\u00020{H\u0004J\u0015\u0010|\u001a\u00020T2\u0006\u0010}\u001a\u000205H\u0000\u00a2\u0006\u0002\b~J\u0016\u0010\u007f\u001a\u00020T2\u0006\u0010}\u001a\u000205H\u0000\u00a2\u0006\u0003\b\u0080\u0001J\u001a\u0010\u0081\u0001\u001a\u0004\u0018\u00010\\2\u0007\u0010\u0082\u0001\u001a\u00020\\H\u0000\u00a2\u0006\u0003\b\u0083\u0001J\t\u0010\u0084\u0001\u001a\u00020DH\u0004J\u0007\u0010\u0085\u0001\u001a\u00020DJ\u0011\u0010\u0086\u0001\u001a\u00020D2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001J\"\u0010\u0089\u0001\u001a\u00020T2\b\u0010\u0087\u0001\u001a\u00030\u008a\u00012\u0007\u0010\u008b\u0001\u001a\u00020DH\u0010\u00a2\u0006\u0003\b\u008c\u0001J\u001c\u0010\u008d\u0001\u001a\u00020D2\b\u0010\u0087\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020DH\u0004J\u0011\u0010\u0090\u0001\u001a\u00020W2\u0006\u0010V\u001a\u00020eH\u0004J\u000e\u0010\u0091\u0001\u001a\u00020a*\u00030\u0092\u0001H\u0004J\u0013\u0010\u0093\u0001\u001a\u0004\u0018\u00010J2\u0006\u0010\b\u001a\u00020\tH\u0002J\t\u0010\u0094\u0001\u001a\u00020DH\u0016J\t\u0010\u0095\u0001\u001a\u00020DH\u0016J\t\u0010\u0096\u0001\u001a\u00020DH\u0016J\t\u0010\u0097\u0001\u001a\u00020DH\u0016J\u0013\u0010\u0098\u0001\u001a\u00020D2\b\u0010\u0099\u0001\u001a\u00030\u009a\u0001H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR(\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0012\u0010\"\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\rR$\u0010$\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\r\"\u0004\b&\u0010'R\u0012\u0010(\u001a\u00020)X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R&\u0010-\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020,@DX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00100\u001a\u0004\b.\u0010\r\"\u0004\b/\u0010'R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u00103\u001a.\u0012\f\u0012\n 6*\u0004\u0018\u00010505 6*\u0015\u0012\f\u0012\n 6*\u0004\u0018\u0001050508\u00a2\u0006\u0002\b704\u00a2\u0006\u0002\b7X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00109\u001a\u00020:X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010?\u001a\u0004\u0018\u00010@X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u0016\u0010I\u001a\u0004\u0018\u00010JX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u0014\u0010M\u001a\u00020NX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010R\u00a8\u0006\u009f\u0001"}, d2={"Lcom/android/tools/idea/streaming/core/AbstractDisplayView;", "Lcom/android/tools/idea/streaming/core/ZoomablePanel;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/ide/KeyboardAwareFocusOwner;", "project", "Lcom/intellij/openapi/project/Project;", "displayId", "", "contextMenuActionGroupId", "", "<init>", "(Lcom/intellij/openapi/project/Project;ILjava/lang/String;)V", "getDisplayId", "()I", "deviceSerialNumber", "getDeviceSerialNumber", "()Ljava/lang/String;", "deviceId", "Lcom/android/tools/idea/streaming/core/DeviceId;", "getDeviceId", "()Lcom/android/tools/idea/streaming/core/DeviceId;", "deviceType", "Lcom/android/sdklib/deviceprovisioner/DeviceType;", "getDeviceType", "()Lcom/android/sdklib/deviceprovisioner/DeviceType;", "apiLevel", "getApiLevel", "value", "Ljava/awt/Rectangle;", "displayRectangle", "getDisplayRectangle", "()Ljava/awt/Rectangle;", "setDisplayRectangle", "(Ljava/awt/Rectangle;)V", "displayOrientationQuadrants", "getDisplayOrientationQuadrants", "displayOrientationCorrectionQuadrants", "getDisplayOrientationCorrectionQuadrants", "setDisplayOrientationCorrectionQuadrants", "(I)V", "deviceDisplaySize", "Ljava/awt/Dimension;", "getDeviceDisplaySize$intellij_android_streaming", "()Ljava/awt/Dimension;", "Lkotlin/UInt;", "frameNumber", "getFrameNumber-pVg5ArA", "setFrameNumber-WZ4Q5Ns", "I", "disconnectedStatePanel", "Lcom/android/tools/idea/streaming/core/AbstractDisplayView$DisconnectedStatePanel;", "frameListeners", "", "Lcom/android/tools/idea/streaming/core/AbstractDisplayView$FrameListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "hardwareInput", "Lcom/android/tools/idea/streaming/core/AbstractDisplayView$HardwareInput;", "getHardwareInput", "()Lcom/android/tools/idea/streaming/core/AbstractDisplayView$HardwareInput;", "hardwareInputStateStorage", "Lcom/android/tools/idea/streaming/actions/HardwareInputStateStorage;", "xrInputController", "Lcom/android/tools/idea/streaming/xr/AbstractXrInputController;", "getXrInputController$intellij_android_streaming", "()Lcom/android/tools/idea/streaming/xr/AbstractXrInputController;", "rightClicksAreSentToDevice", "", "getRightClicksAreSentToDevice", "()Z", "setRightClicksAreSentToDevice", "(Z)V", "contextMenuHandler", "Lcom/intellij/ui/PopupHandler;", "getContextMenuHandler", "()Lcom/intellij/ui/PopupHandler;", "deviceInputListenerManager", "Lcom/android/tools/idea/streaming/core/DeviceInputListenerManager;", "getDeviceInputListenerManager", "()Lcom/android/tools/idea/streaming/core/DeviceInputListenerManager;", "getProject", "()Lcom/intellij/openapi/project/Project;", "initializeFocusHandling", "", "drawMultiTouchFeedback", "graphics", "Ljava/awt/Graphics2D;", "dragging", "paintTouchBackground", "g", "center", "Ljava/awt/Point;", "radius", "color", "Ljava/awt/Color;", "intensity", "", "createCircle", "Ljava/awt/geom/Ellipse2D;", "drawCircle", "Ljava/awt/Graphics;", "fillCircle", "showLongRunningOperationIndicator", "text", "hideLongRunningOperationIndicator", "hideLongRunningOperationIndicatorInstantly", "hideLongRunningOperationIndicatorInstantly$intellij_android_streaming", "showDisconnectedStateMessage", "message", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "reconnector", "Lcom/android/tools/idea/streaming/core/AbstractDisplayView$Reconnector;", "hideDisconnectedStateMessage", "findLoadingPanel", "Lcom/android/tools/idea/streaming/core/StreamingLoadingPanel;", "findNotificationHolderPanel", "Lcom/android/tools/adtui/ui/NotificationHolderPanel;", "findNotificationHolderPanel$intellij_android_streaming", "roundScale", "notifyFrameListeners", "frame", "Ljava/awt/image/BufferedImage;", "addFrameListener", "listener", "addFrameListener$intellij_android_streaming", "removeFrameListener", "removeFrameListener$intellij_android_streaming", "toDeviceDisplayCoordinates", "p", "toDeviceDisplayCoordinates$intellij_android_streaming", "isHardwareInputEnabled", "getFocusTraversalKeysEnabled", "skipKeyEventDispatcher", "event", "Ljava/awt/event/KeyEvent;", "hardwareInputStateChanged", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "enabled", "hardwareInputStateChanged$intellij_android_streaming", "handlePopup", "Ljava/awt/event/MouseEvent;", "insideDisplay", "createAdjustedGraphicsContext", "getNormalizedScrollAmount", "Ljava/awt/event/MouseWheelEvent;", "createContextMenuHandler", "canZoomIn", "canZoomOut", "canZoomToActual", "canZoomToFit", "zoom", "type", "Lcom/android/tools/adtui/actions/ZoomType;", "FrameListener", "HardwareInput", "Reconnector", "DisconnectedStatePanel", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nAbstractDisplayView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDisplayView.kt\ncom/android/tools/idea/streaming/core/AbstractDisplayView\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 UiUtils.kt\ncom/intellij/openapi/ui/UiUtils\n*L\n1#1,568:1\n30#2,2:569\n30#2,2:571\n64#3:573\n64#3:574\n*S KotlinDebug\n*F\n+ 1 AbstractDisplayView.kt\ncom/android/tools/idea/streaming/core/AbstractDisplayView\n*L\n134#1:569,2\n143#1:571,2\n254#1:573\n256#1:574\n*E\n"})
public abstract class AbstractDisplayView
extends ZoomablePanel
implements Disposable,
KeyboardAwareFocusOwner {
    private final int displayId;
    @Nullable
    private Rectangle displayRectangle;
    private int displayOrientationCorrectionQuadrants;
    private int frameNumber;
    @NotNull
    private final DisconnectedStatePanel disconnectedStatePanel;
    @NotNull
    private final List<FrameListener> frameListeners;
    @NotNull
    private final HardwareInputStateStorage hardwareInputStateStorage;
    private boolean rightClicksAreSentToDevice;
    @Nullable
    private final PopupHandler contextMenuHandler;
    @NotNull
    private final DeviceInputListenerManager deviceInputListenerManager;

    public AbstractDisplayView(@NotNull Project project, int displayId, @NotNull String contextMenuActionGroupId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)contextMenuActionGroupId, (String)"contextMenuActionGroupId");
        this.displayId = displayId;
        this.disconnectedStatePanel = new DisconnectedStatePanel();
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.frameListeners = list;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class serviceClass$iv = HardwareInputStateStorage.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.hardwareInputStateStorage = (HardwareInputStateStorage)object;
        this.contextMenuHandler = this.createContextMenuHandler(contextMenuActionGroupId);
        $this$service$iv = (ComponentManager)project;
        $i$f$service = false;
        serviceClass$iv = DeviceInputListenerManager.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.deviceInputListenerManager = (DeviceInputListenerManager)object2;
        this.setBackground((Color)StudioColorsKt.getPrimaryPanelBackground());
        this.addToCenter((Component)((Object)this.disconnectedStatePanel));
        this.initializeFocusHandling();
    }

    public final int getDisplayId() {
        return this.displayId;
    }

    @NotNull
    public final String getDeviceSerialNumber() {
        return this.getDeviceId().getSerialNumber();
    }

    @NotNull
    public abstract DeviceId getDeviceId();

    @NotNull
    public abstract DeviceType getDeviceType();

    public abstract int getApiLevel();

    @Nullable
    public final Rectangle getDisplayRectangle() {
        return this.displayRectangle;
    }

    protected final void setDisplayRectangle(@Nullable Rectangle rectangle) {
        this.displayRectangle = rectangle;
    }

    public abstract int getDisplayOrientationQuadrants();

    public final int getDisplayOrientationCorrectionQuadrants() {
        return this.displayOrientationCorrectionQuadrants;
    }

    protected final void setDisplayOrientationCorrectionQuadrants(int n) {
        this.displayOrientationCorrectionQuadrants = n;
    }

    @NotNull
    public abstract Dimension getDeviceDisplaySize$intellij_android_streaming();

    public final int getFrameNumber-pVg5ArA() {
        return this.frameNumber;
    }

    protected final void setFrameNumber-WZ4Q5Ns(int n) {
        this.frameNumber = n;
    }

    @NotNull
    protected abstract HardwareInput getHardwareInput();

    @Nullable
    public abstract AbstractXrInputController getXrInputController$intellij_android_streaming();

    public final boolean getRightClicksAreSentToDevice() {
        return this.rightClicksAreSentToDevice;
    }

    public final void setRightClicksAreSentToDevice(boolean bl) {
        this.rightClicksAreSentToDevice = bl;
    }

    @Nullable
    protected final PopupHandler getContextMenuHandler() {
        return this.contextMenuHandler;
    }

    @NotNull
    protected final DeviceInputListenerManager getDeviceInputListenerManager() {
        return this.deviceInputListenerManager;
    }

    @Nullable
    protected Project getProject() {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return (Project)CommonDataKeys.PROJECT.getData(dataContext);
    }

    private final void initializeFocusHandling() {
        this.setFocusable(true);
        this.setFocusTraversalKeys(1, SetsKt.emptySet());
        this.setFocusTraversalKeys(0, SetsKt.setOf((Object)KeyStroke.getKeyStroke(9, 64)));
        this.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ AbstractDisplayView this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusLost(FocusEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.getHardwareInput().resetMetaKeys();
            }
        });
    }

    protected final void drawMultiTouchFeedback(@NotNull Graphics2D graphics, @NotNull Rectangle displayRectangle, boolean dragging) {
        Area area;
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)displayRectangle, (String)"displayRectangle");
        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(mouseLocation, (Component)((Object)this));
        Intrinsics.checkNotNull((Object)mouseLocation);
        Point touchPoint = AwtUtilsKt.scaled((Point)mouseLocation, (double)this.getScreenScale());
        if (!displayRectangle.contains(touchPoint)) {
            return;
        }
        Graphics graphics2 = graphics.create();
        Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g = (Graphics2D)graphics2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON), TuplesKt.to((Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_QUALITY)};
        g.setRenderingHints(new RenderingHints(MapsKt.mapOf((Pair[])pairArray)));
        g.setClip(displayRectangle);
        Point centerPoint = new Point(displayRectangle.x + displayRectangle.width / 2, displayRectangle.y + displayRectangle.height / 2);
        Point mirrorPoint = new Point(centerPoint.x * 2 - touchPoint.x, centerPoint.y * 2 - touchPoint.y);
        int r1 = MathKt.roundToInt((double)((double)Math.max(displayRectangle.width, displayRectangle.height) * 0.015));
        int r2 = r1 / 4;
        Ellipse2D touchCircle = this.createCircle(touchPoint, r1);
        Ellipse2D mirrorCircle = this.createCircle(mirrorPoint, r1);
        Ellipse2D centerCircle = this.createCircle(centerPoint, r2);
        Area $this$drawMultiTouchFeedback_u24lambda_u240 = area = new Area(displayRectangle);
        boolean bl = false;
        $this$drawMultiTouchFeedback_u24lambda_u240.subtract(new Area(touchCircle));
        $this$drawMultiTouchFeedback_u24lambda_u240.subtract(new Area(mirrorCircle));
        $this$drawMultiTouchFeedback_u24lambda_u240.subtract(new Area(centerCircle));
        Area clip = area;
        g.setClip(clip);
        Color darkColor = new Color(0, 154, 133, 157);
        Color lightColor = new Color(255, 255, 255, 157);
        g.setColor(darkColor);
        g.drawLine(touchPoint.x, touchPoint.y, mirrorPoint.x, mirrorPoint.y);
        g.setClip(displayRectangle);
        this.fillCircle(g, centerPoint, r2 * 3 / 4);
        double backgroundIntensity = dragging ? 0.8 : 0.3;
        this.paintTouchBackground(g, touchPoint, r1, darkColor, backgroundIntensity);
        this.paintTouchBackground(g, mirrorPoint, r1, darkColor, backgroundIntensity);
        g.setColor(lightColor);
        this.drawCircle(g, touchPoint, r1);
        this.drawCircle(g, mirrorPoint, r1);
        this.drawCircle(g, centerPoint, r2);
    }

    private final void paintTouchBackground(Graphics2D g, Point center, int radius, Color color, double intensity) {
        if (!(0.0 < intensity && intensity <= 1.0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int r = radius * 5 / 4;
        Color intenseColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), MathKt.roundToInt((double)((double)color.getAlpha() * intensity)));
        Color subtleColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), MathKt.roundToInt((double)((double)color.getAlpha() * intensity * 0.15)));
        Object[] objectArray = new float[]{0.0f, 0.8f, 1.0f};
        float[] fArray = objectArray;
        objectArray = new Color[3];
        objectArray[0] = (float)subtleColor;
        objectArray[1] = (float)intenseColor;
        objectArray[2] = (float)subtleColor;
        g.setPaint(new RadialGradientPaint(center, r, fArray, (Color[])objectArray));
        this.fillCircle(g, center, r);
    }

    private final Ellipse2D createCircle(Point center, int radius) {
        double diameter = (double)radius * 2.0;
        return new Ellipse2D.Double(center.x - radius, center.y - radius, diameter, diameter);
    }

    private final void drawCircle(Graphics $this$drawCircle, Point center, int radius) {
        $this$drawCircle.drawOval(center.x - radius, center.y - radius, radius * 2, radius * 2);
    }

    private final void fillCircle(Graphics $this$fillCircle, Point center, int radius) {
        $this$fillCircle.fillOval(center.x - radius, center.y - radius, radius * 2, radius * 2);
    }

    public final void showLongRunningOperationIndicator(@NotNull String text2) {
        block0: {
            StreamingLoadingPanel streamingLoadingPanel;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            StreamingLoadingPanel streamingLoadingPanel2 = this.findLoadingPanel();
            if (streamingLoadingPanel2 == null) break block0;
            StreamingLoadingPanel $this$showLongRunningOperationIndicator_u24lambda_u241 = streamingLoadingPanel = streamingLoadingPanel2;
            boolean bl = false;
            $this$showLongRunningOperationIndicator_u24lambda_u241.setLoadingText(text2);
            $this$showLongRunningOperationIndicator_u24lambda_u241.startLoading();
        }
    }

    public final void hideLongRunningOperationIndicator() {
        block0: {
            StreamingLoadingPanel streamingLoadingPanel = this.findLoadingPanel();
            if (streamingLoadingPanel == null) break block0;
            streamingLoadingPanel.stopLoading();
        }
    }

    public final void hideLongRunningOperationIndicatorInstantly$intellij_android_streaming() {
        block0: {
            StreamingLoadingPanel streamingLoadingPanel = this.findLoadingPanel();
            if (streamingLoadingPanel == null) break block0;
            streamingLoadingPanel.stopLoadingInstantly();
        }
    }

    protected final void showDisconnectedStateMessage(@NotNull String message, @Nullable HyperlinkListener hyperlinkListener, @Nullable Reconnector reconnector) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.hideLongRunningOperationIndicatorInstantly$intellij_android_streaming();
        this.zoom(ZoomType.FIT);
        this.disconnectedStatePanel.showPanel(message, hyperlinkListener, reconnector);
    }

    public static /* synthetic */ void showDisconnectedStateMessage$default(AbstractDisplayView abstractDisplayView, String string, HyperlinkListener hyperlinkListener, Reconnector reconnector, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showDisconnectedStateMessage");
        }
        if ((n & 2) != 0) {
            hyperlinkListener = null;
        }
        if ((n & 4) != 0) {
            reconnector = null;
        }
        abstractDisplayView.showDisconnectedStateMessage(string, hyperlinkListener, reconnector);
    }

    protected final void hideDisconnectedStateMessage() {
        this.disconnectedStatePanel.hidePanel();
    }

    private final StreamingLoadingPanel findLoadingPanel() {
        Component $this$getParentOfType$iv = (Component)((Object)this);
        boolean $i$f$getParentOfType = false;
        return (StreamingLoadingPanel)((Object)ComponentUtil.getParentOfType(StreamingLoadingPanel.class, (Component)$this$getParentOfType$iv));
    }

    @Nullable
    public final NotificationHolderPanel findNotificationHolderPanel$intellij_android_streaming() {
        Component $this$getParentOfType$iv = (Component)((Object)this);
        boolean $i$f$getParentOfType = false;
        return (NotificationHolderPanel)ComponentUtil.getParentOfType(NotificationHolderPanel.class, (Component)$this$getParentOfType$iv);
    }

    protected final double roundScale(double value2) {
        if (value2 >= 1.0) {
            return this.roundDownIfNecessary(value2);
        }
        int logScale = -MathKt.roundToInt((double)MathKt.log2((double)value2)) + 7;
        int multiplier = 2 << logScale + 7;
        return Math.rint(value2 * (double)multiplier) / (double)multiplier;
    }

    protected final void notifyFrameListeners(@NotNull Rectangle displayRectangle, @NotNull BufferedImage frame) {
        Intrinsics.checkNotNullParameter((Object)displayRectangle, (String)"displayRectangle");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        for (FrameListener listener2 : this.frameListeners) {
            listener2.frameRendered-SGjrQA4(this.frameNumber, displayRectangle, this.getDisplayOrientationQuadrants(), frame);
        }
    }

    public final void addFrameListener$intellij_android_streaming(@NotNull FrameListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.frameListeners.add(listener2);
    }

    public final void removeFrameListener$intellij_android_streaming(@NotNull FrameListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.frameListeners.remove(listener2);
    }

    @Nullable
    public final Point toDeviceDisplayCoordinates$intellij_android_streaming(@NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Rectangle rectangle = this.displayRectangle;
        if (rectangle == null) {
            return null;
        }
        Rectangle displayRectangle = rectangle;
        Dimension dimension2 = displayRectangle.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getSize(...)");
        Dimension imageSize = AwtUtilsKt.rotatedByQuadrants((Dimension)dimension2, (int)this.getDisplayOrientationQuadrants());
        Point normalized = new Point();
        int rotation = this.displayOrientationCorrectionQuadrants % 2 == 0 ? this.getDisplayOrientationQuadrants() + this.displayOrientationCorrectionQuadrants % 4 : this.getDisplayOrientationQuadrants();
        switch (rotation) {
            case 0: {
                normalized.x = AwtUtilsKt.scaled((int)p.x, (double)this.getScreenScale()) - displayRectangle.x;
                normalized.y = AwtUtilsKt.scaled((int)p.y, (double)this.getScreenScale()) - displayRectangle.y;
                break;
            }
            case 1: {
                normalized.x = StreamingUtilsKt.getBottom(displayRectangle) - AwtUtilsKt.scaled((int)p.y, (double)this.getScreenScale());
                normalized.y = AwtUtilsKt.scaled((int)p.x, (double)this.getScreenScale()) - displayRectangle.x;
                break;
            }
            case 2: {
                normalized.x = StreamingUtilsKt.getRight(displayRectangle) - AwtUtilsKt.scaled((int)p.x, (double)this.getScreenScale());
                normalized.y = StreamingUtilsKt.getBottom(displayRectangle) - AwtUtilsKt.scaled((int)p.y, (double)this.getScreenScale());
                break;
            }
            default: {
                normalized.x = AwtUtilsKt.scaled((int)p.y, (double)this.getScreenScale()) - displayRectangle.y;
                normalized.y = StreamingUtilsKt.getRight(displayRectangle) - AwtUtilsKt.scaled((int)p.x, (double)this.getScreenScale());
            }
        }
        return StreamingUtilsKt.scaledUnbiased(normalized, imageSize, this.getDeviceDisplaySize$intellij_android_streaming());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isHardwareInputEnabled() {
        if (!this.hardwareInputStateStorage.isHardwareInputEnabled(this.getDeviceId())) return false;
        AbstractXrInputController abstractXrInputController = this.getXrInputController$intellij_android_streaming();
        if (abstractXrInputController == null) return true;
        if (!abstractXrInputController.isMouseUsedForNavigation()) return true;
        return false;
    }

    public final boolean getFocusTraversalKeysEnabled() {
        return !this.isHardwareInputEnabled() && super.getFocusTraversalKeysEnabled();
    }

    public final boolean skipKeyEventDispatcher(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isHardwareInputEnabled()) {
            return false;
        }
        KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(event);
        for (KeyStroke keyStroke : KeymapUtil.getKeyStrokes((ShortcutSet)KeymapUtil.getActiveKeymapShortcuts((String)"android.streaming.hardware.input"))) {
            if (!Intrinsics.areEqual((Object)stroke, (Object)keyStroke)) continue;
            return false;
        }
        return true;
    }

    public void hardwareInputStateChanged$intellij_android_streaming(@NotNull AnActionEvent event, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!enabled) {
            this.getHardwareInput().resetMetaKeys();
        }
    }

    protected final boolean handlePopup(@NotNull MouseEvent event, boolean insideDisplay) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.isPopupTrigger() || insideDisplay && (this.isHardwareInputEnabled() || this.rightClicksAreSentToDevice)) {
            return false;
        }
        PopupHandler popupHandler2 = this.contextMenuHandler;
        if (popupHandler2 == null) {
            return false;
        }
        PopupHandler handler2 = popupHandler2;
        handler2.invokePopup(event.getComponent(), event.getX(), event.getY());
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        MessageBus messageBus2 = messageBus;
        Topic<StreamingContextMenuAdvertisementCloser> topic = StreamingContextMenuAdvertisementCloser.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((StreamingContextMenuAdvertisementCloser)messageBus2.syncPublisher(topic)).closeContextMenuAdvertisement();
        return true;
    }

    @NotNull
    protected final Graphics2D createAdjustedGraphicsContext(@NotNull Graphics graphics) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Graphics graphics2 = graphics.create();
        Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g = (Graphics2D)graphics2;
        double physicalToVirtualScale = 1.0 / this.getScreenScale();
        g.scale(physicalToVirtualScale, physicalToVirtualScale);
        if (SystemInfo.isMac) {
            g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        }
        return g;
    }

    protected final double getNormalizedScrollAmount(@NotNull MouseWheelEvent $this$getNormalizedScrollAmount) {
        Intrinsics.checkNotNullParameter((Object)$this$getNormalizedScrollAmount, (String)"<this>");
        return MouseWheelUtilsKt.getNormalizedScrollAmount($this$getNormalizedScrollAmount, this.getScale());
    }

    private final PopupHandler createContextMenuHandler(String contextMenuActionGroupId) {
        PopupHandler popupHandler2;
        if (((Boolean)StudioFlags.RUNNING_DEVICES_CONTEXT_MENU.get()).booleanValue()) {
            JComponent jComponent = (JComponent)((Object)this);
            String string = this.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            popupHandler2 = new ContextMenuHandler(jComponent, contextMenuActionGroupId, string);
        } else {
            popupHandler2 = null;
        }
        return popupHandler2;
    }

    @Override
    public boolean canZoomIn() {
        return this.getDeviceType() == DeviceType.XR_HEADSET || super.canZoomIn();
    }

    @Override
    public boolean canZoomOut() {
        return this.getDeviceType() == DeviceType.XR_HEADSET || super.canZoomOut();
    }

    @Override
    public boolean canZoomToActual() {
        return this.getDeviceType() != DeviceType.XR_HEADSET && super.canZoomToActual();
    }

    @Override
    public boolean canZoomToFit() {
        return this.getDeviceType() != DeviceType.XR_HEADSET && super.canZoomToFit();
    }

    @Override
    public boolean zoom(@NotNull ZoomType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (this.getDeviceType() == DeviceType.XR_HEADSET) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    AbstractXrInputController abstractXrInputController = this.getXrInputController$intellij_android_streaming();
                    if (abstractXrInputController != null) {
                        abstractXrInputController.sendTranslation(0.0f, 0.0f, -0.5f);
                    }
                    break;
                }
                case 2: {
                    AbstractXrInputController abstractXrInputController = this.getXrInputController$intellij_android_streaming();
                    if (abstractXrInputController == null) break;
                    abstractXrInputController.sendTranslation(0.0f, 0.0f, 0.5f);
                    break;
                }
            }
            return false;
        }
        return super.zoom(type);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u000bJ\f\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/streaming/core/AbstractDisplayView$DisconnectedStatePanel;", "Lcom/intellij/ui/components/JBPanel;", "<init>", "()V", "message", "Ljavax/swing/JEditorPane;", "button", "Ljavax/swing/JButton;", "getButton", "()Ljavax/swing/JButton;", "showPanel", "", "messageHtml", "", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "reconnector", "Lcom/android/tools/idea/streaming/core/AbstractDisplayView$Reconnector;", "Lcom/android/tools/idea/streaming/core/AbstractDisplayView;", "hidePanel", "createFiller", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nAbstractDisplayView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDisplayView.kt\ncom/android/tools/idea/streaming/core/AbstractDisplayView$DisconnectedStatePanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,568:1\n1#2:569\n*E\n"})
    private static final class DisconnectedStatePanel
    extends JBPanel<DisconnectedStatePanel> {
        @NotNull
        private final JEditorPane message;
        @NotNull
        private final JButton button;

        /*
         * WARNING - void declaration
         */
        public DisconnectedStatePanel() {
            super((LayoutManager)new GridBagLayout());
            GridBagConstraints gridBagConstraints;
            void $this$message_u24lambda_u240;
            JEditorPane jEditorPane;
            JEditorPane jEditorPane2 = jEditorPane = StreamingUtilsKt.textComponent$default("", 0, null, 6, null);
            DisconnectedStatePanel disconnectedStatePanel = this;
            boolean bl = false;
            $this$message_u24lambda_u240.setOpaque(false);
            $this$message_u24lambda_u240.setFocusable(false);
            $this$message_u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
            disconnectedStatePanel.message = jEditorPane;
            this.button = new JButton("Reconnect");
            this.setVisible(false);
            double topMargin = 0.45;
            GridBagConstraints $this$_init__u24lambda_u241 = gridBagConstraints = new GridBagConstraints();
            boolean bl2 = false;
            $this$_init__u24lambda_u241.fill = 1;
            $this$_init__u24lambda_u241.gridx = 0;
            $this$_init__u24lambda_u241.gridy = 0;
            $this$_init__u24lambda_u241.weightx = 1.0;
            $this$_init__u24lambda_u241.weighty = topMargin;
            GridBagConstraints c = gridBagConstraints;
            this.add((Component)this.createFiller(), c);
            c.gridy = 3;
            c.weighty = 1.0 - topMargin;
            this.add((Component)this.createFiller(), c);
            c.insets = (Insets)JBUI.insets((int)10);
            c.weighty = 0.0;
            c.fill = 2;
            c.gridy = 1;
            this.add(this.message, c);
            c.gridy = 2;
            c.fill = 0;
            this.add(this.button, c);
        }

        @NotNull
        public final JButton getButton() {
            return this.button;
        }

        public final void showPanel(@NotNull String messageHtml, @Nullable HyperlinkListener hyperlinkListener, @Nullable Reconnector reconnector) {
            JButton jButton;
            Intrinsics.checkNotNullParameter((Object)messageHtml, (String)"messageHtml");
            this.message.setText("<center>" + messageHtml + "</center>");
            if (hyperlinkListener != null) {
                this.message.addHyperlinkListener(hyperlinkListener);
            }
            JButton $this$showPanel_u24lambda_u243 = jButton = this.button;
            boolean bl = false;
            if (reconnector == null) {
                $this$showPanel_u24lambda_u243.setVisible(false);
            } else {
                $this$showPanel_u24lambda_u243.setVisible(true);
                String string = reconnector.getReconnectLabel();
                $this$showPanel_u24lambda_u243.setAction(new AbstractAction(reconnector, string){
                    final /* synthetic */ Reconnector $reconnector;
                    {
                        this.$reconnector = $reconnector;
                        super($super_call_param$1);
                    }

                    public void actionPerformed(ActionEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        this.$reconnector.start$intellij_android_streaming();
                    }
                });
                JRootPane jRootPane = SwingUtilities.getRootPane($this$showPanel_u24lambda_u243);
                if (jRootPane != null) {
                    JRootPane it = jRootPane;
                    boolean bl2 = false;
                    it.setDefaultButton($this$showPanel_u24lambda_u243);
                }
            }
            this.setVisible(true);
            this.revalidate();
        }

        public static /* synthetic */ void showPanel$default(DisconnectedStatePanel disconnectedStatePanel, String string, HyperlinkListener hyperlinkListener, Reconnector reconnector, int n, Object object) {
            if ((n & 4) != 0) {
                reconnector = null;
            }
            disconnectedStatePanel.showPanel(string, hyperlinkListener, reconnector);
        }

        public final void hidePanel() {
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.message.getHyperlinkListeners());
            while (iterator2.hasNext()) {
                HyperlinkListener listener2 = (HyperlinkListener)iterator2.next();
                this.message.removeHyperlinkListener(listener2);
            }
            this.setVisible(false);
            this.button.setAction(null);
            this.revalidate();
        }

        private final JBPanel<?> createFiller() {
            JBPanel jBPanel = new JBPanel().withBorder((Border)JBUI.Borders.empty()).withMinimumWidth(0).withMinimumHeight(0).withPreferredSize(0, 0).andTransparent();
            Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"andTransparent(...)");
            return jBPanel;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J/\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/core/AbstractDisplayView$FrameListener;", "", "frameRendered", "", "frameNumber", "Lkotlin/UInt;", "displayRectangle", "Ljava/awt/Rectangle;", "displayOrientationQuadrants", "", "displayImage", "Ljava/awt/image/BufferedImage;", "frameRendered-SGjrQA4", "(ILjava/awt/Rectangle;ILjava/awt/image/BufferedImage;)V", "intellij.android.streaming"})
    public static interface FrameListener {
        public void frameRendered-SGjrQA4(int var1, @NotNull Rectangle var2, int var3, @NotNull BufferedImage var4);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0014\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0007J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/streaming/core/AbstractDisplayView$HardwareInput;", "", "<init>", "()V", "pressedModifierKeys", "", "forwardEvent", "", "event", "Ljava/awt/event/KeyEvent;", "resetMetaKeys", "sendToDevice", "id", "keyCode", "modifiersEx", "Companion", "intellij.android.streaming"})
    protected static class HardwareInput {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int pressedModifierKeys;
        @NotNull
        private static final Map<Integer, Integer> vkToMask;

        public final void forwardEvent(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            event.consume();
            Integer n = vkToMask.get(event.getKeyCode());
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                switch (event.getID()) {
                    case 401: {
                        this.pressedModifierKeys |= it;
                        break;
                    }
                    case 402: {
                        this.pressedModifierKeys &= ~it;
                    }
                }
            }
            this.sendToDevice(event.getID(), event.getKeyCode(), event.getModifiersEx());
        }

        public final void resetMetaKeys() {
            if (this.pressedModifierKeys == 0) {
                return;
            }
            for (Map.Entry<Integer, Integer> entry : vkToMask.entrySet()) {
                int vk = ((Number)entry.getKey()).intValue();
                int mask = ((Number)entry.getValue()).intValue();
                if ((this.pressedModifierKeys & mask) == 0) continue;
                this.pressedModifierKeys &= ~mask;
                this.sendToDevice(402, vk, this.pressedModifierKeys);
            }
            this.pressedModifierKeys = 0;
        }

        public void sendToDevice(int id2, int keyCode, int modifiersEx) {
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)16, (Object)64), TuplesKt.to((Object)17, (Object)128), TuplesKt.to((Object)18, (Object)512), TuplesKt.to((Object)157, (Object)256), TuplesKt.to((Object)65406, (Object)8192)};
            vkToMask = MapsKt.mapOf((Pair[])pairArray);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/streaming/core/AbstractDisplayView$HardwareInput$Companion;", "", "<init>", "()V", "vkToMask", "", "", "intellij.android.streaming"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0084\u0004\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u001c\u0010\u0005\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u0010\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0005\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/streaming/core/AbstractDisplayView$Reconnector;", "", "reconnectLabel", "", "progressMessage", "reconnect", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "<init>", "(Lcom/android/tools/idea/streaming/core/AbstractDisplayView;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getReconnectLabel", "()Ljava/lang/String;", "getReconnect", "()Lkotlin/jvm/functions/Function1;", "Lkotlin/jvm/functions/Function1;", "start", "start$intellij_android_streaming", "intellij.android.streaming"})
    protected final class Reconnector {
        @NotNull
        private final String reconnectLabel;
        @NotNull
        private final String progressMessage;
        @NotNull
        private final Function1<Continuation<? super Unit>, Object> reconnect;

        public Reconnector(@NotNull String reconnectLabel, @NotNull String progressMessage, Function1<? super Continuation<? super Unit>, ? extends Object> reconnect) {
            Intrinsics.checkNotNullParameter((Object)reconnectLabel, (String)"reconnectLabel");
            Intrinsics.checkNotNullParameter((Object)progressMessage, (String)"progressMessage");
            Intrinsics.checkNotNullParameter(reconnect, (String)"reconnect");
            this.reconnectLabel = reconnectLabel;
            this.progressMessage = progressMessage;
            this.reconnect = reconnect;
        }

        @NotNull
        public final String getReconnectLabel() {
            return this.reconnectLabel;
        }

        @NotNull
        public final Function1<Continuation<? super Unit>, Object> getReconnect() {
            return this.reconnect;
        }

        public final void start$intellij_android_streaming() {
            AbstractDisplayView.this.hideDisconnectedStateMessage();
            AbstractDisplayView.this.showLongRunningOperationIndicator(this.progressMessage);
            BuildersKt.launch$default((CoroutineScope)CoroutineUtilsKt.createCoroutineScope$default((Disposable)AbstractDisplayView.this, null, null, (int)3, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ Reconnector this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.getReconnect().invoke((Object)((Object)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ZoomType.values().length];
            try {
                nArray[ZoomType.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

