/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.tools.idea.streaming.core.CenterAnchoredViewportKt;
import com.intellij.ui.components.JBViewport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J(\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/streaming/core/CenterAnchoredViewport;", "Lcom/intellij/ui/components/JBViewport;", "<init>", "()V", "layoutUnderway", "", "resizingUnderway", "setViewSize", "", "newSize", "Ljava/awt/Dimension;", "setViewPosition", "newViewPosition", "Ljava/awt/Point;", "doLayout", "setBounds", "x", "", "y", "width", "height", "computeCorrectedViewPosition", "newViewSize", "intellij.android.streaming"})
public final class CenterAnchoredViewport
extends JBViewport {
    private boolean layoutUnderway;
    private boolean resizingUnderway;

    public void setViewSize(@NotNull Dimension newSize) {
        Intrinsics.checkNotNullParameter((Object)newSize, (String)"newSize");
        Point correctedViewPosition = this.computeCorrectedViewPosition(newSize);
        super.setViewSize(newSize);
        if (!Intrinsics.areEqual((Object)correctedViewPosition, (Object)this.getViewPosition())) {
            super.setViewPosition(correctedViewPosition);
        }
    }

    public void setViewPosition(@NotNull Point newViewPosition) {
        Intrinsics.checkNotNullParameter((Object)newViewPosition, (String)"newViewPosition");
        if (this.getView() != null && !this.resizingUnderway) {
            Point correctedViewPosition = this.computeCorrectedViewPosition(newViewPosition);
            super.setViewPosition(correctedViewPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLayout() {
        this.layoutUnderway = true;
        try {
            super.doLayout();
        }
        finally {
            this.layoutUnderway = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(int x, int y, int width, int height) {
        Component view = this.getView();
        if (view != null && (width != this.getWidth() || height != this.getHeight())) {
            this.resizingUnderway = true;
            Point viewPosition = this.getViewPosition();
            Dimension viewPreferredSize = view.getPreferredSize();
            int minX = RangesKt.coerceAtLeast((int)(width - viewPreferredSize.width), (int)0) / 2;
            int minY = RangesKt.coerceAtLeast((int)(height - viewPreferredSize.height), (int)0) / 2;
            viewPosition.move(RangesKt.coerceAtLeast((int)(viewPosition.x + (this.getWidth() - width + (viewPosition.x & 1) >> 1)), (int)minX), RangesKt.coerceAtLeast((int)(viewPosition.y + (this.getHeight() - height + (viewPosition.y & 1) >> 1)), (int)minY));
            super.setViewPosition(viewPosition);
        }
        try {
            super.setBounds(x, y, width, height);
        }
        finally {
            this.resizingUnderway = false;
        }
    }

    private final Point computeCorrectedViewPosition(Dimension newViewSize) {
        Point viewPosition = this.getViewPosition();
        Component component = this.getView();
        if (component == null) {
            Intrinsics.checkNotNull((Object)viewPosition);
            return viewPosition;
        }
        Component view = component;
        if (this.scrollUnderway && !this.layoutUnderway || this.resizingUnderway) {
            Intrinsics.checkNotNull((Object)viewPosition);
            return viewPosition;
        }
        double oldViewWidth = view.getWidth();
        double oldViewHeight = view.getHeight();
        if (!view.isPreferredSizeSet() || oldViewWidth == 0.0 || oldViewHeight == 0.0) {
            Intrinsics.checkNotNull((Object)viewPosition);
            return viewPosition;
        }
        Dimension viewPreferredSize = view.getPreferredSize();
        if (viewPreferredSize.width <= this.getWidth() && viewPreferredSize.height <= this.getHeight()) {
            Intrinsics.checkNotNull((Object)viewPosition);
            return viewPosition;
        }
        double naturalAspectRatio = (double)viewPreferredSize.height / (double)viewPreferredSize.width;
        double oldContentOffsetX = RangesKt.coerceAtLeast((double)(oldViewWidth - oldViewHeight / naturalAspectRatio), (double)0.0) / (double)2;
        double oldContentOffsetY = RangesKt.coerceAtLeast((double)(oldViewHeight - oldViewWidth * naturalAspectRatio), (double)0.0) / (double)2;
        double newContentOffsetX = RangesKt.coerceAtLeast((double)((double)newViewSize.width - (double)newViewSize.height / naturalAspectRatio), (double)0.0) / (double)2;
        double newContentOffsetY = RangesKt.coerceAtLeast((double)((double)newViewSize.height - (double)newViewSize.width * naturalAspectRatio), (double)0.0) / (double)2;
        double scaleFactor = Math.max((double)newViewSize.width / oldViewWidth, (double)newViewSize.height / oldViewHeight);
        double viewportCenterX = (double)this.getWidth() / 2.0;
        double viewportCenterY = (double)this.getHeight() / 2.0;
        double oldFixedPointX = (double)viewPosition.x + viewportCenterX - oldContentOffsetX;
        double oldFixedPointY = (double)viewPosition.y + viewportCenterY - oldContentOffsetY;
        double newFixedPointX = oldFixedPointX * scaleFactor;
        double newFixedPointY = oldFixedPointY * scaleFactor;
        int x = newViewSize.width == view.getWidth() ? viewPosition.x : CenterAnchoredViewportKt.access$coerceInLenient(MathKt.roundToInt((double)(newFixedPointX - viewportCenterX + newContentOffsetX)), 0, newViewSize.width - this.getWidth());
        int y = newViewSize.height == view.getHeight() ? viewPosition.y : CenterAnchoredViewportKt.access$coerceInLenient(MathKt.roundToInt((double)(newFixedPointY - viewportCenterY + newContentOffsetY)), 0, newViewSize.height - this.getHeight());
        return new Point(x, y);
    }

    private final Point computeCorrectedViewPosition(Point newViewPosition) {
        Component component = this.getView();
        if (component == null) {
            return newViewPosition;
        }
        Component view = component;
        if (this.scrollUnderway && !this.layoutUnderway || !view.isPreferredSizeSet()) {
            return newViewPosition;
        }
        Point viewPosition = this.getViewPosition();
        return new Point(CenterAnchoredViewportKt.access$coerceInLenient(viewPosition.x, 0, view.getWidth() - this.getWidth()), CenterAnchoredViewportKt.access$coerceInLenient(viewPosition.y, 0, view.getHeight() - this.getHeight()));
    }
}

