/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.streaming.core.AbstractDisplayPanel;
import com.android.tools.idea.streaming.core.PanelState;
import com.android.tools.idea.streaming.core.SplitNode;
import com.android.tools.idea.streaming.core.SplitType;
import com.intellij.ui.OnePixelSplitter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0014H\u0002R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/streaming/core/SplitPanel;", "Ljavax/swing/JPanel;", "splitType", "Lcom/android/tools/idea/streaming/core/SplitType;", "proportion", "", "<init>", "(Lcom/android/tools/idea/streaming/core/SplitType;D)V", "layoutNode", "Lcom/android/tools/idea/streaming/core/SplitNode;", "(Lcom/android/tools/idea/streaming/core/SplitNode;)V", "value", "getSplitType", "()Lcom/android/tools/idea/streaming/core/SplitType;", "setSplitType", "(Lcom/android/tools/idea/streaming/core/SplitType;)V", "getProportion", "()D", "setProportion", "(D)V", "Ljavax/swing/JComponent;", "firstComponent", "getFirstComponent", "()Ljavax/swing/JComponent;", "setFirstComponent", "(Ljavax/swing/JComponent;)V", "secondComponent", "getSecondComponent", "setSecondComponent", "splitter", "Lcom/intellij/ui/OnePixelSplitter;", "getState", "Lcom/android/tools/idea/streaming/core/PanelState;", "getChildState", "child", "intellij.android.streaming"})
public final class SplitPanel
extends JPanel {
    @NotNull
    private final OnePixelSplitter splitter;

    public SplitPanel(@NotNull SplitType splitType, double proportion) {
        Intrinsics.checkNotNullParameter((Object)((Object)splitType), (String)"splitType");
        super(new BorderLayout());
        this.splitter = new OnePixelSplitter(splitType == SplitType.VERTICAL, (float)proportion, 0.1f, 0.9f);
        this.setBackground((Color)StudioColorsKt.getPrimaryPanelBackground());
        this.add((Component)this.splitter, "Center");
    }

    @NotNull
    public final SplitType getSplitType() {
        return this.splitter.getOrientation() ? SplitType.VERTICAL : SplitType.HORIZONTAL;
    }

    public final void setSplitType(@NotNull SplitType value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        this.splitter.setOrientation(value2 == SplitType.VERTICAL);
    }

    public final double getProportion() {
        return this.splitter.getProportion();
    }

    public final void setProportion(double value2) {
        this.splitter.setProportion((float)value2);
    }

    @NotNull
    public final JComponent getFirstComponent() {
        JComponent jComponent = this.splitter.getFirstComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getFirstComponent(...)");
        return jComponent;
    }

    public final void setFirstComponent(@NotNull JComponent value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.splitter.setFirstComponent(value2);
    }

    @NotNull
    public final JComponent getSecondComponent() {
        JComponent jComponent = this.splitter.getSecondComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getSecondComponent(...)");
        return jComponent;
    }

    public final void setSecondComponent(@NotNull JComponent value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.splitter.setSecondComponent(value2);
    }

    public SplitPanel(@NotNull SplitNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        this(layoutNode.getSplitType(), layoutNode.getSplitRatio());
    }

    @NotNull
    public final PanelState getState() {
        return new PanelState(this.getSplitType(), this.getProportion(), this.getChildState(this.getFirstComponent()), this.getChildState(this.getSecondComponent()));
    }

    private final PanelState getChildState(JComponent child) {
        PanelState panelState;
        JComponent jComponent = child;
        if (jComponent instanceof AbstractDisplayPanel) {
            panelState = new PanelState(((AbstractDisplayPanel)((Object)child)).getDisplayId());
        } else if (jComponent instanceof SplitPanel) {
            panelState = ((SplitPanel)child).getState();
        } else {
            throw new IllegalArgumentException();
        }
        return panelState;
    }
}

