/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.tools.idea.streaming.core.FloatingToolbarContainerKt;
import com.android.tools.idea.streaming.core.VolatileImageBufferingPainter;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.Path2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u000289B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010$\u001a\u00020\u0005H\u0014J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010*\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014J\u0018\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u00101\u001a\u00020/H\u0002J\b\u00102\u001a\u00020/H\u0002J\b\u00103\u001a\u000204H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR1\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138F@FX\u0086\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a*\u0004\b\u0015\u0010\u0016R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00105\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006:"}, d2={"Lcom/android/tools/idea/streaming/core/ToolbarPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "collapsible", "", "<init>", "(Lcom/intellij/openapi/actionSystem/ActionToolbar;Z)V", "getCollapsible", "()Z", "bufferingPainter", "Lcom/android/tools/idea/streaming/core/VolatileImageBufferingPainter;", "crossDimension", "", "getCrossDimension", "()I", "cornerRadius", "getCornerRadius", "<set-?>", "", "alpha", "getAlpha$delegate", "(Lcom/android/tools/idea/streaming/core/ToolbarPanel;)Ljava/lang/Object;", "getAlpha", "()F", "setAlpha", "(F)V", "alpha$receiver", "Lcom/android/tools/idea/streaming/core/VolatileImageBufferingPainter;", "actionButtons", "", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "hierarchyListener", "Ljava/awt/event/HierarchyListener;", "buttonSelectionListener", "Ljava/beans/PropertyChangeListener;", "isPaintingOrigin", "paintComponent", "", "g", "Ljava/awt/Graphics;", "paintBorder", "paintChildren", "paintWithTransparentCorners", "g2", "Ljava/awt/Graphics2D;", "outsideShape", "Ljava/awt/Shape;", "clearArea", "area", "createOutsideShape", "getMaximumSize", "Ljava/awt/Dimension;", "collapsedSize", "getCollapsedSize", "()Ljava/awt/Dimension;", "Layout", "Extent", "intellij.android.streaming"})
final class ToolbarPanel
extends BorderLayoutPanel {
    @NotNull
    private final ActionToolbar toolbar;
    private final boolean collapsible;
    @NotNull
    private VolatileImageBufferingPainter bufferingPainter;
    @NotNull
    private final VolatileImageBufferingPainter alpha$receiver;
    @NotNull
    private final List<ActionButton> actionButtons;
    @NotNull
    private final HierarchyListener hierarchyListener;
    @NotNull
    private final PropertyChangeListener buttonSelectionListener;

    public ToolbarPanel(@NotNull ActionToolbar toolbar, boolean collapsible) {
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        this.toolbar = toolbar;
        this.collapsible = collapsible;
        this.alpha$receiver = this.bufferingPainter = new VolatileImageBufferingPainter(3);
        this.actionButtons = new ArrayList();
        this.hierarchyListener = arg_0 -> ToolbarPanel.hierarchyListener$lambda$0(this, arg_0);
        this.buttonSelectionListener = arg_0 -> ToolbarPanel.buttonSelectionListener$lambda$1(this, arg_0);
        this.setOpaque(false);
        this.setBackground(JBUI.CurrentTheme.Popup.toolbarPanelColor());
        this.setLayout((LayoutManager)((Object)new Layout()));
        this.toolbar.getComponent().addHierarchyListener(this.hierarchyListener);
        this.add(this.toolbar.getComponent());
    }

    public final boolean getCollapsible() {
        return this.collapsible;
    }

    private final int getCrossDimension() {
        return this.toolbar.getOrientation() == 0 ? this.getHeight() : this.getWidth();
    }

    private final int getCornerRadius() {
        return this.getCrossDimension() / 2;
    }

    public final float getAlpha() {
        return this.alpha$receiver.getAlpha();
    }

    public final void setAlpha(float f) {
        this.alpha$receiver.setAlpha(f);
    }

    private static Object getAlpha$delegate(ToolbarPanel toolbarPanel) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)toolbarPanel.alpha$receiver, VolatileImageBufferingPainter.class, "alpha", "getAlpha()F", 0)));
    }

    protected boolean isPaintingOrigin() {
        return true;
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
    }

    protected void paintBorder(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
    }

    protected void paintChildren(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Shape outsideShape = this.createOutsideShape();
        Dimension dimension2 = this.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getSize(...)");
        this.bufferingPainter.paintBuffered(g, dimension2, (Function1<? super Graphics2D, Unit>)((Function1)arg_0 -> ToolbarPanel.paintChildren$lambda$2(this, outsideShape, arg_0)));
    }

    private final void paintWithTransparentCorners(Graphics2D g2, Shape outsideShape) {
        GraphicsUtil.setupAAPainting((Graphics)g2);
        if (this.getBackground() != null) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paintChildren((Graphics)g2);
        this.clearArea(g2, outsideShape);
        g2.setColor(JBUI.CurrentTheme.Toolbar.SEPARATOR_COLOR);
        g2.draw(FloatingToolbarContainerKt.access$createRoundRectangle(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.getCornerRadius()));
    }

    private final void clearArea(Graphics2D g2, Shape area) {
        GraphicsConfig config = GraphicsUtil.disableAAPainting((Graphics)g2);
        Composite composite = g2.getComposite();
        g2.setComposite(AlphaComposite.Clear);
        g2.fill(area);
        g2.setComposite(composite);
        config.restore();
    }

    private final Shape createOutsideShape() {
        Path2D.Double double_;
        Path2D.Double $this$createOutsideShape_u24lambda_u243 = double_ = new Path2D.Double(0);
        boolean bl = false;
        $this$createOutsideShape_u24lambda_u243.append(FloatingToolbarContainerKt.access$createRoundRectangle(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.getCornerRadius()), false);
        $this$createOutsideShape_u24lambda_u243.append(new Rectangle(0, 0, this.getWidth(), this.getHeight()), false);
        return double_;
    }

    @NotNull
    public Dimension getMaximumSize() {
        Dimension dimension2 = this.toolbar.getComponent().getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
        Insets insets = this.getInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
        return FloatingToolbarContainerKt.access$plus(dimension2, insets);
    }

    @NotNull
    public final Dimension getCollapsedSize() {
        Dimension maxSize = this.getMaximumSize();
        if (this.collapsible) {
            int s = Math.min(maxSize.width, maxSize.height);
            return new Dimension(s, s);
        }
        return maxSize;
    }

    private static final void hierarchyListener$lambda$0(ToolbarPanel this$0, HierarchyEvent event) {
        for (ActionButton button : this$0.actionButtons) {
            button.getPresentation().removePropertyChangeListener(this$0.buttonSelectionListener);
        }
        this$0.actionButtons.clear();
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this$0.toolbar.getComponent().getComponents());
        while (iterator2.hasNext()) {
            Component child = (Component)iterator2.next();
            if (!(child instanceof ActionButton)) continue;
            this$0.actionButtons.add((ActionButton)child);
            ((ActionButton)child).getPresentation().addPropertyChangeListener(this$0.buttonSelectionListener);
        }
    }

    private static final void buttonSelectionListener$lambda$1(ToolbarPanel this$0, PropertyChangeEvent event) {
        if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)FloatingToolbarContainerKt.access$getSELECTED_PROPERTY_NAME$p())) {
            this$0.revalidate();
        }
    }

    private static final Unit paintChildren$lambda$2(ToolbarPanel this$0, Shape $outsideShape, Graphics2D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.paintWithTransparentCorners(it, $outsideShape);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/streaming/core/ToolbarPanel$Extent;", "", "offset", "", "size", "<init>", "(II)V", "getOffset", "()I", "getSize", "intellij.android.streaming"})
    public static final class Extent {
        private final int offset;
        private final int size;

        public Extent(int offset, int size) {
            this.offset = offset;
            this.size = size;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final int getSize() {
            return this.size;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/streaming/core/ToolbarPanel$Layout;", "Lcom/intellij/util/ui/AbstractLayoutManager;", "<init>", "(Lcom/android/tools/idea/streaming/core/ToolbarPanel;)V", "orientation", "", "getOrientation", "()I", "preferredLayoutSize", "Ljava/awt/Dimension;", "parent", "Ljava/awt/Container;", "layoutContainer", "", "calculateToolbarOffset", "availableSize", "preferredToolbarSize", "locateAnchorButton", "Lcom/android/tools/idea/streaming/core/ToolbarPanel$Extent;", "intellij.android.streaming"})
    private final class Layout
    extends AbstractLayoutManager {
        private final int getOrientation() {
            return ToolbarPanel.this.toolbar.getOrientation();
        }

        @NotNull
        public Dimension preferredLayoutSize(@NotNull Container parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Dimension dimension2 = ToolbarPanel.this.toolbar.getComponent().getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
            Insets insets = ToolbarPanel.this.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
            return FloatingToolbarContainerKt.access$plus(dimension2, insets);
        }

        public void layoutContainer(@NotNull Container parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Insets insets = ToolbarPanel.this.getInsets();
            Dimension toolbarSize = ToolbarPanel.this.toolbar.getComponent().getPreferredSize();
            Dimension dimension2 = ToolbarPanel.this.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getSize(...)");
            Intrinsics.checkNotNull((Object)insets);
            Dimension dimension3 = FloatingToolbarContainerKt.access$minus(dimension2, insets);
            Intrinsics.checkNotNull((Object)toolbarSize);
            Dimension offset = this.calculateToolbarOffset(dimension3, toolbarSize);
            ToolbarPanel.this.toolbar.getComponent().setBounds(insets.left + offset.width, insets.top + offset.height, toolbarSize.width, toolbarSize.height);
        }

        private final Dimension calculateToolbarOffset(Dimension availableSize, Dimension preferredToolbarSize) {
            Insets insets = ToolbarPanel.this.toolbar.getComponent().getInsets();
            Intrinsics.checkNotNull((Object)insets);
            int available = FloatingToolbarContainerKt.access$get(FloatingToolbarContainerKt.access$minus(availableSize, insets), this.getOrientation());
            int preferred = FloatingToolbarContainerKt.access$get(FloatingToolbarContainerKt.access$minus(preferredToolbarSize, insets), this.getOrientation());
            if (preferred <= available) {
                return FloatingToolbarContainerKt.access$getZERO_DIMENSION$p();
            }
            Extent extent = this.locateAnchorButton();
            if (extent == null) {
                return FloatingToolbarContainerKt.access$getZERO_DIMENSION$p();
            }
            Extent anchorExtent = extent;
            if (preferred <= anchorExtent.getSize()) {
                return FloatingToolbarContainerKt.access$getZERO_DIMENSION$p();
            }
            int d = FloatingToolbarContainerKt.access$scaled(anchorExtent.getOffset(), preferred - available, preferred - anchorExtent.getSize());
            return this.getOrientation() == 0 ? new Dimension(-d, 0) : new Dimension(0, -d);
        }

        private final Extent locateAnchorButton() {
            int offset = 0;
            Extent firstEnabled = null;
            Extent firstVisible = null;
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])ToolbarPanel.this.toolbar.getComponent().getComponents());
            while (iterator2.hasNext()) {
                Component child = (Component)iterator2.next();
                if (!(child instanceof ActionButton) || !((ActionButton)child).isVisible()) continue;
                Dimension dimension2 = ((ActionButton)child).getPreferredSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
                int childSize = FloatingToolbarContainerKt.access$get(dimension2, this.getOrientation());
                if (((ActionButton)child).isSelected()) {
                    return new Extent(offset, childSize);
                }
                if (firstEnabled == null && ((ActionButton)child).isEnabled()) {
                    firstEnabled = new Extent(offset, childSize);
                }
                if (firstVisible == null) {
                    firstVisible = new Extent(offset, childSize);
                }
                offset += childSize;
            }
            Extent extent = firstEnabled;
            if (extent == null) {
                extent = firstVisible;
            }
            return extent;
        }
    }
}

