/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.tools.idea.streaming.device.ClipboardChangedNotification;
import com.android.tools.idea.streaming.device.CorrelatedMessage;
import com.android.tools.idea.streaming.device.DeviceStateNotification;
import com.android.tools.idea.streaming.device.DisplayAddedOrChangedNotification;
import com.android.tools.idea.streaming.device.DisplayConfigurationRequest;
import com.android.tools.idea.streaming.device.DisplayConfigurationResponse;
import com.android.tools.idea.streaming.device.DisplayRemovedNotification;
import com.android.tools.idea.streaming.device.ErrorResponse;
import com.android.tools.idea.streaming.device.KeyEventMessage;
import com.android.tools.idea.streaming.device.MotionEventMessage;
import com.android.tools.idea.streaming.device.RequestDeviceStateMessage;
import com.android.tools.idea.streaming.device.ResetUiSettingsRequest;
import com.android.tools.idea.streaming.device.SetDeviceOrientationMessage;
import com.android.tools.idea.streaming.device.SetMaxVideoResolutionMessage;
import com.android.tools.idea.streaming.device.StartAudioStreamMessage;
import com.android.tools.idea.streaming.device.StartClipboardSyncMessage;
import com.android.tools.idea.streaming.device.StartVideoStreamMessage;
import com.android.tools.idea.streaming.device.StopAudioStreamMessage;
import com.android.tools.idea.streaming.device.StopClipboardSyncMessage;
import com.android.tools.idea.streaming.device.StopVideoStreamMessage;
import com.android.tools.idea.streaming.device.SupportedDeviceStatesNotification;
import com.android.tools.idea.streaming.device.TextInputMessage;
import com.android.tools.idea.streaming.device.UiSettingsChangeRequest;
import com.android.tools.idea.streaming.device.UiSettingsChangeResponse;
import com.android.tools.idea.streaming.device.UiSettingsRequest;
import com.android.tools.idea.streaming.device.UiSettingsResponse;
import com.android.tools.idea.streaming.device.XrAngularVelocityMessage;
import com.android.tools.idea.streaming.device.XrEnvironmentChangedNotification;
import com.android.tools.idea.streaming.device.XrPassthroughCoefficientChangedNotification;
import com.android.tools.idea.streaming.device.XrRecenterMessage;
import com.android.tools.idea.streaming.device.XrRotationMessage;
import com.android.tools.idea.streaming.device.XrSetEnvironmentMessage;
import com.android.tools.idea.streaming.device.XrSetPassthroughCoefficientMessage;
import com.android.tools.idea.streaming.device.XrTranslationMessage;
import com.android.tools.idea.streaming.device.XrVelocityMessage;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.android.utils.FlightRecorder;
import com.android.utils.TraceUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u001b\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-.\u00a8\u0006/"}, d2={"Lcom/android/tools/idea/streaming/device/ControlMessage;", "", "type", "", "<init>", "(I)V", "getType", "()I", "serialize", "", "stream", "Lcom/android/utils/Base128OutputStream;", "equals", "", "other", "hashCode", "toString", "", "Deserializer", "Companion", "Lcom/android/tools/idea/streaming/device/ClipboardChangedNotification;", "Lcom/android/tools/idea/streaming/device/CorrelatedMessage;", "Lcom/android/tools/idea/streaming/device/DeviceStateNotification;", "Lcom/android/tools/idea/streaming/device/DisplayAddedOrChangedNotification;", "Lcom/android/tools/idea/streaming/device/DisplayRemovedNotification;", "Lcom/android/tools/idea/streaming/device/KeyEventMessage;", "Lcom/android/tools/idea/streaming/device/MotionEventMessage;", "Lcom/android/tools/idea/streaming/device/RequestDeviceStateMessage;", "Lcom/android/tools/idea/streaming/device/SetDeviceOrientationMessage;", "Lcom/android/tools/idea/streaming/device/SetMaxVideoResolutionMessage;", "Lcom/android/tools/idea/streaming/device/StartAudioStreamMessage;", "Lcom/android/tools/idea/streaming/device/StartClipboardSyncMessage;", "Lcom/android/tools/idea/streaming/device/StartVideoStreamMessage;", "Lcom/android/tools/idea/streaming/device/StopAudioStreamMessage;", "Lcom/android/tools/idea/streaming/device/StopClipboardSyncMessage;", "Lcom/android/tools/idea/streaming/device/StopVideoStreamMessage;", "Lcom/android/tools/idea/streaming/device/SupportedDeviceStatesNotification;", "Lcom/android/tools/idea/streaming/device/TextInputMessage;", "Lcom/android/tools/idea/streaming/device/XrAngularVelocityMessage;", "Lcom/android/tools/idea/streaming/device/XrEnvironmentChangedNotification;", "Lcom/android/tools/idea/streaming/device/XrPassthroughCoefficientChangedNotification;", "Lcom/android/tools/idea/streaming/device/XrRecenterMessage;", "Lcom/android/tools/idea/streaming/device/XrRotationMessage;", "Lcom/android/tools/idea/streaming/device/XrSetEnvironmentMessage;", "Lcom/android/tools/idea/streaming/device/XrSetPassthroughCoefficientMessage;", "Lcom/android/tools/idea/streaming/device/XrTranslationMessage;", "Lcom/android/tools/idea/streaming/device/XrVelocityMessage;", "intellij.android.streaming"})
public abstract sealed class ControlMessage
permits ClipboardChangedNotification, CorrelatedMessage, DeviceStateNotification, DisplayAddedOrChangedNotification, DisplayRemovedNotification, KeyEventMessage, MotionEventMessage, RequestDeviceStateMessage, SetDeviceOrientationMessage, SetMaxVideoResolutionMessage, StartAudioStreamMessage, StartClipboardSyncMessage, StartVideoStreamMessage, StopAudioStreamMessage, StopClipboardSyncMessage, StopVideoStreamMessage, SupportedDeviceStatesNotification, TextInputMessage, XrAngularVelocityMessage, XrEnvironmentChangedNotification, XrPassthroughCoefficientChangedNotification, XrRecenterMessage, XrRotationMessage, XrSetEnvironmentMessage, XrSetPassthroughCoefficientMessage, XrTranslationMessage, XrVelocityMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int type;

    private ControlMessage(int type) {
        this.type = type;
    }

    public final int getType() {
        return this.type;
    }

    public void serialize(@NotNull Base128OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.writeInt(this.type);
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        return Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    public /* synthetic */ ControlMessage(int type, DefaultConstructorMarker $constructor_marker) {
        this(type);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/streaming/device/ControlMessage$Companion;", "Lcom/android/tools/idea/streaming/device/ControlMessage$Deserializer;", "<init>", "()V", "deserialize", "Lcom/android/tools/idea/streaming/device/ControlMessage;", "stream", "Lcom/android/utils/Base128InputStream;", "intellij.android.streaming"})
    public static final class Companion
    implements Deserializer {
        private Companion() {
        }

        @Override
        @NotNull
        public ControlMessage deserialize(@NotNull Base128InputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int type = stream.readInt();
            ControlMessage message = switch (type) {
                case 1 -> MotionEventMessage.Companion.deserialize(stream);
                case 2 -> KeyEventMessage.Companion.deserialize(stream);
                case 3 -> TextInputMessage.Companion.deserialize(stream);
                case 4 -> SetDeviceOrientationMessage.Companion.deserialize(stream);
                case 5 -> SetMaxVideoResolutionMessage.Companion.deserialize(stream);
                case 6 -> StartVideoStreamMessage.Companion.deserialize(stream);
                case 7 -> StopVideoStreamMessage.Companion.deserialize(stream);
                case 8 -> StartAudioStreamMessage.Companion.deserialize(stream);
                case 9 -> StopAudioStreamMessage.Companion.deserialize(stream);
                case 10 -> StartClipboardSyncMessage.Companion.deserialize(stream);
                case 11 -> StopClipboardSyncMessage.Companion.deserialize(stream);
                case 12 -> RequestDeviceStateMessage.Companion.deserialize(stream);
                case 13 -> XrRotationMessage.Companion.deserialize(stream);
                case 14 -> XrTranslationMessage.Companion.deserialize(stream);
                case 15 -> XrAngularVelocityMessage.Companion.deserialize(stream);
                case 16 -> XrVelocityMessage.Companion.deserialize(stream);
                case 17 -> XrRecenterMessage.Companion.deserialize(stream);
                case 18 -> XrSetPassthroughCoefficientMessage.Companion.deserialize(stream);
                case 19 -> XrSetEnvironmentMessage.Companion.deserialize(stream);
                case 20 -> DisplayConfigurationRequest.Companion.deserialize(stream);
                case 21 -> ErrorResponse.Companion.deserialize(stream);
                case 22 -> DisplayConfigurationResponse.Companion.deserialize(stream);
                case 23 -> ClipboardChangedNotification.Companion.deserialize(stream);
                case 24 -> SupportedDeviceStatesNotification.Companion.deserialize(stream);
                case 25 -> DeviceStateNotification.Companion.deserialize(stream);
                case 26 -> DisplayAddedOrChangedNotification.Companion.deserialize(stream);
                case 27 -> DisplayRemovedNotification.Companion.deserialize(stream);
                case 28 -> XrPassthroughCoefficientChangedNotification.Companion.deserialize(stream);
                case 29 -> XrEnvironmentChangedNotification.Companion.deserialize(stream);
                case 30 -> UiSettingsRequest.Companion.deserialize(stream);
                case 31 -> UiSettingsResponse.Companion.deserialize(stream);
                case 32 -> UiSettingsChangeRequest.Companion.deserialize(stream);
                case 33 -> UiSettingsChangeResponse.Companion.deserialize(stream);
                case 34 -> ResetUiSettingsRequest.Companion.deserialize(stream);
                default -> throw new Base128InputStream.StreamFormatException("Unrecognized control message type " + type);
            };
            FlightRecorder.log(() -> Companion.deserialize$lambda$0(message));
            return message;
        }

        private static final Object deserialize$lambda$0(ControlMessage $message) {
            return TraceUtils.getCurrentTime() + " deserialize: message = " + $message;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/device/ControlMessage$Deserializer;", "", "deserialize", "Lcom/android/tools/idea/streaming/device/ControlMessage;", "stream", "Lcom/android/utils/Base128InputStream;", "intellij.android.streaming"})
    public static interface Deserializer {
        @NotNull
        public ControlMessage deserialize(@NotNull Base128InputStream var1);
    }
}

