/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.streaming.DeviceMirroringSettings;
import com.android.tools.idea.streaming.core.AbstractClipboardSynchronizer;
import com.android.tools.idea.streaming.device.DeviceClient;
import com.android.tools.idea.streaming.device.DeviceController;
import com.android.tools.idea.streaming.device.StartClipboardSyncMessage;
import com.android.tools.idea.streaming.device.StopClipboardSyncMessage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceClipboardSynchronizer;", "Lcom/android/tools/idea/streaming/core/AbstractClipboardSynchronizer;", "Lcom/android/tools/idea/streaming/device/DeviceController$DeviceClipboardListener;", "Lcom/intellij/openapi/Disposable;", "disposableParent", "deviceClient", "Lcom/android/tools/idea/streaming/device/DeviceClient;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/streaming/device/DeviceClient;)V", "deviceController", "Lcom/android/tools/idea/streaming/device/DeviceController;", "getDeviceController", "()Lcom/android/tools/idea/streaming/device/DeviceController;", "dispose", "", "setDeviceClipboard", "text", "", "forceSend", "", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nDeviceClipboardSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceClipboardSynchronizer.kt\ncom/android/tools/idea/streaming/device/DeviceClipboardSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,69:1\n24#2:70\n61#2,5:71\n*S KotlinDebug\n*F\n+ 1 DeviceClipboardSynchronizer.kt\ncom/android/tools/idea/streaming/device/DeviceClipboardSynchronizer\n*L\n55#1:70\n55#1:71,5\n*E\n"})
public final class DeviceClipboardSynchronizer
extends AbstractClipboardSynchronizer
implements DeviceController.DeviceClipboardListener,
Disposable {
    @NotNull
    private final DeviceClient deviceClient;

    public DeviceClipboardSynchronizer(@NotNull Disposable disposableParent, @NotNull DeviceClient deviceClient) {
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        Intrinsics.checkNotNullParameter((Object)deviceClient, (String)"deviceClient");
        super(disposableParent);
        this.deviceClient = deviceClient;
        DeviceController deviceController = this.getDeviceController();
        if (deviceController != null) {
            deviceController.addDeviceClipboardListener$intellij_android_streaming(this);
        }
        this.synchronizeDeviceClipboard(true);
    }

    private final DeviceController getDeviceController() {
        return this.deviceClient.getDeviceController$intellij_android_streaming();
    }

    @Override
    public void dispose() {
        DeviceController deviceController = this.getDeviceController();
        if (deviceController != null) {
            deviceController.removeDeviceClipboardListener$intellij_android_streaming(this);
        }
        DeviceController deviceController2 = this.getDeviceController();
        if (deviceController2 != null) {
            deviceController2.sendControlMessage(StopClipboardSyncMessage.Companion.getInstance());
        }
        super.dispose();
    }

    @Override
    @UiThread
    public void setDeviceClipboard(@NotNull String text2, boolean forceSend) {
        block12: {
            String string;
            int maxSyncedClipboardLength;
            block11: {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                if (this.isDisposed()) {
                    return;
                }
                if (((Boolean)StudioFlags.DEVICE_MIRRORING_TRACE_CLIPBOARD_SYNCHRONIZATION.get()).booleanValue()) {
                    DeviceClipboardSynchronizer $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(DeviceClipboardSynchronizer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    Logger $this$debug_u24default$iv = logger;
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger2 = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger2.debug("DeviceClipboardSynchronizer.setDeviceClipboard(\"" + text2 + "\", " + forceSend + ")", e$iv);
                    }
                }
                maxSyncedClipboardLength = DeviceMirroringSettings.Companion.getInstance().getMaxSyncedClipboardLength();
                if (forceSend) break block11;
                if (!(((CharSequence)text2).length() > 0) || Intrinsics.areEqual((Object)text2, (Object)this.getLastClipboardText())) break block12;
            }
            if (text2.length() <= maxSyncedClipboardLength) {
                string = text2;
            } else if (forceSend) {
                string = "";
            } else {
                return;
            }
            String adjustedText = string;
            StartClipboardSyncMessage message = new StartClipboardSyncMessage(maxSyncedClipboardLength, adjustedText);
            DeviceController deviceController = this.getDeviceController();
            if (deviceController != null) {
                deviceController.sendControlMessage(message);
            }
            this.setLastClipboardText(adjustedText);
        }
    }
}

