/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.annotations.concurrency.AnyThread;
import com.android.sdklib.deviceprovisioner.ProcessHandleProvider;
import com.android.sdklib.deviceprovisioner.RunningAvd;
import com.android.tools.concurrency.AndroidIoManager;
import com.android.tools.idea.avdmanager.RunningAvdTracker;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.streaming.emulator.CommandLineDecoderUtils;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.EmulatorId;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 <2\u00020\u0001:\u0002;<B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u0017H\u0007J\u0010\u0010+\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001cH\u0007J\u0010\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u0017H\u0002J\u0012\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050/J\b\u00100\u001a\u00020(H\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020$0\u001b2\u0006\u00102\u001a\u00020$H\u0002J\u0012\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u00020$H\u0002J\u0012\u00106\u001a\u0004\u0018\u0001072\u0006\u00105\u001a\u00020$H\u0002J\b\u00108\u001a\u00020(H\u0016J\b\u00109\u001a\u00020(H\u0016J\u0012\u0010:\u001a\u00020(2\b\u00102\u001a\u0004\u0018\u00010$H\u0007R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\"0!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog;", "Lcom/intellij/openapi/Disposable$Parent;", "<init>", "()V", "emulators", "", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "getEmulators", "()Ljava/util/Set;", "setEmulators", "(Ljava/util/Set;)V", "fileNamePattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "alarm", "Lcom/intellij/util/Alarm;", "isDisposing", "", "updateLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "dataLock", "Ljava/lang/Object;", "lastUpdateStartTime", "", "lastUpdateDuration", "nextScheduledUpdateTime", "listeners", "", "Lcom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog$Listener;", "updateIntervalsByListener", "Lit/unimi/dsi/fastutil/objects/Object2LongOpenHashMap;", "updateInterval", "pendingUpdateResults", "", "Lkotlinx/coroutines/CompletableDeferred;", "registrationDirectory", "Ljava/nio/file/Path;", "runningAvdTracker", "Lcom/android/tools/idea/avdmanager/RunningAvdTracker;", "addListener", "", "listener", "updateIntervalMillis", "removeListener", "scheduleUpdate", "delay", "updateNow", "Lkotlinx/coroutines/Deferred;", "update", "readDirectoryContents", "directory", "getProcessHandle", "Ljava/lang/ProcessHandle;", "file", "readEmulatorInfo", "Lcom/android/tools/idea/streaming/emulator/EmulatorId;", "beforeTreeDispose", "dispose", "overrideRegistrationDirectory", "Listener", "Companion", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nRunningEmulatorCatalog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunningEmulatorCatalog.kt\ncom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,535:1\n1#2:536\n1208#3,2:537\n1236#3,4:539\n24#4:543\n24#4:544\n24#4:546\n53#5:545\n*S KotlinDebug\n*F\n+ 1 RunningEmulatorCatalog.kt\ncom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog\n*L\n185#1:537,2\n185#1:539,4\n247#1:543\n274#1:544\n200#1:546\n385#1:545\n*E\n"})
public final class RunningEmulatorCatalog
implements Disposable.Parent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile Set<EmulatorController> emulators;
    private final Pattern fileNamePattern;
    @NotNull
    private final Alarm alarm;
    private volatile boolean isDisposing;
    @NotNull
    private final ReentrantReadWriteLock updateLock;
    @NotNull
    private final Object dataLock;
    private long lastUpdateStartTime;
    private long lastUpdateDuration;
    private long nextScheduledUpdateTime;
    @NotNull
    private List<? extends Listener> listeners;
    @NotNull
    private final Object2LongOpenHashMap<Listener> updateIntervalsByListener;
    private long updateInterval;
    @NotNull
    private List<CompletableDeferred<Set<EmulatorController>>> pendingUpdateResults;
    @Nullable
    private Path registrationDirectory;
    @Nullable
    private RunningAvdTracker runningAvdTracker;
    @NotNull
    private static final String REGISTRATION_DIRECTORY_RELATIVE_PATH = "avd/running";

    public RunningEmulatorCatalog() {
        ImmutableSet immutableSet = ImmutableSet.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"of(...)");
        this.emulators = (Set)immutableSet;
        this.fileNamePattern = Pattern.compile("pid_(\\d+).ini");
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.updateLock = new ReentrantReadWriteLock();
        this.dataLock = new Object();
        this.nextScheduledUpdateTime = Long.MAX_VALUE;
        this.listeners = CollectionsKt.emptyList();
        this.updateIntervalsByListener = new Object2LongOpenHashMap();
        this.updateInterval = Long.MAX_VALUE;
        this.pendingUpdateResults = new ArrayList();
        this.registrationDirectory = RunningEmulatorCatalog.Companion.computeRegistrationDirectory();
    }

    @NotNull
    public final Set<EmulatorController> getEmulators() {
        return this.emulators;
    }

    public final void setEmulators(@NotNull Set<EmulatorController> set2) {
        Intrinsics.checkNotNullParameter(set2, (String)"<set-?>");
        this.emulators = set2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public final void addListener(@NotNull Listener listener2, long updateIntervalMillis) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (!(updateIntervalMillis > 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            if (!((Map)this.updateIntervalsByListener).containsKey(listener2)) {
                this.listeners = CollectionsKt.plus((Collection)this.listeners, (Object)listener2);
            }
            ((Map)this.updateIntervalsByListener).put(listener2, updateIntervalMillis);
            Object2LongMap.FastEntrySet fastEntrySet = this.updateIntervalsByListener.object2LongEntrySet();
            Intrinsics.checkNotNullExpressionValue((Object)fastEntrySet, (String)"object2LongEntrySet(...)");
            Iterator iterator2 = ((Iterable)fastEntrySet).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            Object2LongMap.Entry it = (Object2LongMap.Entry)iterator2.next();
            boolean bl2 = false;
            long l = it.getLongValue();
            while (iterator2.hasNext()) {
                Object2LongMap.Entry it2 = (Object2LongMap.Entry)iterator2.next();
                $i$a$-minOf-RunningEmulatorCatalog$addListener$1$newUpdateInterval$1 = false;
                long l2 = it2.getLongValue();
                if (l <= l2) continue;
                l = l2;
            }
            long newUpdateInterval = l;
            if (newUpdateInterval != this.updateInterval) {
                this.updateInterval = newUpdateInterval;
                this.scheduleUpdate(this.updateInterval);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public final void removeListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            this.listeners = CollectionsKt.minus((Iterable)this.listeners, (Object)listener2);
            long interval = this.updateIntervalsByListener.removeLong((Object)listener2);
            if (interval == this.updateInterval) {
                if (this.updateIntervalsByListener.isEmpty()) {
                    this.updateInterval = Long.MAX_VALUE;
                } else {
                    Object2LongMap.FastEntrySet fastEntrySet = this.updateIntervalsByListener.object2LongEntrySet();
                    Intrinsics.checkNotNullExpressionValue((Object)fastEntrySet, (String)"object2LongEntrySet(...)");
                    Iterable iterable = (Iterable)fastEntrySet;
                    RunningEmulatorCatalog runningEmulatorCatalog = this;
                    Iterator iterator2 = iterable.iterator();
                    if (!iterator2.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object2LongMap.Entry it = (Object2LongMap.Entry)iterator2.next();
                    boolean bl2 = false;
                    Comparable comparable = Long.valueOf(it.getLongValue());
                    while (iterator2.hasNext()) {
                        Object2LongMap.Entry it2 = (Object2LongMap.Entry)iterator2.next();
                        $i$a$-minOf-RunningEmulatorCatalog$removeListener$1$1 = false;
                        Comparable comparable2 = Long.valueOf(it2.getLongValue());
                        if (comparable.compareTo(comparable2) <= 0) continue;
                        comparable = comparable2;
                    }
                    runningEmulatorCatalog.updateInterval = ((Number)((Object)comparable)).longValue();
                    this.scheduleUpdate(this.updateInterval);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleUpdate(long delay) {
        if (delay == Long.MAX_VALUE) {
            return;
        }
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            long updateTime = System.currentTimeMillis() + delay;
            if (this.nextScheduledUpdateTime > updateTime) {
                if (this.nextScheduledUpdateTime != Long.MAX_VALUE) {
                    this.alarm.cancelAllRequests();
                }
                this.nextScheduledUpdateTime = updateTime;
                this.alarm.addRequest(() -> RunningEmulatorCatalog.scheduleUpdate$lambda$6$lambda$5(this), delay);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Deferred<Set<EmulatorController>> updateNow() {
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            CompletableDeferred deferredResult = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
            this.pendingUpdateResults.add((CompletableDeferred<Set<EmulatorController>>)deferredResult);
            this.scheduleUpdate(0L);
            Deferred deferred = (Deferred)deferredResult;
            return deferred;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void update() {
        if (this.isDisposing) {
            return;
        }
        List<CompletableDeferred<Set<EmulatorController>>> updateResults = null;
        Path directory = null;
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            this.nextScheduledUpdateTime = Long.MAX_VALUE;
            if (this.pendingUpdateResults.isEmpty()) {
                updateResults = CollectionsKt.emptyList();
            } else {
                updateResults = this.pendingUpdateResults;
                this.pendingUpdateResults = new ArrayList();
            }
            Path path = this.registrationDirectory;
            if (path == null) {
                return;
            }
            directory = path;
            Unit $i$a$-synchronized-RunningEmulatorCatalog$update$2 = Unit.INSTANCE;
        }
        try {
            Iterator<Path> $this$associateByTo$iv$iv;
            long start2 = System.currentTimeMillis();
            List<Path> files2 = this.readDirectoryContents(directory);
            Iterable $this$associateBy$iv = this.emulators;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo232 = false;
            Iterator iterator2 = $this$associateByTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                EmulatorController emulatorController = (EmulatorController)((Object)t);
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(emulatorController.getEmulatorId(), t);
            }
            Map oldEmulators = destination$iv$iv;
            ConcurrentHashMap newEmulators = new ConcurrentHashMap();
            if (!((Collection)files2).isEmpty() && !this.isDisposing) {
                CountDownLatch latch = new CountDownLatch(files2.size());
                ExecutorService executor = AndroidIoManager.Companion.getInstance().getBackgroundDiskIoExecutor();
                for (Path file : files2) {
                    executor.submit(() -> RunningEmulatorCatalog.update$lambda$10(this, file, oldEmulators, newEmulators, latch));
                }
                latch.await();
            }
            Set set2 = newEmulators.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
            Collection removedEmulators = MapsKt.minus((Map)oldEmulators, (Iterable)set2).values();
            Collection addedEmulators = MapsKt.minus((Map)newEmulators, (Iterable)oldEmulators.keySet()).values();
            List<? extends Listener> listenersSnapshot = null;
            Object $i$f$associateByTo232 = this.dataLock;
            synchronized ($i$f$associateByTo232) {
                boolean bl = false;
                if (this.isDisposing) {
                    return;
                }
                this.lastUpdateStartTime = start2;
                this.lastUpdateDuration = System.currentTimeMillis() - start2;
                ImmutableSet immutableSet = ImmutableSet.copyOf(newEmulators.values());
                Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"copyOf(...)");
                this.emulators = (Set)immutableSet;
                listenersSnapshot = this.listeners;
                for (CompletableDeferred<Set<EmulatorController>> completableDeferred : updateResults) {
                    completableDeferred.complete(this.emulators);
                }
                if (!this.isDisposing) {
                    this.scheduleUpdate(this.updateInterval);
                }
                Unit $i$a$-synchronized-RunningEmulatorCatalog$update$5 = Unit.INSTANCE;
            }
            if (!((Collection)listenersSnapshot).isEmpty()) {
                block14: for (EmulatorController emulator : removedEmulators) {
                    if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_DISCOVERY.get()).booleanValue()) {
                        RunningEmulatorCatalog $this$thisLogger$iv = this;
                        boolean bl = false;
                        Logger logger = Logger.getInstance(RunningEmulatorCatalog.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.info("Emulator " + emulator.getEmulatorId() + " stopped");
                    }
                    for (Listener listener2 : listenersSnapshot) {
                        if (this.isDisposing) continue block14;
                        listener2.emulatorRemoved(emulator);
                    }
                }
                block16: for (EmulatorController emulator : addedEmulators) {
                    ProcessHandle processHandle;
                    ProcessHandle processHandle2 = processHandle = ProcessHandleProvider.INSTANCE.getProcessHandle(emulator.getEmulatorId().getPid());
                    boolean bl = processHandle2 != null ? processHandle2.isAlive() : false;
                    if (bl) {
                        RunningAvdTracker runningAvdTracker = this.runningAvdTracker;
                        if (runningAvdTracker == null) {
                            RunningAvdTracker runningAvdTracker2;
                            RunningAvdTracker it = runningAvdTracker2 = RunningAvdTracker.Companion.getInstance();
                            boolean bl2 = false;
                            this.runningAvdTracker = it;
                            runningAvdTracker = runningAvdTracker2;
                        }
                        RunningAvdTracker runningAvdTracker3 = runningAvdTracker;
                        RunningAvdTracker.started$default(runningAvdTracker3, emulator.getEmulatorId().getAvdFolder(), processHandle, emulator.getEmulatorId().isEmbedded() ? RunningAvd.RunType.EMBEDDED : RunningAvd.RunType.STANDALONE, null, 8, null);
                    }
                    for (Listener listener3 : listenersSnapshot) {
                        if (this.isDisposing) continue block16;
                        listener3.emulatorAdded(emulator);
                    }
                }
            }
            for (EmulatorController emulator : removedEmulators) {
                Disposer.dispose((Disposable)emulator);
            }
        }
        catch (IOException e) {
            RunningEmulatorCatalog $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(RunningEmulatorCatalog.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Running Emulator detection failed", (Throwable)e);
            Object object2 = this.dataLock;
            synchronized (object2) {
                boolean bl = false;
                for (CompletableDeferred<Set<EmulatorController>> result3 : updateResults) {
                    result3.completeExceptionally((Throwable)e);
                }
                if (!this.isDisposing) {
                    this.scheduleUpdate(this.updateInterval);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Path> readDirectoryContents(Path directory) {
        List<Object> list;
        try {
            List<Object> list2;
            AutoCloseable autoCloseable = Files.list(directory);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl = false;
                list2 = stream.filter(arg_0 -> RunningEmulatorCatalog.readDirectoryContents$lambda$16$lambda$15(arg_0 -> RunningEmulatorCatalog.readDirectoryContents$lambda$16$lambda$14(this, arg_0), arg_0)).toList();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            list = list2;
            Intrinsics.checkNotNull(list);
        }
        catch (NoSuchFileException noSuchFileException) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final ProcessHandle getProcessHandle(Path file) {
        ProcessHandle processHandle;
        long l;
        Matcher matcher = this.fileNamePattern.matcher(((Object)file.getFileName()).toString());
        if (!matcher.matches()) {
            return null;
        }
        try {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        long pid = l;
        ProcessHandle processHandle2 = processHandle = ProcessHandleProvider.INSTANCE.getProcessHandle(pid);
        return (processHandle2 != null ? processHandle2.isAlive() : false) ? processHandle : null;
    }

    private final EmulatorId readEmulatorInfo(Path file) {
        ProcessHandle processHandle = this.getProcessHandle(file);
        if (processHandle == null) {
            return null;
        }
        long pid = processHandle.pid();
        int grpcPort = 0;
        String grpcCertificate = null;
        String grpcToken = null;
        String avdId = null;
        String avdName = null;
        Path avdFolder = null;
        int serialPort = 0;
        int adbPort = 0;
        List<String> commandLine = CollectionsKt.emptyList();
        try {
            for (String line : Files.readAllLines(file)) {
                Intrinsics.checkNotNull((Object)line);
                if (StringsKt.startsWith$default((String)line, (String)"grpc.port=", (boolean)false, (int)2, null)) {
                    String string = line.substring(10);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    grpcPort = StringUtil.parseInt((String)string, (int)0);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"grpc.certificate=", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNullExpressionValue((Object)line.substring(17), (String)"substring(...)");
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"grpc.token=", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNullExpressionValue((Object)line.substring(11), (String)"substring(...)");
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"avd.id=", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNullExpressionValue((Object)line.substring(7), (String)"substring(...)");
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"avd.name=", (boolean)false, (int)2, null)) {
                    String name2;
                    Intrinsics.checkNotNullExpressionValue((Object)line.substring(9), (String)"substring(...)");
                    avdName = StringsKt.contains$default((CharSequence)name2, (char)' ', (boolean)false, (int)2, null) ? name2 : StringsKt.replace$default((String)name2, (char)'_', (char)' ', (boolean)false, (int)4, null);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"avd.dir=", (boolean)false, (int)2, null)) {
                    String string = line.substring(8);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                    avdFolder = Paths.get(string, new String[0]).toRealPath(linkOptionArray);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"port.serial=", (boolean)false, (int)2, null)) {
                    String string = line.substring(12);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    serialPort = StringUtil.parseInt((String)string, (int)0);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"port.adb=", (boolean)false, (int)2, null)) {
                    String string = line.substring(9);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    adbPort = StringUtil.parseInt((String)string, (int)0);
                    continue;
                }
                if (!StringsKt.startsWith$default((String)line, (String)"cmdline=", (boolean)false, (int)2, null)) continue;
                String string = line.substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                commandLine = CommandLineDecoderUtils.decodeCommandLine(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (grpcPort <= 0 || avdId == null || avdName == null || avdFolder == null || serialPort <= 0 && adbPort <= 0 || commandLine.isEmpty()) {
            return null;
        }
        return new EmulatorId(pid, grpcPort, grpcCertificate, grpcToken, avdName, avdFolder, serialPort, adbPort, commandLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTreeDispose() {
        this.isDisposing = true;
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            boolean $i$f$serviceIfCreated = false;
            Application application = ApplicationManager.getApplication();
            Object object2 = (RunningAvdTracker)(application != null ? application.getServiceIfCreated(RunningAvdTracker.class) : null);
            if (object2 == null || (object2 = ((RunningAvdTracker)object2).getRunningAvds()) == null) {
                object2 = MapsKt.emptyMap();
            }
            Object runningAvds = object2;
            for (EmulatorController emulator : this.emulators) {
                if (!emulator.getEmulatorId().isEmbedded()) continue;
                RunningAvd runningAvd = (RunningAvd)runningAvds.get(emulator.getEmulatorId().getAvdFolder());
                boolean bl2 = runningAvd != null ? runningAvd.isLaunchedByThisProcess() : false;
                if (!bl2) continue;
                emulator.shutdown();
                Path path = this.registrationDirectory;
                if (path == null || (path = path.resolve("pid_" + emulator.getEmulatorId().getPid() + ".ini")) == null) continue;
                Files.deleteIfExists(path);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void overrideRegistrationDirectory(@Nullable Path directory) {
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            this.listeners = CollectionsKt.emptyList();
            this.updateIntervalsByListener.clear();
            for (EmulatorController emulator : this.emulators) {
                Disposer.dispose((Disposable)emulator);
            }
            this.emulators = SetsKt.emptySet();
            Path path = directory;
            if (path == null) {
                path = RunningEmulatorCatalog.Companion.computeRegistrationDirectory();
            }
            this.registrationDirectory = path;
            Unit unit = Unit.INSTANCE;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.updateLock;
        object = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            ((ReentrantReadWriteLock.ReadLock)object).unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                ((ReentrantReadWriteLock.ReadLock)object).lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void scheduleUpdate$lambda$6$lambda$5(RunningEmulatorCatalog this$0) {
        ReentrantReadWriteLock.ReadLock readLock = this$0.updateLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            this$0.update();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    private static final void update$lambda$10(RunningEmulatorCatalog this$0, Path $file, Map $oldEmulators, ConcurrentHashMap $newEmulators, CountDownLatch $latch) {
        EmulatorId emulatorId;
        EmulatorController emulator = null;
        boolean created = false;
        if (!this$0.isDisposing && (emulatorId = this$0.readEmulatorInfo($file)) != null) {
            emulator = (EmulatorController)((Object)$oldEmulators.get(emulatorId));
            if (emulator == null) {
                if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_DISCOVERY.get()).booleanValue()) {
                    RunningEmulatorCatalog $this$thisLogger$iv = this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(RunningEmulatorCatalog.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info("Discovered emulator " + emulatorId);
                }
                emulator = new EmulatorController(emulatorId, (Disposable)this$0);
                if (emulatorId.isEmbedded()) {
                    emulator.loadEmulatorConfiguration();
                }
                created = true;
            }
            if (!this$0.isDisposing) {
                ((Map)$newEmulators).put(emulator.getEmulatorId(), emulator);
            }
        }
        $latch.countDown();
        if (emulator != null && created && emulator.getEmulatorId().isEmbedded()) {
            emulator.connect();
        }
    }

    private static final boolean readDirectoryContents$lambda$16$lambda$14(RunningEmulatorCatalog this$0, Path it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.getProcessHandle(it) != null;
    }

    private static final boolean readDirectoryContents$lambda$16$lambda$15(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final RunningEmulatorCatalog getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    private static final Path computeRegistrationDirectory() {
        return RunningEmulatorCatalog.Companion.computeRegistrationDirectory();
    }

    @JvmStatic
    private static final Path computeRegistrationDirectoryContainer() {
        return RunningEmulatorCatalog.Companion.computeRegistrationDirectoryContainer();
    }

    @JvmStatic
    private static final Path resolvePath(String pattern) {
        return RunningEmulatorCatalog.Companion.resolvePath(pattern);
    }

    @JvmStatic
    private static final String getEnvironmentVariable(String name2) {
        return RunningEmulatorCatalog.Companion.getEnvironmentVariable(name2);
    }

    @JvmStatic
    private static final String getUid() {
        return RunningEmulatorCatalog.Companion.getUid();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0003J\n\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0003J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0003R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog;", "computeRegistrationDirectory", "Ljava/nio/file/Path;", "computeRegistrationDirectoryContainer", "resolvePath", "pattern", "", "getEnvironmentVariable", "name", "getUid", "REGISTRATION_DIRECTORY_RELATIVE_PATH", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nRunningEmulatorCatalog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunningEmulatorCatalog.kt\ncom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,535:1\n24#2:536\n*S KotlinDebug\n*F\n+ 1 RunningEmulatorCatalog.kt\ncom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog$Companion\n*L\n447#1:536\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RunningEmulatorCatalog getInstance() {
            Object object = ApplicationManager.getApplication().getService(RunningEmulatorCatalog.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (RunningEmulatorCatalog)object;
        }

        @JvmStatic
        private final Path computeRegistrationDirectory() {
            Path container = this.computeRegistrationDirectoryContainer();
            if (container == null) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Unable to determine Emulator registration directory");
            }
            Path path = container;
            return path != null ? path.resolve(RunningEmulatorCatalog.REGISTRATION_DIRECTORY_RELATIVE_PATH) : null;
        }

        @JvmStatic
        private final Path computeRegistrationDirectoryContainer() {
            if (SystemInfo.isMac) {
                return this.resolvePath("{HOME}/Library/Caches/TemporaryItems");
            }
            if (SystemInfo.isWindows) {
                return this.resolvePath("{LOCALAPPDATA}/Temp");
            }
            String[] stringArray = new String[]{"{XDG_RUNTIME_DIR}", "/run/user/{UID}", "{HOME}/.android"};
            for (String pattern : stringArray) {
                Path dir;
                if (this.resolvePath(pattern) == null || !Files.isDirectory(dir, new LinkOption[0])) continue;
                return dir;
            }
            return this.resolvePath(FileUtil.getTempDirectory() + "/android-{USER}");
        }

        @JvmStatic
        private final Path resolvePath(String pattern) {
            StringBuilder result2 = new StringBuilder();
            StringBuilder name2 = new StringBuilder();
            int braceDepth = 0;
            int n = pattern.length();
            for (int i = 0; i < n; ++i) {
                Comparable<Integer> comparable;
                char c = pattern.charAt(i);
                if (c == '{') {
                    comparable = braceDepth++;
                    continue;
                }
                if (c == '}') {
                    if (--braceDepth == 0 && ((CharSequence)name2).length() > 0) {
                        String string = name2.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        String value2 = this.getEnvironmentVariable(string);
                        result2.append(value2);
                        StringsKt.clear((StringBuilder)name2);
                    }
                    comparable = Unit.INSTANCE;
                    continue;
                }
                comparable = braceDepth > 0 ? name2.append(c) : result2.append(c);
            }
            return Paths.get(result2.toString(), new String[0]);
        }

        @JvmStatic
        private final String getEnvironmentVariable(String name2) {
            String value2 = System.getenv(name2);
            if (value2 == null && Intrinsics.areEqual((Object)name2, (Object)"UID")) {
                return this.getUid();
            }
            return value2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        private final String getUid() {
            try {
                String userName = System.getProperty("user.name");
                String command = "id -u " + userName;
                Process process2 = Runtime.getRuntime().exec(command);
                Closeable closeable = process2.getInputStream();
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    byte[] byArray = ByteStreamsKt.readBytes((InputStream)it);
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset charset2 = charset;
                    String result2 = ((Object)StringsKt.trim((CharSequence)new String(byArray, charset2))).toString();
                    if (((CharSequence)result2).length() == 0) {
                        String string = null;
                        return string;
                    }
                    String string = result2;
                    return string;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog$Listener;", "", "emulatorAdded", "", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "emulatorRemoved", "intellij.android.streaming"})
    public static interface Listener {
        @AnyThread
        public void emulatorAdded(@NotNull EmulatorController var1);

        @AnyThread
        public void emulatorRemoved(@NotNull EmulatorController var1);
    }
}

