/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidClassBrowserBase<T extends JComponent>
extends BrowseModuleValueActionListener<T> {
    protected final ConfigurationModuleSelector myModuleSelector;
    protected final String myDialogTitle;
    protected final boolean myIncludeLibraryClasses;

    public AndroidClassBrowserBase(@NotNull Project project, @NotNull ConfigurationModuleSelector moduleSelector2, @NotNull String dialogTitle, boolean includeLibraryClasses) {
        super(project);
        this.myIncludeLibraryClasses = includeLibraryClasses;
        this.myDialogTitle = dialogTitle;
        this.myModuleSelector = moduleSelector2;
    }

    @Nullable
    protected PsiClass findClass(String className) {
        return this.myModuleSelector.findClass(className);
    }

    @Nullable
    protected Module getModuleForScope() {
        return this.myModuleSelector.getModule();
    }

    protected String showDialog() {
        PsiClass initialSelection;
        Project project = this.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        Module module = this.getModuleForScope();
        if (module == null) {
            Messages.showErrorDialog((Project)project, (String)ExecutionBundle.message((String)"module.not.specified.error.text", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
            return null;
        }
        GlobalSearchScope scope = this.myIncludeLibraryClasses ? module.getModuleWithDependenciesAndLibrariesScope(true) : module.getModuleWithDependenciesScope();
        TreeClassChooser chooser = this.createTreeClassChooser(project, scope, initialSelection = facade.findClass(this.getText(), scope), new ClassFilter(this){

            public boolean isAccepted(PsiClass aClass) {
                if (aClass.isInterface()) {
                    return false;
                }
                PsiModifierList modifierList = aClass.getModifierList();
                return modifierList == null || !modifierList.hasModifierProperty("abstract");
            }
        });
        if (chooser == null) {
            return null;
        }
        chooser.showDialog();
        PsiClass selClass = chooser.getSelected();
        return selClass != null ? selClass.getQualifiedName() : null;
    }

    @Nullable
    protected abstract TreeClassChooser createTreeClassChooser(@NotNull Project var1, @NotNull GlobalSearchScope var2, @Nullable PsiClass var3, @NotNull ClassFilter var4);
}

