/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ProfileableClient;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.io.grpc.Channel;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.MethodDescriptor;
import com.android.tools.idea.io.grpc.ServerCallHandler;
import com.android.tools.idea.io.grpc.ServerServiceDefinition;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.io.grpc.stub.AbstractStub;
import com.android.tools.idea.io.grpc.stub.ServerCalls;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.ClientSummary;
import com.android.tools.idea.transport.ServiceProxy;
import com.android.tools.idea.transport.TransportBytesPreprocessor;
import com.android.tools.idea.transport.TransportEventPreprocessor;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.idea.transport.TransportServiceProxy;
import com.android.tools.idea.transport.TransportServiceProxyKt;
import com.android.tools.idea.transport.TransportServiceUtils;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\b\u0018\u0000 j2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001jBA\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010*\u001a\u0004\u0018\u00010 2\u0006\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020 J\u000e\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020#J\u000e\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020%J\b\u00101\u001a\u000202H\u0016J\u001e\u00103\u001a\u0002022\u0006\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0002J\u001e\u00109\u001a\u0002022\u0006\u00104\u001a\u00020:2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\f07H\u0007J\u001e\u0010;\u001a\u0002022\u0006\u00104\u001a\u00020<2\f\u00106\u001a\b\u0012\u0004\u0012\u00020=07H\u0007J\u001c\u0010>\u001a\u0002022\u0006\u00104\u001a\u00020<2\f\u00106\u001a\b\u0012\u0004\u0012\u00020?07J\u0018\u0010@\u001a\n \u0014*\u0004\u0018\u00010\f0\f2\u0006\u0010A\u001a\u00020\fH\u0002J\u001e\u0010B\u001a\u0002022\u0006\u00104\u001a\u00020C2\f\u00106\u001a\b\u0012\u0004\u0012\u00020D07H\u0002J\u001e\u0010E\u001a\u0002022\u0006\u00104\u001a\u00020F2\f\u00106\u001a\b\u0012\u0004\u0012\u00020G07H\u0002J\u001e\u0010H\u001a\u0002022\u0006\u00104\u001a\u00020I2\f\u00106\u001a\b\u0012\u0004\u0012\u00020J07H\u0007J\u0010\u0010K\u001a\u0002022\u0006\u0010L\u001a\u00020\u0005H\u0016J\u0010\u0010M\u001a\u0002022\u0006\u0010L\u001a\u00020\u0005H\u0016J\u0018\u0010N\u001a\u0002022\u0006\u0010L\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\u0016H\u0016J\b\u0010P\u001a\u00020\u001bH\u0002J\u0018\u0010Q\u001a\u0002022\u0006\u0010R\u001a\u00020S2\u0006\u0010O\u001a\u00020\u0016H\u0016J\b\u0010T\u001a\u00020UH\u0016J\b\u0010V\u001a\u000202H\u0002J\b\u0010W\u001a\u000202H\u0002J\b\u0010X\u001a\u000202H\u0002JK\u0010X\u001a\u000202\"\u0004\b\u0000\u0010Y2\u001d\u0010Z\u001a\u0019\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002HY0\\0[\u00a2\u0006\u0002\b]2\u0014\u0010^\u001a\u0010\u0012\u0004\u0012\u0002HY\u0012\u0006\u0012\u0004\u0018\u00010_0[2\u0006\u0010`\u001a\u00020aH\u0002J,\u0010X\u001a\u0002022\f\u0010b\u001a\b\u0012\u0004\u0012\u00020_0c2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00160c2\u0006\u0010`\u001a\u00020aH\u0002J \u0010e\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020_2\u0006\u0010f\u001a\u00020'2\u0006\u0010`\u001a\u00020aH\u0002J\u001f\u0010g\u001a\u0004\u0018\u00010\u001b2\u0006\u0010h\u001a\u00020\u00162\u0006\u0010f\u001a\u00020'H\u0002\u00a2\u0006\u0002\u0010iR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lcom/android/tools/idea/transport/TransportServiceProxy;", "Lcom/android/tools/idea/transport/ServiceProxy;", "Lcom/android/ddmlib/AndroidDebugBridge$IClientChangeListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IDeviceChangeListener;", "ddmlibDevice", "Lcom/android/ddmlib/IDevice;", "transportDevice", "Lcom/android/tools/profiler/proto/Common$Device;", "channel", "Lcom/android/tools/idea/io/grpc/ManagedChannel;", "proxyEventQueue", "Ljava/util/concurrent/BlockingDeque;", "Lcom/android/tools/profiler/proto/Common$Event;", "proxyFilePathCache", "", "", "<init>", "(Lcom/android/ddmlib/IDevice;Lcom/android/tools/profiler/proto/Common$Device;Lcom/android/tools/idea/io/grpc/ManagedChannel;Ljava/util/concurrent/BlockingDeque;Ljava/util/Map;)V", "serviceStub", "Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;", "kotlin.jvm.PlatformType", "cachedProcesses", "", "Lcom/android/tools/profiler/proto/Common$Process;", "getCachedProcesses", "()Ljava/util/Map;", "isDeviceApiSupported", "", "eventsListenerThread", "Ljava/lang/Thread;", "commandHandlers", "Lcom/android/tools/profiler/proto/Commands$Command$CommandType;", "Lcom/android/tools/idea/transport/TransportProxy$ProxyCommandHandler;", "eventPreprocessors", "", "Lcom/android/tools/idea/transport/TransportEventPreprocessor;", "dataPreprocessors", "Lcom/android/tools/idea/transport/TransportBytesPreprocessor;", "latestEventTimestampNs", "", "eventStreamingLatch", "Ljava/util/concurrent/CountDownLatch;", "registerCommandHandler", "commandType", "handler", "registerEventPreprocessor", "eventPreprocessor", "registerDataPreprocessor", "dataPreprocessor", "disconnect", "", "getVersion", "request", "Lcom/android/tools/profiler/proto/Transport$VersionRequest;", "responseObserver", "Lcom/android/tools/idea/io/grpc/stub/StreamObserver;", "Lcom/android/tools/profiler/proto/Transport$VersionResponse;", "getEvents", "Lcom/android/tools/profiler/proto/Transport$GetEventsRequest;", "getFile", "Lcom/android/tools/profiler/proto/Transport$BytesRequest;", "Lcom/android/tools/profiler/proto/Transport$FileResponse;", "getBytesInChunks", "Lcom/android/tools/profiler/proto/Transport$BytesInChunksResponse;", "generateEndEvent", "previousEvent", "getCurrentTime", "Lcom/android/tools/profiler/proto/Transport$TimeRequest;", "Lcom/android/tools/profiler/proto/Transport$TimeResponse;", "getProcesses", "Lcom/android/tools/profiler/proto/Transport$GetProcessesRequest;", "Lcom/android/tools/profiler/proto/Transport$GetProcessesResponse;", "execute", "Lcom/android/tools/profiler/proto/Transport$ExecuteRequest;", "Lcom/android/tools/profiler/proto/Transport$ExecuteResponse;", "deviceConnected", "device", "deviceDisconnected", "deviceChanged", "changeMask", "isProfileableSupported", "clientChanged", "client", "Lcom/android/ddmlib/Client;", "getServiceDefinition", "Lcom/android/tools/idea/io/grpc/ServerServiceDefinition;", "updateProfileables", "updateDebuggables", "updateProcesses", "C", "getList", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "summarizeClient", "Lcom/android/tools/idea/transport/ClientSummary;", "level", "Lcom/android/tools/profiler/proto/Common$Process$ExposureLevel;", "addedClients", "", "removedClients", "addProcess", "timestampNs", "removeProcess", "clientPid", "(IJ)Ljava/lang/Boolean;", "Companion", "intellij.android.transport"})
@SourceDebugExtension(value={"SMAP\nTransportServiceProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportServiceProxy.kt\ncom/android/tools/idea/transport/TransportServiceProxy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,533:1\n1803#2,3:534\n827#2:556\n855#2,2:557\n1563#2:559\n1634#2,3:560\n1869#2,2:563\n1869#2,2:565\n1869#2,2:569\n1869#2,2:571\n1#3:537\n1#3:548\n1#3:553\n11546#4,9:538\n13472#4:547\n13473#4:549\n11555#4:550\n144#5:551\n216#5:552\n217#5:554\n145#5:555\n32#6,2:567\n*S KotlinDebug\n*F\n+ 1 TransportServiceProxy.kt\ncom/android/tools/idea/transport/TransportServiceProxy\n*L\n212#1:534,3\n334#1:556\n334#1:557,2\n335#1:559\n335#1:560,3\n349#1:563,2\n350#1:565,2\n166#1:569,2\n184#1:571,2\n330#1:548\n332#1:553\n330#1:538,9\n330#1:547\n330#1:549\n330#1:550\n332#1:551\n332#1:552\n332#1:554\n332#1:555\n144#1:567,2\n*E\n"})
public final class TransportServiceProxy
extends ServiceProxy
implements AndroidDebugBridge.IClientChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDevice ddmlibDevice;
    @NotNull
    private final Common.Device transportDevice;
    @NotNull
    private final BlockingDeque<Common.Event> proxyEventQueue;
    @NotNull
    private final Map<String, String> proxyFilePathCache;
    private final TransportServiceGrpc.TransportServiceBlockingStub serviceStub;
    @TestOnly
    @NotNull
    private final Map<Integer, Common.Process> cachedProcesses;
    private final boolean isDeviceApiSupported;
    @Nullable
    private Thread eventsListenerThread;
    @NotNull
    private final Map<Commands.Command.CommandType, TransportProxy.ProxyCommandHandler> commandHandlers;
    @NotNull
    private final List<TransportEventPreprocessor> eventPreprocessors;
    @NotNull
    private final List<TransportBytesPreprocessor> dataPreprocessors;
    private long latestEventTimestampNs;
    @Nullable
    private CountDownLatch eventStreamingLatch;
    @NotNull
    private static final String EMULATOR = "Emulator";
    @NotNull
    public static final String PRE_LOLLIPOP_FAILURE_REASON = "Pre-Lollipop devices are not supported.";

    public TransportServiceProxy(@NotNull IDevice ddmlibDevice, @NotNull Common.Device transportDevice, @NotNull ManagedChannel channel, @NotNull BlockingDeque<Common.Event> proxyEventQueue, @NotNull Map<String, String> proxyFilePathCache) {
        Intrinsics.checkNotNullParameter((Object)ddmlibDevice, (String)"ddmlibDevice");
        Intrinsics.checkNotNullParameter((Object)transportDevice, (String)"transportDevice");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter(proxyEventQueue, (String)"proxyEventQueue");
        Intrinsics.checkNotNullParameter(proxyFilePathCache, (String)"proxyFilePathCache");
        super(TransportServiceGrpc.getServiceDescriptor());
        this.ddmlibDevice = ddmlibDevice;
        this.transportDevice = transportDevice;
        this.proxyEventQueue = proxyEventQueue;
        this.proxyFilePathCache = proxyFilePathCache;
        this.serviceStub = TransportServiceGrpc.newBlockingStub((Channel)((Channel)channel));
        Map map2 = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"synchronizedMap(...)");
        this.cachedProcesses = map2;
        String string = this.transportDevice.getUnsupportedReason();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUnsupportedReason(...)");
        this.isDeviceApiSupported = ((CharSequence)string).length() == 0;
        this.commandHandlers = new LinkedHashMap();
        this.eventPreprocessors = new ArrayList();
        this.dataPreprocessors = new ArrayList();
        this.latestEventTimestampNs = Long.MIN_VALUE;
        TransportServiceProxy.Companion.getLog().info("ProfilerDevice created: " + this.transportDevice);
        this.updateProcesses();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
    }

    @NotNull
    public final Map<Integer, Common.Process> getCachedProcesses() {
        return this.cachedProcesses;
    }

    @Nullable
    public final TransportProxy.ProxyCommandHandler registerCommandHandler(@NotNull Commands.Command.CommandType commandType, @NotNull TransportProxy.ProxyCommandHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)commandType, (String)"commandType");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        return this.commandHandlers.put(commandType, handler2);
    }

    public final boolean registerEventPreprocessor(@NotNull TransportEventPreprocessor eventPreprocessor) {
        Intrinsics.checkNotNullParameter((Object)eventPreprocessor, (String)"eventPreprocessor");
        return this.eventPreprocessors.add(eventPreprocessor);
    }

    public final boolean registerDataPreprocessor(@NotNull TransportBytesPreprocessor dataPreprocessor) {
        Intrinsics.checkNotNullParameter((Object)dataPreprocessor, (String)"dataPreprocessor");
        return this.dataPreprocessors.add(dataPreprocessor);
    }

    @Override
    public void disconnect() {
        block2: {
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            CountDownLatch countDownLatch = this.eventStreamingLatch;
            if (countDownLatch == null) break block2;
            CountDownLatch it = countDownLatch;
            boolean bl = false;
            try {
                it.await();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private final void getVersion(Transport.VersionRequest request, StreamObserver<Transport.VersionResponse> responseObserver2) {
        TransportServiceProxyKt.access$onLast(responseObserver2, Transport.VersionResponse.newBuilder().setVersion(this.transportDevice.getVersion()).build());
    }

    @VisibleForTesting
    public final void getEvents(@NotNull Transport.GetEventsRequest request, @NotNull StreamObserver<Common.Event> responseObserver2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver2, (String)"responseObserver");
        TransportServiceProxyKt.access$startThread(() -> TransportServiceProxy.getEvents$lambda$3(this, request));
        this.eventStreamingLatch = new CountDownLatch(1);
        this.eventsListenerThread = TransportServiceProxyKt.access$startThread(() -> TransportServiceProxy.getEvents$lambda$7(this, responseObserver2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void getFile(@NotNull Transport.BytesRequest request, @NotNull StreamObserver<Transport.FileResponse> responseObserver2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver2, (String)"responseObserver");
        Map<String, String> map2 = this.proxyFilePathCache;
        synchronized (map2) {
            String string;
            void $this$fold$iv;
            void initial$iv;
            Object object;
            Ref.ObjectRef objectRef;
            ByteString byteString;
            Ref.ObjectRef content2;
            boolean bl = false;
            long startTimeNs = System.nanoTime();
            Ref.ObjectRef objectRef2 = content2 = new Ref.ObjectRef();
            Object cachedPath = this.proxyFilePathCache.remove(request.getId());
            if (cachedPath == null) {
                Iterator iterator2 = this.serviceStub.getBytesInChunks(request);
                Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"getBytesInChunks(...)");
                byteString = TransportServiceUtils.INSTANCE.aggregateByteChunks(iterator2);
            } else {
                objectRef = objectRef2;
                try {
                    objectRef2 = objectRef;
                    object = ByteString.readFrom((InputStream)new FileInputStream((String)cachedPath));
                }
                catch (IOException iOException) {
                    void e;
                    objectRef2 = objectRef;
                    TransportServiceProxy.Companion.getLog().warn("Failed to read from cached file: " + (String)cachedPath, (Throwable)e);
                    object = ByteString.EMPTY;
                }
                byteString = object;
            }
            objectRef2.element = byteString;
            cachedPath = this.dataPreprocessors;
            object = content2.element;
            objectRef = content2;
            boolean $i$f$fold = false;
            ByteString accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void preprocessor;
                TransportBytesPreprocessor transportBytesPreprocessor = (TransportBytesPreprocessor)element$iv;
                ByteString contents = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = preprocessor.shouldPreprocess(request) ? preprocessor.preprocessBytes(request.getId(), contents) : contents;
            }
            objectRef.element = accumulator$iv;
            if (((ByteString)content2.element).isEmpty()) {
                TransportServiceProxy.Companion.getLog().warn("Content for stream " + request.getStreamId() + ", id " + request.getId() + " is empty after fetch/preprocessing. Not saving to file.");
                string = "";
            } else {
                Object it = object = FileUtil.createTempFile((String)("transport-bytes-" + request.getStreamId() + "-" + request.getId()), (String)".tmp", (boolean)true).getAbsolutePath();
                boolean bl3 = false;
                ((ByteString)content2.element).writeTo((OutputStream)new FileOutputStream((String)it));
                long totalDurationMs = (System.nanoTime() - startTimeNs) / (long)1000000;
                long seconds = totalDurationMs / (long)1000;
                long remainingMs = totalDurationMs % (long)1000;
                TransportServiceProxy.Companion.getLog().info("Processed bytes (stream " + request.getStreamId() + ", id " + request.getId() + "),\nsize " + StringUtil.formatFileSize((long)((ByteString)content2.element).size()) + ", saved in file\n" + (String)it + ". Total time was " + seconds + "s and " + remainingMs + "ms.");
                string = object;
            }
            String path = string;
            TransportServiceProxyKt.access$onLast(responseObserver2, Transport.FileResponse.newBuilder().setFilePath(path).build());
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void getBytesInChunks(@NotNull Transport.BytesRequest request, @NotNull StreamObserver<Transport.BytesInChunksResponse> responseObserver2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver2, (String)"responseObserver");
        throw new Exception("`getBytesInChunks` is designed for the inter-machine transportation. Use `getFile` for same-machine usage.");
    }

    private final Common.Event generateEndEvent(Common.Event previousEvent) {
        return Common.Event.newBuilder().setKind(previousEvent.getKind()).setGroupId(previousEvent.getGroupId()).setPid(previousEvent.getPid()).setTimestamp(this.latestEventTimestampNs + 1L).setIsEnded(true).build();
    }

    private final void getCurrentTime(Transport.TimeRequest request, StreamObserver<Transport.TimeResponse> responseObserver2) {
        Transport.TimeResponse timeResponse;
        if (this.isDeviceApiSupported) {
            Transport.TimeResponse timeResponse2;
            try {
                timeResponse2 = this.serviceStub.getCurrentTime(request);
            }
            catch (StatusRuntimeException e) {
                responseObserver2.onError((Throwable)e);
                return;
            }
            timeResponse = timeResponse2;
        } else {
            timeResponse = Transport.TimeResponse.getDefaultInstance();
        }
        Transport.TimeResponse response2 = timeResponse;
        TransportServiceProxyKt.access$onLast(responseObserver2, response2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getProcesses(Transport.GetProcessesRequest request, StreamObserver<Transport.GetProcessesResponse> responseObserver2) {
        Collection<Common.Process> collection2;
        Map<Integer, Common.Process> map2 = this.cachedProcesses;
        Transport.GetProcessesResponse.Builder builder = Transport.GetProcessesResponse.newBuilder();
        StreamObserver<Transport.GetProcessesResponse> streamObserver = responseObserver2;
        Map<Integer, Common.Process> map3 = map2;
        synchronized (map3) {
            boolean bl = false;
            collection2 = this.cachedProcesses.values();
        }
        Collection<Common.Process> collection3 = collection2;
        TransportServiceProxyKt.access$onLast(streamObserver, builder.addAllProcess((Iterable)collection3).build());
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void execute(@NotNull Transport.ExecuteRequest request, @NotNull StreamObserver<Transport.ExecuteResponse> responseObserver2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver2, (String)"responseObserver");
        Commands.Command command = request.getCommand();
        boolean bl = false;
        try {
            TransportProxy.ProxyCommandHandler proxyCommandHandler;
            StreamObserver<Transport.ExecuteResponse> streamObserver;
            block5: {
                block4: {
                    void it;
                    streamObserver = responseObserver2;
                    proxyCommandHandler = this.commandHandlers.get(command.getType());
                    if (proxyCommandHandler == null) break block4;
                    TransportProxy.ProxyCommandHandler proxyCommandHandler2 = proxyCommandHandler;
                    StreamObserver<Transport.ExecuteResponse> streamObserver2 = streamObserver;
                    boolean bl2 = false;
                    Transport.ExecuteResponse executeResponse = it.shouldHandle(command) ? it.execute(command) : null;
                    streamObserver = streamObserver2;
                    proxyCommandHandler = executeResponse;
                    if (executeResponse != null) break block5;
                }
                proxyCommandHandler = this.serviceStub.execute(request);
            }
            TransportServiceProxyKt.access$onLast(streamObserver, proxyCommandHandler);
        }
        catch (StatusRuntimeException t) {
            TransportServiceProxy.Companion.getLog().warn((Throwable)t);
        }
    }

    public void deviceConnected(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
    }

    public void deviceDisconnected(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
    }

    public void deviceChanged(@NotNull IDevice device2, int changeMask) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        if (device2 == this.ddmlibDevice) {
            if (TransportServiceProxyKt.access$contains(changeMask, 2)) {
                this.updateDebuggables();
            }
            if (TransportServiceProxyKt.access$contains(changeMask, 8) && this.isProfileableSupported()) {
                this.updateProfileables();
            }
        }
    }

    private final boolean isProfileableSupported() {
        return this.ddmlibDevice.getVersion().getFeatureLevel() >= 31;
    }

    public void clientChanged(@NotNull Client client, int changeMask) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (TransportServiceProxyKt.access$contains(changeMask, 1) && client.getDevice() == this.ddmlibDevice && client.getClientData().getProcessName() != null) {
            ClientSummary clientSummary = ClientSummary.Companion.of(client);
            Intrinsics.checkNotNull((Object)clientSummary);
            this.updateProcesses(CollectionsKt.listOf((Object)clientSummary), CollectionsKt.emptyList(), Common.Process.ExposureLevel.DEBUGGABLE);
        }
    }

    @Override
    @NotNull
    public ServerServiceDefinition getServiceDefinition() {
        Pair[] pairArray = new Pair[7];
        MethodDescriptor methodDescriptor = TransportServiceGrpc.getGetVersionMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getGetVersionMethod(...)");
        pairArray[0] = TransportServiceProxy.getServiceDefinition$to(methodDescriptor, (Function2)new Function2<Transport.VersionRequest, StreamObserver<Transport.VersionResponse>, Unit>((Object)this){

            public final void invoke(Transport.VersionRequest p0, StreamObserver<Transport.VersionResponse> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                TransportServiceProxy.access$getVersion((TransportServiceProxy)this.receiver, p0, p1);
            }
        });
        MethodDescriptor methodDescriptor2 = TransportServiceGrpc.getGetProcessesMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor2, (String)"getGetProcessesMethod(...)");
        pairArray[1] = TransportServiceProxy.getServiceDefinition$to(methodDescriptor2, (Function2)new Function2<Transport.GetProcessesRequest, StreamObserver<Transport.GetProcessesResponse>, Unit>((Object)this){

            public final void invoke(Transport.GetProcessesRequest p0, StreamObserver<Transport.GetProcessesResponse> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                TransportServiceProxy.access$getProcesses((TransportServiceProxy)this.receiver, p0, p1);
            }
        });
        MethodDescriptor methodDescriptor3 = TransportServiceGrpc.getGetCurrentTimeMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor3, (String)"getGetCurrentTimeMethod(...)");
        pairArray[2] = TransportServiceProxy.getServiceDefinition$to(methodDescriptor3, (Function2)new Function2<Transport.TimeRequest, StreamObserver<Transport.TimeResponse>, Unit>((Object)this){

            public final void invoke(Transport.TimeRequest p0, StreamObserver<Transport.TimeResponse> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                TransportServiceProxy.access$getCurrentTime((TransportServiceProxy)this.receiver, p0, p1);
            }
        });
        MethodDescriptor methodDescriptor4 = TransportServiceGrpc.getGetEventsMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor4, (String)"getGetEventsMethod(...)");
        pairArray[3] = TransportServiceProxy.getServiceDefinition$to(methodDescriptor4, (Function2)new Function2<Transport.GetEventsRequest, StreamObserver<Common.Event>, Unit>((Object)this){

            public final void invoke(Transport.GetEventsRequest p0, StreamObserver<Common.Event> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                ((TransportServiceProxy)this.receiver).getEvents(p0, p1);
            }
        });
        MethodDescriptor methodDescriptor5 = TransportServiceGrpc.getGetFileMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor5, (String)"getGetFileMethod(...)");
        pairArray[4] = TransportServiceProxy.getServiceDefinition$to(methodDescriptor5, (Function2)new Function2<Transport.BytesRequest, StreamObserver<Transport.FileResponse>, Unit>((Object)this){

            public final void invoke(Transport.BytesRequest p0, StreamObserver<Transport.FileResponse> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                ((TransportServiceProxy)this.receiver).getFile(p0, p1);
            }
        });
        MethodDescriptor methodDescriptor6 = TransportServiceGrpc.getGetBytesInChunksMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor6, (String)"getGetBytesInChunksMethod(...)");
        pairArray[5] = TransportServiceProxy.getServiceDefinition$to(methodDescriptor6, (Function2)new Function2<Transport.BytesRequest, StreamObserver<Transport.BytesInChunksResponse>, Unit>((Object)this){

            public final void invoke(Transport.BytesRequest p0, StreamObserver<Transport.BytesInChunksResponse> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                ((TransportServiceProxy)this.receiver).getBytesInChunks(p0, p1);
            }
        });
        MethodDescriptor methodDescriptor7 = TransportServiceGrpc.getExecuteMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor7, (String)"getExecuteMethod(...)");
        pairArray[6] = TransportServiceProxy.getServiceDefinition$to(methodDescriptor7, (Function2)new Function2<Transport.ExecuteRequest, StreamObserver<Transport.ExecuteResponse>, Unit>((Object)this){

            public final void invoke(Transport.ExecuteRequest p0, StreamObserver<Transport.ExecuteResponse> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                ((TransportServiceProxy)this.receiver).execute(p0, p1);
            }
        });
        Map overrides2 = MapsKt.mapOf((Pair[])pairArray);
        ServerServiceDefinition serverServiceDefinition = this.generatePassThroughDefinitions(overrides2, (AbstractStub)this.serviceStub);
        Intrinsics.checkNotNullExpressionValue((Object)serverServiceDefinition, (String)"generatePassThroughDefinitions(...)");
        return serverServiceDefinition;
    }

    private final void updateProfileables() {
        this.updateProcesses((Function1<? super IDevice, C[]>)((Function1)updateProfileables.1.INSTANCE), (Function1)new Function1<ProfileableClient, ClientSummary>((Object)ClientSummary.Companion){

            public final ClientSummary invoke(ProfileableClient p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ClientSummary.Companion)this.receiver).of(p0);
            }
        }, Common.Process.ExposureLevel.PROFILEABLE);
    }

    private final void updateDebuggables() {
        this.updateProcesses((Function1<? super IDevice, C[]>)((Function1)updateDebuggables.1.INSTANCE), (Function1)new Function1<Client, ClientSummary>((Object)ClientSummary.Companion){

            public final ClientSummary invoke(Client p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ClientSummary.Companion)this.receiver).of(p0);
            }
        }, Common.Process.ExposureLevel.DEBUGGABLE);
    }

    private final void updateProcesses() {
        this.updateDebuggables();
        if (this.isProfileableSupported()) {
            this.updateProfileables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <C> void updateProcesses(Function1<? super IDevice, C[]> getList, Function1<? super C, ClientSummary> summarizeClient, Common.Process.ExposureLevel level) {
        if (this.isDeviceApiSupported) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterNotTo$iv$iv;
            Set $i$a$-synchronized-TransportServiceProxy$updateProcesses$previousProcessIds$22;
            Iterable $this$mapNotNullTo$iv;
            Map.Entry element$iv$iv;
            Map<Integer, Common.Process> $this$mapNotNullTo$iv$iv;
            Object[] $this$mapNotNull$iv = (Object[])getList.invoke((Object)this.ddmlibDevice);
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            Collection $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            for (Iterator element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                Object it$iv$iv;
                element$iv$iv = element$iv$iv$iv;
                boolean bl = false;
                if (summarizeClient.invoke((Object)element$iv$iv) == null) continue;
                boolean bl2 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List currentProcesses = (List)destination$iv$iv;
            $this$mapNotNullTo$iv$iv = this.cachedProcesses;
            synchronized ($this$mapNotNullTo$iv$iv) {
                void destination$iv;
                Iterator element$iv$iv$iv;
                boolean $i$a$-synchronized-TransportServiceProxy$updateProcesses$previousProcessIds$22 = false;
                Map<Integer, Common.Process> $i$f$mapNotNullTo2 = this.cachedProcesses;
                $this$forEach$iv$iv$iv = new LinkedHashSet();
                boolean $i$f$mapNotNullTo3 = false;
                Iterator $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach2 = false;
                element$iv$iv$iv = $this$forEach$iv$iv.entrySet().iterator();
                while (element$iv$iv$iv.hasNext()) {
                    Integer it$iv;
                    Map.Entry element$iv = element$iv$iv = element$iv$iv$iv.next();
                    boolean bl = false;
                    Map.Entry entry = element$iv;
                    boolean bl3 = false;
                    int id2 = ((Number)entry.getKey()).intValue();
                    Common.Process p = (Common.Process)entry.getValue();
                    Integer n = id2;
                    int it = ((Number)n).intValue();
                    boolean bl4 = false;
                    if ((p.getExposureLevel().compareTo((Enum)level) >= 0 ? n : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl5 = false;
                    destination$iv.add(it$iv);
                }
                $i$a$-synchronized-TransportServiceProxy$updateProcesses$previousProcessIds$22 = (Set)destination$iv;
            }
            Set previousProcessIds = $i$a$-synchronized-TransportServiceProxy$updateProcesses$previousProcessIds$22;
            Iterable $this$filterNot$iv = currentProcesses;
            boolean $i$f$filterNot22 = false;
            $this$mapNotNullTo$iv = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
                ClientSummary it = (ClientSummary)element$iv$iv2;
                boolean bl = false;
                if (previousProcessIds.contains(it.getPid())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List addedProcesses = (List)destination$iv$iv2;
            Iterable $i$f$filterNot22 = currentProcesses;
            Set set2 = previousProcessIds;
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                ClientSummary bl = (ClientSummary)item$iv$iv;
                Collection collection2 = destination$iv$iv3;
                boolean bl6 = false;
                collection2.add(p0.getPid());
            }
            Set removedProcessIds = SetsKt.minus((Set)set2, (Iterable)((List)destination$iv$iv3));
            this.updateProcesses(addedProcesses, removedProcessIds, level);
        }
    }

    private final void updateProcesses(Collection<ClientSummary> addedClients, Collection<Integer> removedClients, Common.Process.ExposureLevel level) {
        if (this.isDeviceApiSupported && this.ddmlibDevice.isOnline()) {
            try {
                long timestampNs = this.serviceStub.getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(this.transportDevice.getDeviceId()).build()).getTimestampNs();
                Iterable $this$forEach$iv = addedClients;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ClientSummary it = (ClientSummary)element$iv;
                    boolean bl = false;
                    this.addProcess(it, timestampNs, level);
                }
                $this$forEach$iv = removedClients;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    this.removeProcess(it, timestampNs);
                }
            }
            catch (Exception e) {
                TransportServiceProxy.Companion.getLog().info((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addProcess(ClientSummary client, long timestampNs, Common.Process.ExposureLevel level) {
        String string;
        String description2 = client.getName();
        boolean bl = false;
        String abi = client.getAbi();
        boolean bl2 = false;
        if (abi != null && StringsKt.contains$default((CharSequence)abi, (CharSequence)")", (boolean)false, (int)2, null)) {
            String string2 = abi.substring(StringsKt.indexOf$default((CharSequence)abi, (char)'(', (int)0, (boolean)false, (int)6, null) + 1, StringsKt.indexOf$default((CharSequence)abi, (char)')', (int)0, (boolean)false, (int)6, null));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            Abi abi2 = Abi.getEnum((String)((String)this.ddmlibDevice.getAbis().get(0)));
            Intrinsics.checkNotNull((Object)abi2);
            string = abi2.getCpuArch();
        }
        String processAbiCpuArch = string;
        Common.Process newProcess = Common.Process.newBuilder().setName(description2).setPid(client.getPid()).setDeviceId(this.transportDevice.getDeviceId()).setState(Common.Process.State.ALIVE).setStartTimestampNs(timestampNs).setAbiCpuArch(processAbiCpuArch).setExposureLevel(level).setPackageName(client.getPackageName()).build();
        Map<Integer, Common.Process> map2 = this.cachedProcesses;
        synchronized (map2) {
            boolean bl3 = false;
            this.cachedProcesses.put(client.getPid(), newProcess);
            Unit unit = Unit.INSTANCE;
        }
        return this.proxyEventQueue.offer(Common.Event.newBuilder().setGroupId((long)newProcess.getPid()).setPid(newProcess.getPid()).setKind(Common.Event.Kind.PROCESS).setProcess(Common.ProcessData.newBuilder().setProcessStarted(Common.ProcessData.ProcessStarted.newBuilder().setProcess(newProcess))).setTimestamp(timestampNs).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Boolean removeProcess(int clientPid, long timestampNs) {
        Boolean bl;
        Map<Integer, Common.Process> map2 = this.cachedProcesses;
        synchronized (map2) {
            Boolean bl2;
            boolean bl3 = false;
            Common.Process process2 = this.cachedProcesses.remove(clientPid);
            if (process2 != null) {
                Common.Process process3 = process2;
                boolean bl4 = false;
                bl2 = this.proxyEventQueue.offer(Common.Event.newBuilder().setGroupId((long)process3.getPid()).setPid(process3.getPid()).setKind(Common.Event.Kind.PROCESS).setIsEnded(true).setTimestamp(timestampNs).build());
            } else {
                bl2 = null;
            }
            bl = bl2;
        }
        return bl;
    }

    private static final void getEvents$lambda$3(TransportServiceProxy this$0, Transport.GetEventsRequest $request) {
        block3: {
            try {
                Iterator iterator2 = this$0.serviceStub.getEvents($request);
                Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"getEvents(...)");
                Iterator $this$forEach$iv = iterator2;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv;
                while (iterator3.hasNext()) {
                    Common.Event event;
                    Object element$iv = iterator3.next();
                    Common.Event it = (Common.Event)element$iv;
                    boolean bl = false;
                    if (it == null) continue;
                    BlockingDeque<Common.Event> blockingDeque = this$0.proxyEventQueue;
                    Common.Event p0 = event;
                    boolean bl2 = false;
                    blockingDeque.offer(p0);
                }
            }
            catch (StatusRuntimeException statusRuntimeException) {
                // empty catch block
            }
            Thread thread = this$0.eventsListenerThread;
            if (thread == null) break block3;
            Thread it = thread;
            boolean bl = false;
            it.interrupt();
            this$0.eventsListenerThread = null;
        }
    }

    private static final void getEvents$lambda$7(TransportServiceProxy this$0, StreamObserver $responseObserver) {
        Map ongoingEventGroups = new LinkedHashMap();
        while (!Thread.currentThread().isInterrupted() || !this$0.proxyEventQueue.isEmpty()) {
            try {
                Common.Event event = this$0.proxyEventQueue.take();
                this$0.latestEventTimestampNs = Math.max(this$0.latestEventTimestampNs, event.getTimestamp());
                for (TransportEventPreprocessor preprocessor : this$0.eventPreprocessors) {
                    Iterable<Common.Event> $this$forEach$iv;
                    if (!preprocessor.shouldPreprocess(event)) continue;
                    Intrinsics.checkNotNullExpressionValue(preprocessor.preprocessEvent(event), (String)"preprocessEvent(...)");
                    boolean $i$f$forEach = false;
                    Iterator<Common.Event> iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        Common.Event element$iv;
                        Common.Event p0 = element$iv = iterator2.next();
                        boolean bl = false;
                        $responseObserver.onNext((Object)p0);
                    }
                }
                if (event.getIsEnded()) {
                    Intrinsics.checkNotNull((Object)event);
                    TransportServiceProxyKt.access$remove(ongoingEventGroups, event);
                } else if (event.getGroupId() != 0L) {
                    Intrinsics.checkNotNull((Object)event);
                    TransportServiceProxyKt.access$add(ongoingEventGroups, event);
                }
                $responseObserver.onNext((Object)event);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
        }
        Iterable $this$forEach$iv = ongoingEventGroups.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Long2ObjectMap it = (Long2ObjectMap)element$iv;
            boolean bl = false;
            Collection collection2 = it.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"<get-values>(...)");
            Iterable $this$forEach$iv2 = collection2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Common.Event lastEvent = (Common.Event)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)lastEvent);
                $responseObserver.onNext((Object)this$0.generateEndEvent(lastEvent));
            }
        }
        $responseObserver.onCompleted();
        CountDownLatch countDownLatch = this$0.eventStreamingLatch;
        Intrinsics.checkNotNull((Object)countDownLatch);
        countDownLatch.countDown();
    }

    private static final void getServiceDefinition$to$lambda$14(Function2 $tmp0, Object p0, StreamObserver p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final <Req, Res> Pair<MethodDescriptor<Req, Res>, ServerCallHandler<Req, Res>> getServiceDefinition$to(MethodDescriptor<Req, Res> $this$getServiceDefinition_u24to, Function2<? super Req, ? super StreamObserver<Res>, Unit> f) {
        return TuplesKt.to($this$getServiceDefinition_u24to, (Object)ServerCalls.asyncUnaryCall((arg_0, arg_1) -> TransportServiceProxy.getServiceDefinition$to$lambda$14(f, arg_0, arg_1)));
    }

    @JvmStatic
    @NotNull
    public static final Common.Device transportDeviceFromIDevice(@NotNull IDevice device2) {
        return Companion.transportDeviceFromIDevice(device2);
    }

    @JvmStatic
    @NotNull
    public static final String getDeviceModel(@NotNull IDevice device2) {
        return Companion.getDeviceModel(device2);
    }

    @JvmStatic
    @NotNull
    public static final String getDeviceManufacturer(@NotNull IDevice device2) {
        return Companion.getDeviceManufacturer(device2);
    }

    public static final /* synthetic */ void access$getVersion(TransportServiceProxy $this, Transport.VersionRequest request, StreamObserver responseObserver2) {
        $this.getVersion(request, (StreamObserver<Transport.VersionResponse>)responseObserver2);
    }

    public static final /* synthetic */ void access$getProcesses(TransportServiceProxy $this, Transport.GetProcessesRequest request, StreamObserver responseObserver2) {
        $this.getProcesses(request, (StreamObserver<Transport.GetProcessesResponse>)responseObserver2);
    }

    public static final /* synthetic */ void access$getCurrentTime(TransportServiceProxy $this, Transport.TimeRequest request, StreamObserver responseObserver2) {
        $this.getCurrentTime(request, (StreamObserver<Transport.TimeResponse>)responseObserver2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\f\u0010\u0013\u001a\u00020\n*\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0015\u0010\u0019\u001a\u00070\n\u00a2\u0006\u0002\b\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0015\u0010\u001a\u001a\u00070\n\u00a2\u0006\u0002\b\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/transport/TransportServiceProxy$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "EMULATOR", "", "PRE_LOLLIPOP_FAILURE_REASON", "transportDeviceFromIDevice", "Lcom/android/tools/profiler/proto/Common$Device;", "device", "Lcom/android/ddmlib/IDevice;", "getId", "", "bootId", "getBootId", "convertState", "Lcom/android/tools/profiler/proto/Common$Device$State;", "state", "Lcom/android/ddmlib/IDevice$DeviceState;", "getDeviceUnsupportedReason", "getDeviceModel", "getDeviceManufacturer", "intellij.android.transport"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Logger logger = Logger.getInstance(TransportServiceProxy.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return logger;
        }

        @JvmStatic
        @NotNull
        public final Common.Device transportDeviceFromIDevice(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            String bootId = this.getBootId(device2);
            Common.Device.Builder builder = Common.Device.newBuilder().setDeviceId(this.getId(device2, bootId)).setBootId(bootId).setSerial(device2.getSerialNumber()).setModel(this.getDeviceModel(device2)).setVersion(StringUtil.notNullize((String)device2.getProperty("ro.build.version.release"))).setCodename(StringUtil.notNullize((String)device2.getVersion().getCodename())).setApiLevel(device2.getVersion().getAndroidApiLevel().getMajorVersion()).setApiLevelMinor(device2.getVersion().getAndroidApiLevel().getMinorVersion()).setFeatureLevel(device2.getVersion().getFeatureLevel()).setManufacturer(this.getDeviceManufacturer(device2)).setIsEmulator(device2.isEmulator()).setBuildTags(device2.getProperty("ro.build.tags")).setBuildType(device2.getProperty("ro.build.type")).setCpuAbi(device2.getProperty("ro.product.cpu.abi"));
            IDevice.DeviceState deviceState2 = device2.getState();
            Intrinsics.checkNotNullExpressionValue((Object)deviceState2, (String)"getState(...)");
            Common.Device device3 = builder.setState(this.convertState(deviceState2)).setUnsupportedReason(this.getDeviceUnsupportedReason(device2)).build();
            Intrinsics.checkNotNullExpressionValue((Object)device3, (String)"build(...)");
            return device3;
        }

        private final long getId(IDevice $this$getId, String bootId) {
            long l;
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                String string = bootId;
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                digest.update(byArray);
                String string2 = $this$getId.getSerialNumber();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSerialNumber(...)");
                string = string2;
                byte[] byArray2 = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                digest.update(byArray2);
                l = ByteBuffer.wrap(digest.digest()).getLong();
            }
            catch (NoSuchAlgorithmException e) {
                this.getLog().info("SHA-256 is not available", (Throwable)e);
                l = new Random(System.currentTimeMillis()).nextLong();
            }
            return l;
        }

        private final String getBootId(IDevice $this$getBootId) {
            String string;
            Ref.ObjectRef bootId = new Ref.ObjectRef();
            try {
                $this$getBootId.executeShellCommand("cat /proc/sys/kernel/random/boot_id", (IShellOutputReceiver)new MultiLineReceiver((Ref.ObjectRef<String>)bootId){
                    final /* synthetic */ Ref.ObjectRef<String> $bootId;
                    {
                        this.$bootId = $bootId;
                    }

                    public void processNewLines(String[] lines) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
                        boolean bl2 = bl = lines.length == 1;
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        if (((CharSequence)lines[0]).length() > 0) {
                            this.$bootId.element = lines[0];
                        }
                    }

                    public boolean isCancelled() {
                        return false;
                    }
                });
            }
            catch (Exception e) {
                Exception exception = e;
                if (exception instanceof TimeoutException || exception instanceof AdbCommandRejectedException || exception instanceof IOException || exception instanceof ShellCommandUnresponsiveException) {
                    this.getLog().warn("Unable to retrieve boot_id from device " + $this$getBootId, (Throwable)e);
                }
                throw e;
            }
            if ((string = (String)bootId.element) == null) {
                string = String.valueOf($this$getBootId.getSerialNumber().hashCode());
            }
            return string;
        }

        private final Common.Device.State convertState(IDevice.DeviceState state2) {
            return switch (WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                case 1 -> Common.Device.State.OFFLINE;
                case 2 -> Common.Device.State.ONLINE;
                case 3 -> Common.Device.State.DISCONNECTED;
                default -> Common.Device.State.UNSPECIFIED;
            };
        }

        private final String getDeviceUnsupportedReason(IDevice device2) {
            return device2.getVersion().getFeatureLevel() < 21 ? TransportServiceProxy.PRE_LOLLIPOP_FAILURE_REASON : "";
        }

        @JvmStatic
        @NotNull
        public final String getDeviceModel(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            String string = device2.isEmulator() ? StringUtil.notNullize((String)device2.getAvdName(), (String)device2.getSerialNumber()) : DevicePropertyUtil.getModel(device2, "Unknown");
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        @JvmStatic
        @NotNull
        public final String getDeviceManufacturer(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            String string = DevicePropertyUtil.getManufacturer(device2, device2.isEmulator() ? TransportServiceProxy.EMULATOR : "");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getManufacturer(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[IDevice.DeviceState.values().length];
                try {
                    nArray[IDevice.DeviceState.OFFLINE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IDevice.DeviceState.ONLINE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IDevice.DeviceState.DISCONNECTED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

