/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.android.tools.idea.ui.GuiTestingStatusProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Key;

public class GuiTestingService {
    public static final Key<Runnable> EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY = Key.create((String)"gui.test.execute.before.build");
    public static final Key<String> GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY = Key.create((String)"gui.test.gradle.build.output");
    private final Object LOCK = new Object();
    private boolean myGuiTestingMode;

    public static GuiTestingService getInstance() {
        return (GuiTestingService)ApplicationManager.getApplication().getService(GuiTestingService.class);
    }

    private GuiTestingService() {
        ExtensionPointName epName = ExtensionPointName.create((String)"com.android.tools.idea.ui.guiTestingStatusProvider");
        for (GuiTestingStatusProvider provider : (GuiTestingStatusProvider[])epName.getExtensions()) {
            if (!provider.enableUiTestMode()) continue;
            this.setGuiTestingMode(true);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGuiTestingMode() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myGuiTestingMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGuiTestingMode(boolean guiTestingMode) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myGuiTestingMode = guiTestingMode;
        }
    }

    public static boolean isInTestingMode() {
        GuiTestingService guiTestingService = GuiTestingService.getInstance();
        return guiTestingService != null && guiTestingService.isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode();
    }
}

