/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.model;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.tools.idea.ui.resourcemanager.model.DesignAssetMetadata;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a1\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u00042\u0014\b\u0002\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006\"\u00020\u0002\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"getMetadata", "", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAssetMetadata;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "dataKeys", "", "(Lcom/intellij/openapi/vfs/VirtualFile;[Lcom/android/tools/idea/ui/resourcemanager/model/DesignAssetMetadata;)Ljava/util/Map;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nMetadataHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataHelper.kt\ncom/android/tools/idea/ui/resourcemanager/model/MetadataHelperKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,126:1\n24#2:127\n*S KotlinDebug\n*F\n+ 1 MetadataHelper.kt\ncom/android/tools/idea/ui/resourcemanager/model/MetadataHelperKt\n*L\n121#1:127\n*E\n"})
public final class MetadataHelperKt {
    @NotNull
    public static final Map<DesignAssetMetadata, String> getMetadata(@NotNull VirtualFile $this$getMetadata, DesignAssetMetadata ... dataKeys) {
        Density density;
        FolderConfiguration folderConfiguration;
        String parentFileName;
        Map map2;
        Set keys;
        block12: {
            String string;
            DesignAssetMetadata designAssetMetadata;
            Map map3;
            block14: {
                block15: {
                    String extension;
                    block13: {
                        Intrinsics.checkNotNullParameter((Object)$this$getMetadata, (String)"<this>");
                        Intrinsics.checkNotNullParameter((Object)dataKeys, (String)"dataKeys");
                        keys = ArraysKt.toMutableSet((Object[])dataKeys);
                        map2 = new LinkedHashMap();
                        if (keys.remove((Object)DesignAssetMetadata.FILE_NAME)) {
                            map2.put(DesignAssetMetadata.FILE_NAME, $this$getMetadata.getName());
                        }
                        if (!keys.remove((Object)DesignAssetMetadata.FILE_TYPE)) break block12;
                        extension = $this$getMetadata.getExtension();
                        map3 = map2;
                        designAssetMetadata = DesignAssetMetadata.FILE_TYPE;
                        if (!StringsKt.equals((String)extension, (String)"xml", (boolean)true)) break block13;
                        string = "Vector drawable";
                        break block14;
                    }
                    string = extension;
                    if (string == null) break block15;
                    String string2 = string;
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    String string3 = string2.toUpperCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                    string = string3;
                    if (string3 != null) break block14;
                }
                string = "Unknown";
            }
            String string4 = string;
            map3.put(designAssetMetadata, string4);
        }
        Object object = (parentFileName = FileExtensions.toPathString($this$getMetadata).getParentFileName()) != null ? ((folderConfiguration = FolderConfiguration.getConfigForFolder((String)parentFileName)) != null && (folderConfiguration = folderConfiguration.getDensityQualifier()) != null ? folderConfiguration.getValue() : null) : (density = Density.MEDIUM);
        if (keys.remove((Object)DesignAssetMetadata.DENSITY) && density != null) {
            map2.put(DesignAssetMetadata.DENSITY, density.getLongDisplayValue());
        }
        if (keys.remove((Object)DesignAssetMetadata.FILE_SIZE)) {
            map2.put(DesignAssetMetadata.FILE_SIZE, StringUtil.formatFileSize((long)$this$getMetadata.getLength()));
        }
        Iterator<ImageReader> iterator2 = ImageIO.getImageReadersBySuffix($this$getMetadata.getExtension());
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"getImageReadersBySuffix(...)");
        ImageReader reader2 = (ImageReader)SequencesKt.firstOrNull((Sequence)SequencesKt.asSequence(iterator2));
        if (reader2 != null) {
            try {
                reader2.setInput(ImageIO.createImageInputStream($this$getMetadata.getInputStream()));
                int width = reader2.getWidth(0);
                int height = reader2.getHeight(0);
                if (keys.remove((Object)DesignAssetMetadata.DIMENSIONS_PX)) {
                    map2.put(DesignAssetMetadata.DIMENSIONS_PX, width + "x" + height);
                }
                if (keys.remove((Object)DesignAssetMetadata.DIMENSIONS_DP) && density != null && density.isValidValueForDevice()) {
                    double dpiValue = density.getDpiValue();
                    long dpWidth = Math.round((double)width / (dpiValue / (double)Density.DEFAULT_DENSITY));
                    long dpHeight = Math.round((double)height / (dpiValue / (double)Density.DEFAULT_DENSITY));
                    map2.put(DesignAssetMetadata.DIMENSIONS_DP, dpWidth + "x" + dpHeight);
                }
            }
            catch (Throwable t) {
                VirtualFile $this$thisLogger$iv = $this$getMetadata;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(VirtualFile.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn(t);
            }
        }
        return map2;
    }

    public static /* synthetic */ Map getMetadata$default(VirtualFile virtualFile, DesignAssetMetadata[] designAssetMetadataArray, int n, Object object) {
        if ((n & 1) != 0) {
            designAssetMetadataArray = DesignAssetMetadata.values();
        }
        return MetadataHelperKt.getMetadata(virtualFile, designAssetMetadataArray);
    }
}

