/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.builders;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchCurvePoint;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPoint2D;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchShapePath;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;

public class Path2DBuilder {
    @NotNull
    private Path2D.Double path = new Path2D.Double();

    public void startPath(@NotNull SketchPoint2D startPoint) {
        this.path.moveTo(startPoint.getX(), startPoint.getY());
    }

    public void createLine(@NotNull SketchPoint2D currentPoint) {
        this.path.lineTo(currentPoint.getX(), currentPoint.getY());
    }

    public void createBezierCurve(@NotNull SketchPoint2D curveFrom, @NotNull SketchPoint2D curveTo, @NotNull SketchPoint2D destination) {
        this.path.curveTo(curveFrom.getX(), curveFrom.getY(), curveTo.getX(), curveTo.getY(), destination.getX(), destination.getY());
    }

    public void createQuadCurve(@NotNull SketchPoint2D controlPoint, @NotNull SketchPoint2D endPoint) {
        this.path.quadTo(controlPoint.getX(), controlPoint.getY(), endPoint.getX(), endPoint.getY());
    }

    public void createClosedShape(@NotNull SketchShapePath shapePath, @NotNull SketchCurvePoint currentCurvePoint) {
        SketchPoint2D currentPointCurveFrom = currentCurvePoint.hasCurveFrom() ? currentCurvePoint.getCurveFrom().makeAbsolutePosition(shapePath.getFrame()) : currentCurvePoint.getPoint().makeAbsolutePosition(shapePath.getFrame());
        SketchCurvePoint firstCurvePoint = shapePath.getPoints()[0];
        SketchPoint2D firstPoint = firstCurvePoint.getPoint().makeAbsolutePosition(shapePath.getFrame());
        SketchPoint2D firstPointCurveTo = firstCurvePoint.hasCurveTo() ? firstCurvePoint.getCurveTo().makeAbsolutePosition(shapePath.getFrame()) : firstPoint;
        if (currentCurvePoint.equals(currentPointCurveFrom) && firstPoint.equals(firstPointCurveTo)) {
            this.closePath();
        } else {
            this.createBezierCurve(currentPointCurveFrom, firstPointCurveTo, firstPoint);
        }
    }

    public void closePath() {
        this.path.closePath();
    }

    @NotNull
    public Path2D.Double build() {
        return this.path;
    }
}

