/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.builders;

import java.text.DecimalFormat;
import org.jetbrains.annotations.NotNull;

public class PathStringBuilder {
    private static final char MOVE_CURSOR_COMMAND_ABSOLUTE = 'M';
    private static final char LINE_COMMAND_ABSOLUTE = 'L';
    private static final char BEZIER_CURVE_COMMAND_ABSOLUTE = 'C';
    private static final char QUADRATIC_CURVE_COMMAND_ABSOLUTE = 'Q';
    private static final char CLOSE_PATH_COMMAND = 'z';
    private static final String COORDINATES_PRECISION = "#.##";
    @NotNull
    private StringBuilder stringBuilder = new StringBuilder();

    @NotNull
    public String build() {
        return this.stringBuilder.toString();
    }

    public void createBezierCurve(@NotNull double[] coordinates) {
        this.appendCommand('C');
        this.appendPointCoordinates(coordinates[0], coordinates[1]);
        this.appendPointCoordinates(coordinates[2], coordinates[3]);
        this.appendPointCoordinates(coordinates[4], coordinates[5]);
    }

    public void createQuadCurve(double controlPointX, double controlPointY, double endPointX, double endPointY) {
        this.appendCommand('Q');
        this.appendPointCoordinates(controlPointX, controlPointY);
        this.appendPointCoordinates(endPointX, endPointY);
    }

    public void createLine(double x, double y) {
        this.appendCommand('L');
        this.appendPointCoordinates(x, y);
    }

    public void startPath(double x, double y) {
        this.appendCommand('M');
        this.appendPointCoordinates(x, y);
    }

    public void endPath() {
        this.appendCommand('z');
    }

    private void appendCommand(char command) {
        this.stringBuilder.append(command);
    }

    private void appendPointCoordinates(double x, double y) {
        this.stringBuilder.append(PathStringBuilder.trimDoubles(x)).append(",").append(PathStringBuilder.trimDoubles(y)).append(" ");
    }

    @NotNull
    private static String trimDoubles(double number) {
        DecimalFormat df = new DecimalFormat(COORDINATES_PRECISION);
        return df.format(number);
    }
}

