/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.InheritedProperties;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ResizingConstraint;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ShapeModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.StyleModel;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AreaModel
extends ShapeModel {
    @NotNull
    private final Area myArea;

    public AreaModel(@NotNull Area shape, @Nullable StyleModel style, boolean flippedHorizontal, boolean flippedVertical, boolean closed, int rotation, int operation, @NotNull Point2D.Double framePosition, boolean hasClippingMask, boolean shouldBreakMaskChain, boolean isLastShapeGroup, @NotNull ResizingConstraint constraint) {
        super(shape, style, flippedHorizontal, flippedVertical, closed, rotation, operation, framePosition, hasClippingMask, shouldBreakMaskChain, isLastShapeGroup, constraint);
        this.myArea = shape;
    }

    @NotNull
    public Area getModelArea() {
        return this.myArea;
    }

    private void addShape(@NotNull AreaModel model) {
        this.myArea.add(model.getModelArea());
    }

    private void subtractShape(@NotNull AreaModel model) {
        this.myArea.subtract(model.getModelArea());
    }

    private void differenceShape(@NotNull AreaModel model) {
        this.myArea.exclusiveOr(model.getModelArea());
    }

    private void intersectShape(@NotNull AreaModel model) {
        this.myArea.intersect(model.getModelArea());
    }

    public void applyOperation(@NotNull AreaModel model) {
        int booleanOperation = model.getBooleanOperation();
        switch (booleanOperation) {
            case 0: {
                this.addShape(model);
                break;
            }
            case 1: {
                this.subtractShape(model);
                break;
            }
            case -1: 
            case 3: {
                this.differenceShape(model);
                break;
            }
            case 2: {
                this.intersectShape(model);
            }
        }
    }

    @Override
    public void applyTransformations(@Nullable InheritedProperties properties) {
        AffineTransform transform2 = this.computeAffineTransform(properties);
        this.myArea.transform(transform2);
        this.transformGradient(transform2);
        if (properties != null) {
            this.applyOpacity(properties.getInheritedOpacity());
        }
    }

    @Override
    public void scale(double scaleX, double scaleY) {
        AffineTransform scaleTransform = new AffineTransform();
        scaleTransform.scale(scaleX, scaleY);
        this.myArea.transform(scaleTransform);
        this.transformGradient(scaleTransform);
    }

    @Override
    public void translateTo(double translateX, double translateY) {
        AffineTransform translateTransform = new AffineTransform();
        translateTransform.translate(-this.myShapeFrameLocation.getX(), -this.myShapeFrameLocation.getY());
        translateTransform.translate(translateX, translateY);
        this.myArea.transform(translateTransform);
        this.transformGradient(translateTransform);
    }
}

