/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ResizingConstraint;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;

public class InheritedProperties {
    public static final int DEFAULT_OPACITY = 1;
    public static final int DEFAULT_ROTATION = 0;
    public static final boolean DEFAULT_FLIP_X = false;
    public static final boolean DEFAULT_FLIP_Y = false;
    @NotNull
    private Point2D.Double myInheritedTranslation;
    private int myInheritedRotations;
    private boolean myInheritedFlipX;
    private boolean myInheritedFlipY;
    private double myInheritedOpacity;
    @NotNull
    private ResizingConstraint mInheritedResizingConstraint;

    public InheritedProperties() {
        this.myInheritedTranslation = new Point2D.Double();
        this.myInheritedRotations = 0;
        this.myInheritedFlipX = false;
        this.myInheritedFlipY = false;
        this.myInheritedOpacity = 1.0;
        this.mInheritedResizingConstraint = new ResizingConstraint();
    }

    public InheritedProperties(@NotNull InheritedProperties inheritedProperties, @NotNull Point2D.Double translation, boolean flipX, boolean flipY, int rotation, double opacity, @NotNull ResizingConstraint constraint) {
        this.myInheritedTranslation = new Point2D.Double(inheritedProperties.getInheritedTranslation().getX() + translation.getX(), inheritedProperties.getInheritedTranslation().getY() + translation.getY());
        this.myInheritedRotations = inheritedProperties.getInheritedRotation() + rotation;
        this.myInheritedFlipX = inheritedProperties.isInheritedFlipX() ^ flipX;
        this.myInheritedFlipY = inheritedProperties.isInheritedFlipY() ^ flipY;
        this.myInheritedOpacity = inheritedProperties.getInheritedOpacity() * opacity;
        this.mInheritedResizingConstraint = inheritedProperties.getInheritedResizingConstraint().updateConstraint(constraint);
    }

    @NotNull
    public Point2D.Double getInheritedTranslation() {
        return this.myInheritedTranslation;
    }

    public int getInheritedRotation() {
        return this.myInheritedRotations;
    }

    public boolean isInheritedFlipX() {
        return this.myInheritedFlipX;
    }

    public boolean isInheritedFlipY() {
        return this.myInheritedFlipY;
    }

    public double getInheritedOpacity() {
        return this.myInheritedOpacity;
    }

    @NotNull
    public ResizingConstraint getInheritedResizingConstraint() {
        return this.mInheritedResizingConstraint;
    }
}

