/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.save;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/ui/save/SaveConfigurationResolver;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "userHome", "", "Lorg/jetbrains/annotations/NonNls;", "expandFilenamePattern", "saveLocation", "filenameTemplate", "fileExtension", "timestamp", "Ljava/time/Instant;", "sequentialNumber", "", "generalizeSaveLocation", "expandSaveLocation", "Companion", "intellij.android.adb.ui"})
public final class SaveConfigurationResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String userHome;
    @NotNull
    public static final String USER_HOME_MACRO = "$USER_HOME$";
    @NotNull
    public static final String DEFAULT_SAVE_LOCATION = "$USER_HOME$/Desktop";
    @NotNull
    public static final String PROJECT_DIR_MACRO = "$PROJECT_DIR$";

    public SaveConfigurationResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        String string = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        this.userHome = string;
    }

    @NotNull
    public final String expandFilenamePattern(@NotNull String saveLocation, @NotNull String filenameTemplate, @NotNull String fileExtension, @NotNull Instant timestamp, int sequentialNumber) {
        Intrinsics.checkNotNullParameter((Object)saveLocation, (String)"saveLocation");
        Intrinsics.checkNotNullParameter((Object)filenameTemplate, (String)"filenameTemplate");
        Intrinsics.checkNotNullParameter((Object)fileExtension, (String)"fileExtension");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        try {
            Path dir = Paths.get(this.userHome, new String[0]).resolve(this.expandSaveLocation(saveLocation));
            ZonedDateTime time2 = timestamp.atZone(ZoneId.systemDefault());
            String string = StringsKt.replace$default((String)StringsKt.replace$default((String)filenameTemplate, (String)"<yyyy>", (String)String.valueOf(time2.get(ChronoField.YEAR)), (boolean)false, (int)4, null), (String)"<yy>", (String)StringsKt.takeLast((String)String.valueOf(time2.get(ChronoField.YEAR)), (int)2), (boolean)false, (int)4, null);
            Locale locale = Locale.ROOT;
            String string2 = "%02d";
            Object[] objectArray = new Object[]{time2.get(ChronoField.MONTH_OF_YEAR)};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            String string4 = StringsKt.replace$default((String)string, (String)"<MM>", (String)string3, (boolean)false, (int)4, null);
            locale = Locale.ROOT;
            string2 = "%02d";
            objectArray = new Object[]{time2.get(ChronoField.DAY_OF_MONTH)};
            String string5 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            String string6 = StringsKt.replace$default((String)string4, (String)"<dd>", (String)string5, (boolean)false, (int)4, null);
            locale = Locale.ROOT;
            string2 = "%02d";
            objectArray = new Object[]{time2.get(ChronoField.HOUR_OF_DAY)};
            String string7 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
            String string8 = StringsKt.replace$default((String)string6, (String)"<HH>", (String)string7, (boolean)false, (int)4, null);
            locale = Locale.ROOT;
            string2 = "%02d";
            objectArray = new Object[]{time2.get(ChronoField.MINUTE_OF_HOUR)};
            String string9 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(...)");
            String string10 = StringsKt.replace$default((String)string8, (String)"<mm>", (String)string9, (boolean)false, (int)4, null);
            locale = Locale.ROOT;
            string2 = "%02d";
            objectArray = new Object[]{time2.get(ChronoField.SECOND_OF_MINUTE)};
            String string11 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"format(...)");
            String string12 = StringsKt.replace$default((String)string10, (String)"<ss>", (String)string11, (boolean)false, (int)4, null);
            locale = Locale.ROOT;
            string2 = "%03d";
            objectArray = new Object[]{time2.get(ChronoField.MILLI_OF_SECOND)};
            String string13 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"format(...)");
            CharSequence charSequence = StringsKt.replace$default((String)string12, (String)"<zzz>", (String)string13, (boolean)false, (int)4, null);
            locale = new Regex("<#+>");
            string2 = arg_0 -> SaveConfigurationResolver.expandFilenamePattern$lambda$0(sequentialNumber, arg_0);
            String string14 = locale.replace(charSequence, (Function1)string2);
            String string15 = this.project.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"getName(...)");
            String filename = StringsKt.replace$default((String)string14, (String)"<project>", (String)string15, (boolean)false, (int)4, null);
            return StringsKt.replace$default((String)((Object)dir.resolve(filename + "." + fileExtension).normalize()).toString(), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
        }
        catch (InvalidPathException invalidPathException) {
            return "";
        }
    }

    @NotNull
    public final String generalizeSaveLocation(@NotNull String saveLocation) {
        String string;
        Intrinsics.checkNotNullParameter((Object)saveLocation, (String)"saveLocation");
        Path dir = Paths.get(this.userHome, new String[0]).resolve(saveLocation).normalize();
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        Path projectDir = virtualFile != null ? virtualFile.toNioPath() : null;
        if (projectDir != null && dir.startsWith(projectDir)) {
            String string2 = ((Object)dir).toString();
            int n = 0;
            int n2 = ((Object)projectDir).toString().length();
            CharSequence charSequence = PROJECT_DIR_MACRO;
            string = ((Object)StringsKt.replaceRange((CharSequence)string2, (int)n, (int)n2, (CharSequence)charSequence)).toString();
        } else if (dir.startsWith(Paths.get(this.userHome, new String[0]))) {
            String string3 = ((Object)dir).toString();
            int n = 0;
            int n3 = this.userHome.length();
            CharSequence charSequence = USER_HOME_MACRO;
            string = ((Object)StringsKt.replaceRange((CharSequence)string3, (int)n, (int)n3, (CharSequence)charSequence)).toString();
        } else {
            string = saveLocation;
        }
        return StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public final String expandSaveLocation(@NotNull String saveLocation) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)saveLocation, (String)"saveLocation");
        String dir = StringsKt.replace$default((String)saveLocation, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        if (SaveConfigurationResolver.Companion.startsWithFollowedBySeparator(saveLocation, PROJECT_DIR_MACRO)) {
            object = ProjectUtil.guessProjectDir((Project)this.project);
            if (object == null || (object = object.toNioPath()) == null || (object = object.resolve(StringsKt.substringAfter((String)dir, (char)'/', (String)""))) == null || (object = object.toString()) == null) {
                object = this.userHome + "/Desktop";
            }
        } else {
            object = SaveConfigurationResolver.Companion.startsWithFollowedBySeparator(saveLocation, USER_HOME_MACRO) ? this.userHome + "/" + StringsKt.substringAfter((String)dir, (char)'/', (String)"") : saveLocation;
        }
        return StringsKt.replace$default((String)object, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
    }

    private static final CharSequence expandFilenamePattern$lambda$0(int $sequentialNumber, MatchResult match) {
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        Locale locale = Locale.ROOT;
        String string = "%0" + (CollectionsKt.count((Iterable)((Iterable)match.getRange())) - 2) + "d";
        Object[] objectArray = new Object[]{$sequentialNumber};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @JvmStatic
    private static final boolean startsWithFollowedBySeparator(String $this$startsWithFollowedBySeparator, String prefix) {
        return SaveConfigurationResolver.Companion.startsWithFollowedBySeparator($this$startsWithFollowedBySeparator, prefix);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\u00020\n*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/ui/save/SaveConfigurationResolver$Companion;", "", "<init>", "()V", "USER_HOME_MACRO", "", "Lorg/jetbrains/annotations/NonNls;", "DEFAULT_SAVE_LOCATION", "PROJECT_DIR_MACRO", "startsWithFollowedBySeparator", "", "prefix", "intellij.android.adb.ui"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final boolean startsWithFollowedBySeparator(String $this$startsWithFollowedBySeparator, String prefix) {
            return StringsKt.startsWith$default((String)$this$startsWithFollowedBySeparator, (String)prefix, (boolean)false, (int)2, null) && ($this$startsWithFollowedBySeparator.length() == prefix.length() || $this$startsWithFollowedBySeparator.charAt(prefix.length()) == '/');
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

