/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.Revision;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import org.jetbrains.annotations.NotNull;

class PackageNodeModel {
    private final UpdatablePackage myPkg;
    private SelectedState myState;
    private final String myTitle;

    public PackageNodeModel(@NotNull UpdatablePackage pkg, boolean stripPrefix) {
        RepoPackage representative = pkg.getRepresentative();
        Object name2 = representative.getDisplayName();
        if (stripPrefix) {
            String shortRevision;
            String suffix = representative.getPath().substring(representative.getPath().lastIndexOf(59) + 1);
            try {
                shortRevision = Revision.parseRevision((String)suffix).toShortString();
            }
            catch (NumberFormatException ignore) {
                shortRevision = null;
            }
            if (representative.getDisplayName().endsWith(suffix) || shortRevision != null && representative.getDisplayName().endsWith(shortRevision)) {
                name2 = suffix;
            }
        }
        this.myPkg = pkg;
        if (this.obsolete()) {
            name2 = (String)name2 + " (Obsolete)";
        }
        this.myTitle = name2;
    }

    @NotNull
    public UpdatablePackage getPkg() {
        return this.myPkg;
    }

    public SelectedState getState() {
        return this.myState;
    }

    public void setState(@NotNull SelectedState state2) {
        this.myState = state2;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public boolean obsolete() {
        return this.myPkg.getRepresentative().obsolete() || this.myPkg.getPath().equals("ndk-bundle");
    }

    static enum SelectedState {
        NOT_INSTALLED,
        MIXED,
        INSTALLED;

    }
}

