/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.DynamicAppFeatureOnFeatureToken;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.ApkFileUnit;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicAppUtils {
    @Nullable
    public static Module getBaseFeature(@NotNull Module module) {
        return ProjectSystemUtil.getModuleSystem(module).getBaseFeatureModule();
    }

    @NotNull
    public static List<Module> getFeatureModulesDependingOnFeature(@NotNull Module featureModule) {
        Project project = featureModule.getProject();
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem(project);
        DynamicAppFeatureOnFeatureToken token = DynamicAppFeatureOnFeatureToken.EP_NAME.getExtensionList().stream().filter(it -> it.isApplicable(projectSystem)).findFirst().orElse(null);
        if (token == null) {
            return ImmutableList.of();
        }
        return token.getFeatureModulesDependingOnFeature(projectSystem, featureModule);
    }

    @NotNull
    public static List<Module> getFeatureModuleDependenciesForFeature(@NotNull Module featureModule) {
        Project project = featureModule.getProject();
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem(project);
        DynamicAppFeatureOnFeatureToken token = DynamicAppFeatureOnFeatureToken.EP_NAME.getExtensionList().stream().filter(it -> it.isApplicable(projectSystem)).findFirst().orElse(null);
        if (token == null) {
            return ImmutableList.of();
        }
        return token.getFeatureModuleDependenciesForFeature(projectSystem, featureModule);
    }

    public static boolean useSelectApksFromBundleBuilder(@NotNull Module module, boolean alwaysDeployApkFromBundle, boolean deployForTests, @Nullable AndroidVersion minTargetDeviceVersion) {
        AndroidModuleSystem moduleSystem;
        AndroidModuleSystem.Type type;
        if (alwaysDeployApkFromBundle) {
            return true;
        }
        if (minTargetDeviceVersion != null && minTargetDeviceVersion.getFeatureLevel() < 21 && !ProjectSystemUtil.getModuleSystem(module).getDynamicFeatureModules().isEmpty()) {
            return true;
        }
        return deployForTests && (type = (moduleSystem = ProjectSystemUtil.getModuleSystem(module)).getType()) == AndroidModuleSystem.Type.TYPE_DYNAMIC_FEATURE;
    }

    @NotNull
    public static List<Module> getDependentInstantFeatureModules(@NotNull Module module) {
        return ProjectSystemUtil.getModuleSystem(module).getDynamicFeatureModules().stream().filter(it -> {
            AndroidModel model = AndroidModel.get(it);
            return model != null && model.isInstantAppCompatible();
        }).collect(Collectors.toList());
    }

    public static boolean isFeatureEnabled(@NotNull List<String> myDisabledFeatures, @NotNull ApkFileUnit apkFileUnit) {
        return myDisabledFeatures.stream().noneMatch(m -> DynamicAppUtils.featureNameEquals(apkFileUnit, m));
    }

    public static boolean featureNameEquals(@NotNull ApkFileUnit apkFileUnit, @NotNull String featureName) {
        return StringUtil.equals((CharSequence)featureName.replace('-', '_'), (CharSequence)apkFileUnit.getModuleName());
    }
}

