/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.android.tools.idea.util.StudioPathManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class EmbeddedDistributionPaths {
    @NotNull
    public static EmbeddedDistributionPaths getInstance() {
        return (EmbeddedDistributionPaths)ApplicationManager.getApplication().getService(EmbeddedDistributionPaths.class);
    }

    @NotNull
    public File findEmbeddedProfilerTransform() {
        if (StudioPathManager.isRunningFromSources()) {
            return StudioPathManager.resolvePathFromSourcesRoot((String)"bazel-bin/tools/base/profiler/transform/profilers-transform.jar").toFile();
        }
        return new File(PathManager.getHomePath(), "plugins/android/resources/profilers-transform.jar");
    }

    @Nullable
    public Path tryToGetEmbeddedJdkPath() {
        try {
            return this.getEmbeddedJdkPath();
        }
        catch (Throwable t) {
            Logger.getInstance(EmbeddedDistributionPaths.class).warn("Failed to find a valid embedded JDK", t);
            return null;
        }
    }

    @NotNull
    public Path getEmbeddedJdkPath() {
        if (StudioPathManager.isRunningFromSources()) {
            if (System.getProperty("android.test.embedded.jdk") != null) {
                Path jdkDir = Paths.get(System.getProperty("android.test.embedded.jdk"), new String[0]);
                return jdkDir;
            }
            String embeddedJdkPath = System.getProperty("embedded.jdk.path", "prebuilts/studio/jdk/jbr-next").trim();
            Path jdkDir = EmbeddedDistributionPaths.getJdkRootPathFromSourcesRoot(embeddedJdkPath);
            try {
                Path wellKnownJdkFile = jdkDir.resolve("release");
                jdkDir = wellKnownJdkFile.toRealPath(new LinkOption[0]).getParent();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return jdkDir;
        }
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        Path jdkRootPath = Paths.get(ideHomePath, "jbr");
        return EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
    }

    @NotNull
    public static Path getJdkRootPathFromSourcesRoot(String embeddedJdkPath) {
        Path jdkRootPath = StudioPathManager.resolvePathFromSourcesRoot((String)embeddedJdkPath);
        if (SystemInfo.isWindows) {
            jdkRootPath = embeddedJdkPath.endsWith("jdk8") ? jdkRootPath.resolve("win64") : jdkRootPath.resolve("win");
        } else if (SystemInfo.isLinux) {
            jdkRootPath = jdkRootPath.resolve("linux");
        } else if (SystemInfo.isMac && CpuArch.isArm64()) {
            jdkRootPath = jdkRootPath.resolve("mac-arm64");
        } else if (SystemInfo.isMac) {
            jdkRootPath = jdkRootPath.resolve("mac");
        }
        Path jdkDir = EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
        return jdkDir;
    }

    @NotNull
    private static Path getSystemSpecificJdkPath(Path jdkRootPath) {
        if (SystemInfo.isMac) {
            jdkRootPath = jdkRootPath.resolve("Contents/Home");
        }
        return jdkRootPath;
    }

    @NotNull
    private static String getIdeHomePath() {
        return FileUtil.toSystemDependentName((String)PathManager.getHomePath());
    }
}

