/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u001e\u0010\u0007\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"formatElementListString", "", "values", "", "oneElementMessage", "twoOrThreeElementsMessage", "moreThenThreeElementsMessage", "atMostTwo", "names", "size", "", "intellij.android.core"})
@JvmName(name="FormatUtil")
public final class FormatUtil {
    @NotNull
    public static final String formatElementListString(@NotNull Iterable<String> values, @NotNull String oneElementMessage, @NotNull String twoOrThreeElementsMessage, @NotNull String moreThenThreeElementsMessage) {
        String string;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)oneElementMessage, (String)"oneElementMessage");
        Intrinsics.checkNotNullParameter((Object)twoOrThreeElementsMessage, (String)"twoOrThreeElementsMessage");
        Intrinsics.checkNotNullParameter((Object)moreThenThreeElementsMessage, (String)"moreThenThreeElementsMessage");
        int size = Iterables.size(values);
        if (size == 0) {
            string = "<validation error>";
        } else if (size == 1) {
            String string2 = oneElementMessage;
            Object[] objectArray = new Object[]{CollectionsKt.first(values)};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else if (size <= 3) {
            String string4 = twoOrThreeElementsMessage;
            Object[] objectArray = new Object[]{FormatUtil.atMostTwo(values, size), CollectionsKt.last(values)};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        } else {
            String string6 = moreThenThreeElementsMessage;
            Object[] objectArray = new Object[]{FormatUtil.atMostTwo(values, size), size - 2};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
        }
        return string;
    }

    private static final String atMostTwo(Iterable<String> names, int size) {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.take(names, (int)RangesKt.coerceAtMost((int)(size - 1), (int)2)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }
}

