/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wear.dwf.inspections;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.wear.dwf.WearDwfBundle;
import com.android.tools.idea.wear.dwf.dom.raw.CurrentWFFVersion;
import com.android.tools.idea.wear.dwf.dom.raw.CurrentWFFVersionService;
import com.android.tools.idea.wear.dwf.dom.raw.RawWatchFaceUtilsKt;
import com.android.tools.idea.wear.dwf.dom.raw.expressions.DataSource;
import com.android.tools.idea.wear.dwf.dom.raw.expressions.Function;
import com.android.tools.idea.wear.dwf.dom.raw.expressions.FunctionKt;
import com.android.tools.idea.wear.dwf.dom.raw.expressions.WFFExpressionDataSource;
import com.android.tools.idea.wear.dwf.dom.raw.expressions.WFFExpressionFunctionId;
import com.android.tools.idea.wear.dwf.dom.raw.expressions.WFFExpressionPsiFile;
import com.android.tools.idea.wear.dwf.dom.raw.expressions.WFFExpressionVisitor;
import com.android.tools.wear.wff.WFFVersion;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/wear/dwf/inspections/FeatureRequiresHigherWFFVersionInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "getStaticDescription", "", "Lorg/jetbrains/annotations/Nls;", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "intellij.android.wear-dwf"})
public final class FeatureRequiresHigherWFFVersionInspection
extends LocalInspectionTool {
    @NotNull
    public String getStaticDescription() {
        return WearDwfBundle.INSTANCE.message("inspection.feature.requires.higher.wff.version.description", new Object[0]);
    }

    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!((Boolean)StudioFlags.WEAR_DECLARATIVE_WATCH_FACE_XML_EDITOR_SUPPORT.get()).booleanValue()) {
            return false;
        }
        return file instanceof WFFExpressionPsiFile;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        AndroidModuleSystem androidModuleSystem = ProjectSystemUtil.getModuleSystem((PsiElement)psiFile);
        if (androidModuleSystem == null || (androidModuleSystem = androidModuleSystem.getModule()) == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        AndroidModuleSystem module = androidModuleSystem;
        CurrentWFFVersion currentWFFVersion = CurrentWFFVersionService.Companion.getInstance().getCurrentWFFVersion((Module)module);
        if (currentWFFVersion == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        CurrentWFFVersion currentWFFVersion2 = currentWFFVersion;
        return new WFFExpressionVisitor(currentWFFVersion2, holder){
            final /* synthetic */ CurrentWFFVersion $currentWFFVersion;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$currentWFFVersion = $currentWFFVersion;
                this.$holder = $holder;
            }

            public void visitFunctionId(WFFExpressionFunctionId functionId) {
                Intrinsics.checkNotNullParameter((Object)functionId, (String)"functionId");
                String string = functionId.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                Object object = FunctionKt.findFunction(string);
                if (object == null || (object = ((Function)object).getRequiredVersion()) == null) {
                    return;
                }
                Object requiredWFFVersion = object;
                Object[] objectArray = new Object[]{((WFFVersion)((Object)requiredWFFVersion)).getVersion()};
                this.reportHigherVersionRequiredIfNeeded(functionId, (WFFVersion)((Object)requiredWFFVersion), WearDwfBundle.INSTANCE.message("wff.feature.requires.higher.wff.version.function", objectArray));
            }

            public void visitDataSource(WFFExpressionDataSource dataSource) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                boolean isReference = RawWatchFaceUtilsKt.isReference(dataSource);
                if (isReference) {
                    object = WFFVersion.WFFVersion4;
                } else {
                    object = RawWatchFaceUtilsKt.findDataSourceDefinition(dataSource);
                    if (object == null || (object = ((DataSource)object).getRequiredVersion()) == null) {
                        return;
                    }
                }
                WFFVersion requiredVersion = object;
                String errorMessageKey = isReference ? "wff.feature.requires.higher.wff.version.reference" : "wff.feature.requires.higher.wff.version.datasource";
                PsiElement psiElement = dataSource.getId();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getId(...)");
                Object[] objectArray = new Object[]{requiredVersion.getVersion()};
                this.reportHigherVersionRequiredIfNeeded(psiElement, requiredVersion, WearDwfBundle.INSTANCE.message(errorMessageKey, objectArray));
            }

            private final void reportHigherVersionRequiredIfNeeded(PsiElement element, WFFVersion requiredWFFVersion, String errorMessage) {
                if (this.$currentWFFVersion.getWffVersion().compareTo((Enum)requiredWFFVersion) < 0) {
                    this.$holder.registerProblem(element, errorMessage, ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                }
            }
        };
    }
}

