/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wear.dwf.inspections;

import com.android.tools.idea.wear.dwf.WearDwfBundle;
import com.android.tools.idea.wear.dwf.dom.raw.RawWatchFaceUtilsKt;
import com.android.tools.idea.wear.dwf.dom.raw.configurations.ColorConfiguration;
import com.android.tools.idea.wear.dwf.dom.raw.configurations.UserConfigurationReference;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u0004H\u0002\u001a6\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\"\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"getColorConfigurationsById", "", "", "Lcom/android/tools/idea/wear/dwf/dom/raw/configurations/ColorConfiguration;", "Lcom/intellij/psi/xml/XmlFile;", "visitReference", "", "reference", "Lcom/android/tools/idea/wear/dwf/dom/raw/configurations/UserConfigurationReference;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "colorIndexTextRange", "Lcom/intellij/openapi/util/TextRange;", "colorConfigurationsById", "length", "", "Lkotlin/ranges/IntRange;", "getLength", "(Lkotlin/ranges/IntRange;)I", "intellij.android.wear-dwf"})
@SourceDebugExtension(value={"SMAP\nInvalidColorIndexInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvalidColorIndexInspection.kt\ncom/android/tools/idea/wear/dwf/inspections/InvalidColorIndexInspectionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n808#2,11:163\n1208#2,2:174\n1236#2,4:176\n*S KotlinDebug\n*F\n+ 1 InvalidColorIndexInspection.kt\ncom/android/tools/idea/wear/dwf/inspections/InvalidColorIndexInspectionKt\n*L\n107#1:163,11\n107#1:174,2\n107#1:176,4\n*E\n"})
public final class InvalidColorIndexInspectionKt {
    /*
     * WARNING - void declaration
     */
    private static final Map<String, ColorConfiguration> getColorConfigurationsById(XmlFile $this$getColorConfigurationsById) {
        void $this$associateByTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = RawWatchFaceUtilsKt.extractUserConfigurations($this$getColorConfigurationsById);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ColorConfiguration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ColorConfiguration colorConfiguration = (ColorConfiguration)element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            map2.put(it.getId(), element$iv$iv);
        }
        return destination$iv$iv2;
    }

    private static final void visitReference(UserConfigurationReference reference, ProblemsHolder holder, TextRange colorIndexTextRange, Map<String, ColorConfiguration> colorConfigurationsById) {
        if (reference.resolve() == null) {
            return;
        }
        ColorConfiguration colorConfiguration = colorConfigurationsById.get(reference.getUserConfigurationId());
        if (colorConfiguration == null) {
            return;
        }
        ColorConfiguration colorConfiguration2 = colorConfiguration;
        if (colorConfiguration2.getColorIndices().isEmpty()) {
            holder.registerProblem(reference.getElement(), WearDwfBundle.INSTANCE.message("inspection.invalid.color.index.missing.colors", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            return;
        }
        String colorIndexRange = "[0, " + colorConfiguration2.getColorIndices().getLast() + "]";
        if (reference.getColorIndex() == null || ((CharSequence)reference.getColorIndex()).length() == 0) {
            if (InvalidColorIndexInspectionKt.getLength(colorConfiguration2.getColorIndices()) > 1) {
                Object[] objectArray = new Object[]{colorIndexRange};
                holder.registerProblem(reference.getElement(), WearDwfBundle.INSTANCE.message("inspection.invalid.color.index.missing.index", objectArray), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
            return;
        }
        Object[] objectArray = colorConfiguration2.getColorIndices();
        Integer n = StringsKt.toIntOrNull((String)reference.getColorIndex());
        if (!(n != null && objectArray.contains(n.intValue()))) {
            if (InvalidColorIndexInspectionKt.getLength(colorConfiguration2.getColorIndices()) <= 1) {
                objectArray = new Object[]{colorIndexRange};
                holder.registerProblem(reference.getElement(), WearDwfBundle.INSTANCE.message("inspection.invalid.color.index.invalid.index.optional", objectArray), ProblemHighlightType.ERROR, colorIndexTextRange, new LocalQuickFix[0]);
            } else {
                objectArray = new Object[]{colorIndexRange};
                holder.registerProblem(reference.getElement(), WearDwfBundle.INSTANCE.message("inspection.invalid.color.index.invalid.index.in.range", objectArray), ProblemHighlightType.ERROR, colorIndexTextRange, new LocalQuickFix[0]);
            }
        }
    }

    public static final int getLength(@NotNull IntRange $this$length) {
        Intrinsics.checkNotNullParameter((Object)$this$length, (String)"<this>");
        return $this$length.getEndInclusive() - $this$length.getStart() + 1;
    }

    public static final /* synthetic */ Map access$getColorConfigurationsById(XmlFile $receiver) {
        return InvalidColorIndexInspectionKt.getColorConfigurationsById($receiver);
    }

    public static final /* synthetic */ void access$visitReference(UserConfigurationReference reference, ProblemsHolder holder, TextRange colorIndexTextRange, Map colorConfigurationsById) {
        InvalidColorIndexInspectionKt.visitReference(reference, holder, colorIndexTextRange, colorConfigurationsById);
    }
}

