/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.config;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.google.common.base.MoreObjects;
import com.intellij.openapi.application.ApplicationInfo;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0005J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\u0006\u0010\u0013\u001a\u00020\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/welcome/config/InstallerData;", "", "androidDest", "Ljava/io/File;", "createAvd", "", "timestamp", "", "version", "<init>", "(Ljava/io/File;ZLjava/lang/String;Ljava/lang/String;)V", "getAndroidDest", "()Ljava/io/File;", "getTimestamp", "()Ljava/lang/String;", "isCurrentVersion", "()Z", "shouldCreateAvd", "toString", "hasValidSdkLocation", "intellij.android.core"})
public final class InstallerData {
    @Nullable
    private final File androidDest;
    private final boolean createAvd;
    @Nullable
    private final String timestamp;
    @Nullable
    private final String version;

    public InstallerData(@Nullable File androidDest, boolean createAvd2, @Nullable String timestamp, @Nullable String version2) {
        this.androidDest = androidDest;
        this.createAvd = createAvd2;
        this.timestamp = timestamp;
        this.version = version2;
    }

    @Nullable
    public final File getAndroidDest() {
        return this.androidDest;
    }

    @Nullable
    public final String getTimestamp() {
        return this.timestamp;
    }

    public final boolean isCurrentVersion() {
        int[] nArray = ApplicationInfo.getInstance().getBuild().getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getComponents(...)");
        Integer n = ArraysKt.lastOrNull((int[])nArray);
        return Intrinsics.areEqual((Object)String.valueOf(n != null ? n : 0), (Object)this.version);
    }

    public final boolean shouldCreateAvd() {
        return this.createAvd;
    }

    @NotNull
    public String toString() {
        String string = MoreObjects.toStringHelper((Object)this).add("androidsdk.dir", (Object)this.androidDest).add("create.avd", this.createAvd).add("install.timestamp", (Object)this.timestamp).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean hasValidSdkLocation() {
        if (this.androidDest == null) {
            return false;
        }
        PathValidator pathValidator = PathValidator.Companion.forAndroidSdkLocation();
        Path path = this.androidDest.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Validator.Severity severity = pathValidator.validate(path).getSeverity();
        return severity != Validator.Severity.ERROR;
    }
}

