/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.welcome.wizard.WelcomeUiUtils;
import com.android.tools.idea.welcome.wizard.deprecated.ProgressStepForm;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004:\u0002&'B\u0017\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H$J\b\u0010\u0014\u001a\u00020\rH\u0017J\b\u0010\u0015\u001a\u00020\u0016H\u0017J\u0006\u0010\u0017\u001a\u00020\u0016J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0006\u0010\u001f\u001a\u00020\u0012J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0017J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/welcome/wizard/AbstractProgressStep;", "T", "Lcom/android/tools/idea/wizard/model/WizardModel;", "Lcom/android/tools/idea/wizard/model/ModelWizardStep;", "Lcom/android/tools/idea/welcome/wizard/ProgressStep;", "model", "name", "", "<init>", "(Lcom/android/tools/idea/wizard/model/WizardModel;Ljava/lang/String;)V", "form", "Lcom/android/tools/idea/welcome/wizard/deprecated/ProgressStepForm;", "myProgressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusComponent", "onEntering", "", "execute", "getProgressIndicator", "isCanceled", "", "isRunning", "print", "s", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "attachToProcess", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "showConsole", "run", "runnable", "Ljava/lang/Runnable;", "progressPortion", "", "dispose", "ProgressPortionReporter", "ProgressIndicatorIntegration", "intellij.android.core"})
public abstract class AbstractProgressStep<T extends WizardModel>
extends ModelWizardStep<T>
implements ProgressStep {
    @NotNull
    private final ProgressStepForm form;
    @Nullable
    private ProgressIndicator myProgressIndicator;

    public AbstractProgressStep(@NotNull T model, @NotNull String name2) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(model, name2);
        this.form = new ProgressStepForm();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.form.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getRoot(...)");
        return jComponent;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.form.getShowDetailsButton();
    }

    @Override
    public void onEntering() {
        WelcomeUiUtils.invokeLater$default(null, () -> AbstractProgressStep.onEntering$lambda$0(this), 1, null);
    }

    protected abstract void execute();

    @Override
    @AnyThread
    @NotNull
    public synchronized ProgressIndicator getProgressIndicator() {
        if (this.myProgressIndicator == null) {
            this.myProgressIndicator = (ProgressIndicator)new ProgressIndicatorIntegration(this.form);
        }
        ProgressIndicator progressIndicator = this.myProgressIndicator;
        Intrinsics.checkNotNull((Object)progressIndicator);
        return progressIndicator;
    }

    @Override
    @AnyThread
    public boolean isCanceled() {
        return this.getProgressIndicator().isCanceled();
    }

    public final boolean isRunning() {
        return this.getProgressIndicator().isRunning();
    }

    @Override
    @AnyThread
    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.form.print(s, contentType);
    }

    @Override
    @AnyThread
    public void attachToProcess(@NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        this.form.attachToProcess(processHandler);
    }

    public final void showConsole() {
        this.form.showConsole();
    }

    @Override
    @AnyThread
    public void run(@NotNull Runnable runnable2, double progressPortion) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        ProgressPortionReporter progress2 = new ProgressPortionReporter(this.getProgressIndicator(), this.form.getFraction(), progressPortion);
        ProgressManager.getInstance().executeProcessUnderProgress(runnable2, (ProgressIndicator)progress2);
    }

    @Override
    public void dispose() {
        this.form.dispose();
        super.dispose();
    }

    private static final Unit onEntering$lambda$0(AbstractProgressStep this$0) {
        this$0.execute();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/welcome/wizard/AbstractProgressStep$ProgressIndicatorIntegration;", "Lcom/intellij/openapi/progress/util/ProgressIndicatorBase;", "form", "Lcom/android/tools/idea/welcome/wizard/deprecated/ProgressStepForm;", "<init>", "(Lcom/android/tools/idea/welcome/wizard/deprecated/ProgressStepForm;)V", "start", "", "setText", "text", "", "setText2", "stop", "setIndeterminate", "indeterminate", "", "setFraction", "fraction", "", "intellij.android.core"})
    public static final class ProgressIndicatorIntegration
    extends ProgressIndicatorBase {
        @NotNull
        private final ProgressStepForm form;

        public ProgressIndicatorIntegration(@NotNull ProgressStepForm form) {
            Intrinsics.checkNotNullParameter((Object)form, (String)"form");
            this.form = form;
        }

        public void start() {
            super.start();
            this.setIndeterminate(false);
        }

        public void setText(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            super.setText(text2);
            ModalityState modalityState = ModalityState.stateForComponent((Component)this.form.getLabel());
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
            WelcomeUiUtils.invokeLater(modalityState, (Function0<Unit>)((Function0)() -> ProgressIndicatorIntegration.setText$lambda$0(this, text2)));
        }

        public void setText2(@Nullable String text2) {
            super.setText2(text2);
            ModalityState modalityState = ModalityState.stateForComponent((Component)this.form.getLabel());
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
            WelcomeUiUtils.invokeLater(modalityState, (Function0<Unit>)((Function0)() -> ProgressIndicatorIntegration.setText2$lambda$1(this, text2)));
        }

        public void stop() {
            ModalityState modalityState = ModalityState.stateForComponent((Component)this.form.getProgressBar());
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
            WelcomeUiUtils.invokeLater(modalityState, (Function0<Unit>)((Function0)() -> ProgressIndicatorIntegration.stop$lambda$2(this)));
            super.stop();
        }

        public void setIndeterminate(boolean indeterminate) {
            super.setIndeterminate(indeterminate);
            ModalityState modalityState = ModalityState.stateForComponent((Component)this.form.getProgressBar());
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
            WelcomeUiUtils.invokeLater(modalityState, (Function0<Unit>)((Function0)() -> ProgressIndicatorIntegration.setIndeterminate$lambda$3(this, indeterminate)));
        }

        public void setFraction(double fraction) {
            super.setFraction(fraction);
            ModalityState modalityState = ModalityState.stateForComponent((Component)this.form.getRoot());
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
            WelcomeUiUtils.invokeLater(modalityState, (Function0<Unit>)((Function0)() -> ProgressIndicatorIntegration.setFraction$lambda$4(this, fraction)));
        }

        private static final Unit setText$lambda$0(ProgressIndicatorIntegration this$0, String $text) {
            this$0.form.getLabel().setText($text);
            return Unit.INSTANCE;
        }

        private static final Unit setText2$lambda$1(ProgressIndicatorIntegration this$0, String $text) {
            String string;
            JLabel jLabel = this$0.form.getLabel2();
            String string2 = $text;
            if (string2 == null) {
                string = "";
            } else {
                String string3 = StringUtil.shortenTextWithEllipsis((String)string2, (int)80, (int)10);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"shortenTextWithEllipsis(...)");
            }
            jLabel.setText(string);
            return Unit.INSTANCE;
        }

        private static final Unit stop$lambda$2(ProgressIndicatorIntegration this$0) {
            this$0.form.getLabel().setText(null);
            this$0.form.getLabel2().setText(null);
            this$0.form.getProgressBar().setVisible(false);
            this$0.form.showConsole();
            return Unit.INSTANCE;
        }

        private static final Unit setIndeterminate$lambda$3(ProgressIndicatorIntegration this$0, boolean $indeterminate) {
            this$0.form.getProgressBar().setIndeterminate($indeterminate);
            return Unit.INSTANCE;
        }

        private static final Unit setFraction$lambda$4(ProgressIndicatorIntegration this$0, double $fraction) {
            this$0.form.setFraction($fraction);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0004\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/welcome/wizard/AbstractProgressStep$ProgressPortionReporter;", "Lcom/intellij/ide/util/DelegatingProgressIndicator;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "start", "", "portion", "<init>", "(Lcom/intellij/openapi/progress/ProgressIndicator;DD)V", "", "stop", "setFraction", "fraction", "intellij.android.core"})
    public static final class ProgressPortionReporter
    extends DelegatingProgressIndicator {
        private final double start;
        private final double portion;

        public ProgressPortionReporter(@NotNull ProgressIndicator indicator, double start2, double portion) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            super(indicator);
            this.start = start2;
            this.portion = portion;
        }

        public void start() {
            this.setFraction(0.0);
        }

        public void stop() {
            this.setFraction(this.portion);
        }

        public void setFraction(double fraction) {
            super.setFraction(this.start + fraction * this.portion);
        }
    }
}

