/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.tools.idea.welcome.config.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.config.GlobalInstallerData;
import com.android.tools.idea.welcome.config.InstallerData;
import com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProviderKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.net.HttpConnectionUtils;
import com.intellij.util.net.JdkProxyProvider;
import com.intellij.util.net.ProxySettings;
import com.intellij.util.net.ProxyUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u0005J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\u0005H\u0002J\b\u0010\u0017\u001a\u00020\u0005H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/welcome/wizard/AndroidStudioWelcomeScreenService;", "", "<init>", "()V", "wizardWasShown", "", "getWizardWasShown", "()Z", "setWizardWasShown", "(Z)V", "isAvailable", "getWizardMode", "Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;", "persistentData", "Lcom/android/tools/idea/welcome/config/AndroidFirstRunPersistentData;", "installerData", "Lcom/android/tools/idea/welcome/config/InstallerData;", "ideSdks", "Lcom/android/tools/idea/sdk/IdeSdks;", "isHandoff", "checkInternetConnection", "", "promptToRetryFailedConnection", "promptUserForProxy", "Companion", "intellij.android.core"})
public final class AndroidStudioWelcomeScreenService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean wizardWasShown;
    @NotNull
    public static final String SYSTEM_PROPERTY_DISABLE_WIZARD = "disable.android.first.run";

    public final boolean getWizardWasShown() {
        return this.wizardWasShown;
    }

    public final void setWizardWasShown(boolean bl) {
        this.wizardWasShown = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAvailable() {
        boolean isWizardDisabled = GuiTestingService.getInstance().isGuiTestingMode() || Boolean.getBoolean(SYSTEM_PROPERTY_DISABLE_WIZARD);
        if (this.wizardWasShown) return false;
        if (isWizardDisabled) return false;
        AndroidFirstRunPersistentData androidFirstRunPersistentData = AndroidFirstRunPersistentData.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)androidFirstRunPersistentData, (String)"getInstance(...)");
        InstallerData installerData = GlobalInstallerData.get();
        IdeSdks ideSdks = IdeSdks.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideSdks, (String)"getInstance(...)");
        if (this.getWizardMode(androidFirstRunPersistentData, installerData, ideSdks) == null) return false;
        return true;
    }

    @Nullable
    public final FirstRunWizardMode getWizardMode(@NotNull AndroidFirstRunPersistentData persistentData, @Nullable InstallerData installerData, @NotNull IdeSdks ideSdks) {
        Intrinsics.checkNotNullParameter((Object)persistentData, (String)"persistentData");
        Intrinsics.checkNotNullParameter((Object)ideSdks, (String)"ideSdks");
        if (((Boolean)StudioFlags.NPW_FIRST_RUN_SHOW.get()).booleanValue()) {
            return FirstRunWizardMode.NEW_INSTALL;
        }
        return this.isHandoff(persistentData, installerData) ? FirstRunWizardMode.INSTALL_HANDOFF : (!persistentData.isSdkUpToDate() ? FirstRunWizardMode.NEW_INSTALL : (ideSdks.getEligibleAndroidSdks().isEmpty() ? FirstRunWizardMode.MISSING_SDK : null));
    }

    private final boolean isHandoff(AndroidFirstRunPersistentData persistentData, InstallerData installerData) {
        InstallerData installerData2 = installerData;
        if (installerData2 == null) {
            return false;
        }
        InstallerData data2 = installerData2;
        return (!persistentData.isSdkUpToDate() || !persistentData.isSameTimestamp(data2.getTimestamp())) && data2.isCurrentVersion();
    }

    @WorkerThread
    public final void checkInternetConnection() {
        boolean retryConnection;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        JdkProxyProvider.Companion.ensureDefault();
        do {
            retryConnection = false;
            try {
                HttpURLConnection connection2 = HttpConnectionUtils.openHttpConnection((String)"http://developer.android.com");
                connection2.connect();
                connection2.disconnect();
                retryConnection = false;
            }
            catch (IOException e) {
                retryConnection = this.promptToRetryFailedConnection();
            }
            catch (RuntimeException e) {
                retryConnection = this.promptToRetryFailedConnection();
            }
            catch (Throwable e) {
                retryConnection = false;
                Object message = "Couldn't check internet connection";
                if (StringsKt.contains$default((CharSequence)e.toString(), (CharSequence)"crypto", (boolean)false, (int)2, null)) {
                    message = (String)message + "; check your JDK/JRE installation / consider running on a newer version.";
                }
                AndroidStudioWelcomeScreenProviderKt.getLog().warn((String)message, e);
            }
        } while (retryConnection);
    }

    private final boolean promptToRetryFailedConnection() {
        return (Boolean)ActionsKt.invokeAndWaitIfNeeded$default(null, () -> AndroidStudioWelcomeScreenService.promptToRetryFailedConnection$lambda$0(this), (int)1, null);
    }

    private final boolean promptUserForProxy() {
        boolean showSetupProxy;
        String[] stringArray = new String[]{"Setup Proxy", "Cancel"};
        int selection2 = Messages.showIdeaMessageDialog(null, (String)"Unable to access Android SDK add-on list", (String)"Android Studio First Run", (String[])stringArray, (int)1, (Icon)Messages.getErrorIcon(), null);
        boolean bl = showSetupProxy = selection2 == 0;
        if (showSetupProxy) {
            ProxyUtils.editConfigurable((ProxySettings)ProxySettings.Companion.getInstance(), null);
        }
        return showSetupProxy;
    }

    private static final boolean promptToRetryFailedConnection$lambda$0(AndroidStudioWelcomeScreenService this$0) {
        return this$0.promptUserForProxy();
    }

    @NotNull
    public static final AndroidStudioWelcomeScreenService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/welcome/wizard/AndroidStudioWelcomeScreenService$Companion;", "", "<init>", "()V", "SYSTEM_PROPERTY_DISABLE_WIZARD", "", "instance", "Lcom/android/tools/idea/welcome/wizard/AndroidStudioWelcomeScreenService;", "getInstance$annotations", "getInstance", "()Lcom/android/tools/idea/welcome/wizard/AndroidStudioWelcomeScreenService;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AndroidStudioWelcomeScreenService getInstance() {
            Object object = ApplicationManager.getApplication().getService(AndroidStudioWelcomeScreenService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (AndroidStudioWelcomeScreenService)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

