/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.Archive;
import com.android.tools.idea.welcome.SdkLocationUtils;
import com.android.tools.idea.welcome.wizard.FirstRunWizardModel;
import com.android.tools.idea.welcome.wizard.FirstRunWizardTracker;
import com.android.tools.idea.welcome.wizard.PackageInfoComparator;
import com.android.tools.idea.welcome.wizard.Section;
import com.android.tools.idea.welcome.wizard.WelcomeUiUtils;
import com.android.tools.idea.welcome.wizard.deprecated.InstallSummaryStepForm;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.android.utils.HtmlBuilder;
import com.google.wireless.android.sdk.stats.SetupWizardEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\b\u0010\u0014\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/welcome/wizard/InstallSummaryStep;", "Lcom/android/tools/idea/wizard/model/ModelWizardStep;", "Lcom/android/tools/idea/welcome/wizard/FirstRunWizardModel;", "model", "packagesProvider", "Ljava/util/function/Supplier;", "", "Lcom/android/repository/api/RemotePackage;", "tracker", "Lcom/android/tools/idea/welcome/wizard/FirstRunWizardTracker;", "<init>", "(Lcom/android/tools/idea/welcome/wizard/FirstRunWizardModel;Ljava/util/function/Supplier;Lcom/android/tools/idea/welcome/wizard/FirstRunWizardTracker;)V", "form", "Lcom/android/tools/idea/welcome/wizard/deprecated/InstallSummaryStepForm;", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusComponent", "onEntering", "", "onShowing", "generateSummary", "Companion", "intellij.android.core"})
public final class InstallSummaryStep
extends ModelWizardStep<FirstRunWizardModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirstRunWizardModel model;
    @NotNull
    private final Supplier<? extends Collection<RemotePackage>> packagesProvider;
    @NotNull
    private final FirstRunWizardTracker tracker;
    @NotNull
    private final InstallSummaryStepForm form;

    public InstallSummaryStep(@NotNull FirstRunWizardModel model, @NotNull Supplier<? extends Collection<? extends RemotePackage>> packagesProvider, @NotNull FirstRunWizardTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(packagesProvider, (String)"packagesProvider");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        super((WizardModel)model, "Verify Settings");
        this.model = model;
        this.packagesProvider = packagesProvider;
        this.tracker = tracker;
        this.form = new InstallSummaryStepForm();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JComponent jComponent = this.form.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getRoot(...)");
        return jComponent;
    }

    @Override
    @NotNull
    protected JComponent getPreferredFocusComponent() {
        JTextPane jTextPane = this.form.getSummaryText();
        Intrinsics.checkNotNullExpressionValue((Object)jTextPane, (String)"getSummaryText(...)");
        return jTextPane;
    }

    @Override
    protected void onEntering() {
        super.onEntering();
        this.generateSummary();
    }

    @Override
    protected void onShowing() {
        super.onShowing();
        this.tracker.trackStepShowing(SetupWizardEvent.WizardStep.WizardStepKind.INSTALL_SUMMARY);
    }

    private final void generateSummary() {
        Collection<RemotePackage> packages = this.packagesProvider.get();
        if (packages == null) {
            this.form.getSummaryText().setText("An error occurred while trying to compute required packages.");
            return;
        }
        FirstRunWizardModel.InstallationType installationType = this.model.getInstallationType();
        if (installationType == null) {
            installationType = FirstRunWizardModel.InstallationType.STANDARD;
        }
        FirstRunWizardModel.InstallationType installationType2 = installationType;
        Object[] objectArray = new Section[4];
        String string = installationType2.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = StringUtil.capitalize((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capitalize(...)");
        objectArray[0] = Companion.getSetupTypeSection(string2);
        Path path = this.model.getSdkInstallLocation();
        objectArray[1] = Companion.getSdkFolderSection(path != null ? path.toFile() : null);
        objectArray[2] = Companion.getDownloadSizeSection(packages);
        objectArray[3] = Companion.getPackagesSection(packages);
        List sections = CollectionsKt.listOf((Object[])objectArray);
        this.form.getSummaryText().setText(Companion.generateSummaryHtml(sections));
        this.form.getSummaryText().setCaretPosition(0);
    }

    @JvmStatic
    @NotNull
    public static final Section getSdkFolderSection(@Nullable File location) {
        return Companion.getSdkFolderSection(location);
    }

    @JvmStatic
    @NotNull
    public static final Section getSetupTypeSection(@NotNull String type) {
        return Companion.getSetupTypeSection(type);
    }

    @JvmStatic
    @NotNull
    public static final Section getPackagesSection(@NotNull Collection<? extends RemotePackage> remotePackages) {
        return Companion.getPackagesSection(remotePackages);
    }

    @JvmStatic
    @NotNull
    public static final Section getDownloadSizeSection(@NotNull Collection<? extends RemotePackage> remotePackages) {
        return Companion.getDownloadSizeSection(remotePackages);
    }

    @JvmStatic
    @NotNull
    public static final String generateSummaryHtml(@NotNull List<Section> sections) {
        return Companion.generateSummaryHtml(sections);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0016\u0010\u0010\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u0016\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0007\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/welcome/wizard/InstallSummaryStep$Companion;", "", "<init>", "()V", "getSdkFolderSection", "Lcom/android/tools/idea/welcome/wizard/Section;", "location", "Ljava/io/File;", "getSetupTypeSection", "type", "", "getPackagesSection", "remotePackages", "", "Lcom/android/repository/api/RemotePackage;", "getPackagesTable", "getDownloadSizeSection", "generateSummaryHtml", "sections", "", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nInstallSummaryStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallSummaryStep.kt\ncom/android/tools/idea/welcome/wizard/InstallSummaryStep$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1#2:169\n1869#3,2:170\n1563#3:172\n1634#3,3:173\n*S KotlinDebug\n*F\n+ 1 InstallSummaryStep.kt\ncom/android/tools/idea/welcome/wizard/InstallSummaryStep$Companion\n*L\n66#1:170,2\n83#1:172\n83#1:173,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Section getSdkFolderSection(@Nullable File location) {
            String text2 = location == null ? "" : (SdkLocationUtils.isWritable(location.toPath()) ? location.getAbsolutePath() : location.getAbsolutePath() + " (read-only)");
            Intrinsics.checkNotNull((Object)text2);
            return new Section("SDK Folder", text2);
        }

        @JvmStatic
        @NotNull
        public final Section getSetupTypeSection(@NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new Section("Setup Type", type);
        }

        @JvmStatic
        @NotNull
        public final Section getPackagesSection(@NotNull Collection<? extends RemotePackage> remotePackages) {
            Intrinsics.checkNotNullParameter(remotePackages, (String)"remotePackages");
            String string = this.getPackagesTable(remotePackages);
            if (string == null) {
                string = "";
            }
            return new Section("SDK Components to Download", string);
        }

        private final String getPackagesTable(Collection<? extends RemotePackage> remotePackages) {
            TreeSet treeSet;
            if (remotePackages.isEmpty()) {
                return null;
            }
            TreeSet $this$getPackagesTable_u24lambda_u240 = treeSet = SetsKt.sortedSetOf((Comparator)new PackageInfoComparator(), (Object[])new RemotePackage[0]);
            boolean bl = false;
            $this$getPackagesTable_u24lambda_u240.addAll(remotePackages);
            TreeSet sortedPackagesList = treeSet;
            TreeSet $this$getPackagesTable_u24lambda_u242 = treeSet = new HtmlBuilder();
            boolean bl2 = false;
            $this$getPackagesTable_u24lambda_u242.beginTable();
            Iterable $this$forEach$iv = sortedPackagesList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RemotePackage it = (RemotePackage)element$iv;
                boolean bl3 = false;
                $this$getPackagesTable_u24lambda_u242.beginTableRow();
                String[] stringArray = new String[3];
                stringArray[0] = it.getDisplayName();
                stringArray[1] = "&nbsp;&nbsp;";
                Archive archive = it.getArchive();
                Intrinsics.checkNotNull((Object)archive);
                stringArray[2] = WelcomeUiUtils.getSizeLabel(archive.getComplete().getSize());
                $this$getPackagesTable_u24lambda_u242.addTableRow(stringArray);
                $this$getPackagesTable_u24lambda_u242.endTableRow();
            }
            $this$getPackagesTable_u24lambda_u242.endTable();
            return treeSet.getHtml();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Section getDownloadSizeSection(@NotNull Collection<? extends RemotePackage> remotePackages) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(remotePackages, (String)"remotePackages");
            Iterable $this$map$iv = remotePackages;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RemotePackage remotePackage = (RemotePackage)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Archive archive = it.getArchive();
                Intrinsics.checkNotNull((Object)archive);
                collection2.add(archive.getComplete().getSize());
            }
            long downloadSize = CollectionsKt.sumOfLong((Iterable)((List)destination$iv$iv));
            return new Section("Total Download Size", downloadSize == 0L ? "" : WelcomeUiUtils.getSizeLabel(downloadSize));
        }

        @JvmStatic
        @NotNull
        public final String generateSummaryHtml(@NotNull List<Section> sections) {
            Intrinsics.checkNotNullParameter(sections, (String)"sections");
            StringBuilder builder = new StringBuilder("<html><head>");
            builder.append(UIUtil.getCssFontDeclaration((Font)StartupUiUtil.getLabelFont(), (Color)UIUtil.getLabelForeground(), null, null)).append("</head><body>");
            for (Section section : sections) {
                if (section.isEmpty()) continue;
                builder.append(section.getHtml());
            }
            builder.append("</body></html>");
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

