/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard.deprecated;

import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.HardwareAccelerationCheck;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.welcome.config.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.SdkComponentInstaller;
import com.android.tools.idea.welcome.wizard.ConfirmFirstRunWizardCloseDialog;
import com.android.tools.idea.welcome.wizard.FirstRunWizardTracker;
import com.android.tools.idea.welcome.wizard.deprecated.ConsolidatedProgressStep;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWelcomeStep;
import com.android.tools.idea.welcome.wizard.deprecated.InstallComponentsPath;
import com.android.tools.idea.welcome.wizard.deprecated.InstallationTypeWizardStep;
import com.android.tools.idea.welcome.wizard.deprecated.LinuxKvmInfoStep;
import com.android.tools.idea.welcome.wizard.deprecated.MissingSdkAlertStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.android.tools.idea.wizard.dynamic.SingleStepPath;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class FirstRunWizard
extends DynamicWizard {
    private static final String WIZARD_TITLE = "Android Studio Setup Wizard";
    public static final ScopedStateStore.Key<Boolean> KEY_CUSTOM_INSTALL = ScopedStateStore.createKey("custom.install", ScopedStateStore.Scope.WIZARD, Boolean.class);
    @NotNull
    private final FirstRunWizardMode myMode;
    private final AtomicBoolean myIsShowingProgressStep = new AtomicBoolean(false);
    @NotNull
    private final SdkComponentInstaller mySdkComponentInstaller;
    @NotNull
    private final FirstRunWizardTracker myTracker;
    private InstallComponentsPath myComponentsPath;

    public FirstRunWizard(@NotNull DynamicWizardHost host, @NotNull FirstRunWizardMode mode, @NotNull SdkComponentInstaller sdkComponentInstaller, @NotNull FirstRunWizardTracker tracker) {
        super(null, null, WIZARD_TITLE, host);
        this.myMode = mode;
        this.mySdkComponentInstaller = sdkComponentInstaller;
        this.myTracker = tracker;
        this.setTitle(WIZARD_TITLE);
    }

    @Override
    public void init() {
        File initialSdkLocation = FirstRunWizardDefaults.getInitialSdkLocation(this.myMode);
        if (this.myMode == FirstRunWizardMode.NEW_INSTALL) {
            this.addPath(new SingleStepPath(new FirstRunWelcomeStep(this.getSdkExists(initialSdkLocation), this.myTracker)));
            if (initialSdkLocation.getPath().isEmpty()) {
                this.myState.put(KEY_CUSTOM_INSTALL, true);
            } else {
                this.addPath(new SingleStepPath(new InstallationTypeWizardStep(KEY_CUSTOM_INSTALL, this.myTracker)));
            }
        }
        if (this.myMode == FirstRunWizardMode.MISSING_SDK) {
            this.addPath(new SingleStepPath(new MissingSdkAlertStep(this.myTracker)));
        }
        FirstRunProgressStep progressStep2 = new FirstRunProgressStep();
        this.myComponentsPath = new InstallComponentsPath(this.myMode, initialSdkLocation, progressStep2, this.mySdkComponentInstaller, true, this.myTracker);
        this.addPath(this.myComponentsPath);
        this.conditionallyAddEmulatorSettingsStep();
        this.addPath(new SingleStepPath(progressStep2));
        if (this.myPaths.stream().noneMatch(path -> path.getVisibleStepCount() > 0)) {
            this.myIsShowingProgressStep.set(true);
        }
        super.init();
    }

    private boolean getSdkExists(File initialSdkLocation) {
        if (initialSdkLocation.isDirectory()) {
            StudioLoggerProgressIndicator progress2;
            AndroidSdkHandler sdkHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, (Path)initialSdkLocation.toPath());
            return !sdkHandler.getRepoManagerAndLoadSynchronously((ProgressIndicator)(progress2 = new StudioLoggerProgressIndicator(this.getClass()))).getPackages().getLocalPackages().isEmpty();
        }
        return false;
    }

    private void conditionallyAddEmulatorSettingsStep() {
        if (!SystemInfo.isLinux) {
            return;
        }
        if (HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated()) {
            return;
        }
        if (!this.myMode.equals((Object)FirstRunWizardMode.NEW_INSTALL)) {
            return;
        }
        this.addPath(new SingleStepPath(new LinuxKvmInfoStep(this.myTracker)));
    }

    @Override
    public void doCancelAction() {
        ConfirmFirstRunWizardCloseDialog.Result result2 = ConfirmFirstRunWizardCloseDialog.show();
        switch (result2) {
            case Skip: {
                AndroidFirstRunPersistentData.getInstance().markSdkUpToDate(this.myMode.getInstallerTimestamp());
            }
            case Rerun: {
                this.myHost.close(DynamicWizardHost.CloseAction.CANCEL);
                break;
            }
        }
    }

    @Override
    public void doFinishAction() {
        if (!this.myIsShowingProgressStep.getAndSet(true)) {
            this.doNextAction();
        } else {
            assert (this.myIsShowingProgressStep.get());
            super.doFinishAction();
        }
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        return "Finishing setup...";
    }

    @Override
    public void performFinishingActions() {
    }

    @Override
    protected String getWizardActionDescription() {
        return WIZARD_TITLE;
    }

    private class FirstRunProgressStep
    extends ConsolidatedProgressStep {
        public FirstRunProgressStep() {
            super(FirstRunWizard.this.getDisposable(), FirstRunWizard.this.myHost, FirstRunWizard.this.myTracker);
            this.setPaths(FirstRunWizard.this.myPaths);
        }

        @Override
        public boolean isStepVisible() {
            return FirstRunWizard.this.myIsShowingProgressStep.get() && FirstRunWizard.this.myComponentsPath.shouldDownloadingComponentsStepBeShown();
        }
    }
}

