/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant;

import com.android.repository.Revision;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.assistant.DefaultTutorialBundle;
import com.android.tools.idea.whatsnew.assistant.WhatsNewBundle;
import com.android.tools.idea.whatsnew.assistant.WhatsNewConnectionOpener;
import com.android.tools.idea.whatsnew.assistant.WhatsNewURLProvider;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhatsNewBundleCreator
implements AssistantBundleCreator {
    public static final String BUNDLE_ID = "DeveloperServices.WhatsNewAssistant";
    private static AssistantBundleCreator ourTestCreator = null;
    @NotNull
    private WhatsNewURLProvider myURLProvider;
    @NotNull
    private final WhatsNewConnectionOpener myConnectionOpener;
    @NotNull
    private Revision myStudioRevision;
    @NotNull
    private Revision myLastSeenVersion;
    private boolean myAllowDownload;

    public WhatsNewBundleCreator() {
        this(new WhatsNewURLProvider(), Revision.safeParseRevision((String)ApplicationInfo.getInstance().getStrictVersion()), new WhatsNewConnectionOpener(), true);
    }

    public WhatsNewBundleCreator(@NotNull WhatsNewURLProvider urlProvider, @NotNull Revision studioRevision) {
        this(urlProvider, studioRevision, new WhatsNewConnectionOpener(), true);
    }

    @VisibleForTesting
    public WhatsNewBundleCreator(@NotNull WhatsNewURLProvider urlProvider, @NotNull Revision studioRevision, @NotNull WhatsNewConnectionOpener connectionOpener, boolean allowDownload) {
        this.myURLProvider = urlProvider;
        this.myConnectionOpener = connectionOpener;
        this.myStudioRevision = studioRevision;
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            this.myStudioRevision = Revision.NOT_SPECIFIED;
        }
        this.myLastSeenVersion = Revision.NOT_SPECIFIED;
        this.myAllowDownload = allowDownload;
    }

    @VisibleForTesting
    void setURLProvider(@NotNull WhatsNewURLProvider urlProvider) {
        this.myURLProvider = urlProvider;
    }

    @VisibleForTesting
    void setStudioRevision(@NotNull Revision revision) {
        this.myStudioRevision = revision;
    }

    @VisibleForTesting
    void setAllowDownload(boolean allowDownload) {
        this.myAllowDownload = allowDownload;
    }

    @Override
    @NotNull
    public String getBundleId() {
        return BUNDLE_ID;
    }

    @Override
    @Nullable
    public WhatsNewBundle getBundle(@NotNull Project project) {
        assert (ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread());
        this.updateConfig();
        return this.parseBundle();
    }

    @Override
    @Nullable
    public URL getConfig() {
        return null;
    }

    public boolean isNewConfigVersion() {
        assert (ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread());
        WhatsNewBundle oldBundle = this.parseBundle();
        if (oldBundle != null) {
            this.myLastSeenVersion = oldBundle.getVersion();
        }
        this.updateConfig();
        WhatsNewBundle newBundle = this.parseBundle();
        if (newBundle != null) {
            if (this.myLastSeenVersion.equals((Object)Revision.NOT_SPECIFIED)) {
                return true;
            }
            return newBundle.getVersion().compareTo(this.myLastSeenVersion) > 0;
        }
        return false;
    }

    @Nullable
    private WhatsNewBundle parseBundle() {
        WhatsNewBundle bundle = this.parseBundleWorker();
        if (bundle != null) {
            return bundle;
        }
        try {
            Path path = this.myURLProvider.getLocalConfig(this.getStudioRevision());
            Files.delete(path);
        }
        catch (IOException e) {
            WhatsNewBundleCreator.getLog().warn("Error deleting cached file", (Throwable)e);
            return null;
        }
        WhatsNewBundleCreator.getLog().info("Retrying WNA parseBundle after deleting possibly corrupt file.");
        this.updateConfig();
        return this.parseBundleWorker();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private WhatsNewBundle parseBundleWorker() {
        try (InputStream configStream = this.openConfigStream();){
            if (configStream == null) {
                WhatsNewBundle whatsNewBundle2 = null;
                return whatsNewBundle2;
            }
            WhatsNewBundle whatsNewBundle = DefaultTutorialBundle.parse(configStream, WhatsNewBundle.class, this.getBundleId());
            return whatsNewBundle;
        }
        catch (Exception e) {
            WhatsNewBundleCreator.getLog().warn("Error parsing bundle", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private InputStream openConfigStream() throws FileNotFoundException {
        Path path = this.myURLProvider.getLocalConfig(this.getStudioRevision());
        if (Files.exists(path, new LinkOption[0])) {
            return new FileInputStream(path.toFile());
        }
        return this.myURLProvider.getResourceFileAsStream(this, this.getStudioRevision());
    }

    private void updateConfig() {
        if (this.myAllowDownload && !this.myStudioRevision.equals((Object)Revision.parseRevision((String)"0.0.0rc0"))) {
            URL webConfig = this.myURLProvider.getWebConfig(this.getStudioRevision());
            Path localConfigPath = this.myURLProvider.getLocalConfig(this.getStudioRevision());
            this.downloadConfig(webConfig, localConfigPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadConfig(@NotNull URL sourceUrl, @NotNull Path destinationFilePath) {
        ReadableByteChannel byteChannel;
        try {
            WhatsNewBundleCreator.getLog().info("Trying to download config XML from " + String.valueOf(sourceUrl));
            URLConnection connection2 = this.myConnectionOpener.openConnection(sourceUrl, -1);
            byteChannel = Channels.newChannel(connection2.getInputStream());
        }
        catch (FileNotFoundException e) {
            WhatsNewBundleCreator.getLog().info("Remote WNA config file not found", (Throwable)e);
            return;
        }
        catch (Exception e) {
            WhatsNewBundleCreator.getLog().warn((Throwable)e);
            return;
        }
        if (byteChannel != null) {
            File temporaryConfig = null;
            try {
                temporaryConfig = FileUtil.createTempFile((String)("whatsnew-" + this.getStudioRevision()), (String)".xml");
                try (FileOutputStream outputStream = new FileOutputStream(temporaryConfig);
                     FileChannel fileChannel = outputStream.getChannel();){
                    fileChannel.transferFrom(byteChannel, 0L, Long.MAX_VALUE);
                    FileUtil.copy((File)temporaryConfig, (File)destinationFilePath.toFile());
                }
            }
            catch (Exception e) {
                WhatsNewBundleCreator.getLog().warn((Throwable)e);
            }
            finally {
                if (temporaryConfig != null) {
                    temporaryConfig.delete();
                }
            }
        }
    }

    @NotNull
    private String getStudioRevision() {
        return this.myStudioRevision.getMajor() + "." + this.myStudioRevision.getMinor() + "." + this.myStudioRevision.getMicro();
    }

    public boolean shouldNotShowWhatsNew() {
        if (!WhatsNewBundleCreator.shouldShowReleaseNotes()) {
            WhatsNewBundleCreator.getLog().info("Should not show what's new because IDE is not Android Studio, or can't get bundle creator");
            return true;
        }
        return !this.hasResourceConfig();
    }

    @VisibleForTesting
    static boolean shouldShowReleaseNotes() {
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            return false;
        }
        Optional<AssistantBundleCreator> creator = WhatsNewBundleCreator.getCreator();
        return creator.isPresent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    boolean hasResourceConfig() {
        try (InputStream stream = this.myURLProvider.getResourceFileAsStream(this, this.getStudioRevision());){
            if (stream == null) {
                WhatsNewBundleCreator.getLog().info("stream == null");
                boolean bl = false;
                return bl;
            }
            WhatsNewBundle bundle = DefaultTutorialBundle.parse(stream, WhatsNewBundle.class, this.getBundleId());
            if (this.myStudioRevision.equals((Object)Revision.parseRevision((String)"0.0.0rc0"))) {
                WhatsNewBundleCreator.getLog().info("Will show resource config for local file since this is a dev build");
                boolean bl = true;
                return bl;
            }
            boolean bl = this.isBundleRevisionSame(bundle.getVersion());
            return bl;
        }
        catch (Exception e) {
            WhatsNewBundleCreator.getLog().warn((Throwable)e);
            return false;
        }
    }

    private boolean isBundleRevisionSame(@NotNull Revision revision) {
        WhatsNewBundleCreator.getLog().info("Checking bundle revision: " + String.valueOf(revision) + " vs Studio: " + String.valueOf(this.myStudioRevision));
        return revision.getMajor() == this.myStudioRevision.getMajor() && revision.getMinor() == this.myStudioRevision.getMinor();
    }

    @VisibleForTesting
    public static void setTestCreator(@Nullable AssistantBundleCreator testCreator) {
        ourTestCreator = testCreator;
    }

    private static Optional<AssistantBundleCreator> getCreator() {
        if (ourTestCreator != null) {
            return Optional.of(ourTestCreator);
        }
        return Arrays.stream((AssistantBundleCreator[])AssistantBundleCreator.EP_NAME.getExtensions()).filter(extension -> extension.getBundleId().equals(BUNDLE_ID)).findFirst();
    }

    private static Logger getLog() {
        return Logger.getInstance(WhatsNewBundleCreator.class);
    }
}

