/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.ptable.impl;

import com.android.tools.property.ptable.PTableExpandableComponentKt;
import com.android.tools.property.ptable.impl.PTableImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.TableCell;
import com.intellij.ui.TableExpandableItemsHandler;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0007H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/property/ptable/impl/PTableExpandableItemsHandler;", "Lcom/intellij/ui/TableExpandableItemsHandler;", "table", "Lcom/android/tools/property/ptable/impl/PTableImpl;", "<init>", "(Lcom/android/tools/property/ptable/impl/PTableImpl;)V", "expandedCell", "Lcom/intellij/ui/TableCell;", "computeCellRendererAndBounds", "Lcom/intellij/openapi/util/Pair;", "Ljava/awt/Component;", "Ljava/awt/Rectangle;", "key", "getExpandedItems", "", "getCellKeyForPoint", "point", "Ljava/awt/Point;", "invalidate", "", "computeRestrictedCellAtPoint", "getCellRendererAndBounds", "isEnabled", "", "intellij.android.layout-ui"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nPTableImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PTableImpl.kt\ncom/android/tools/property/ptable/impl/PTableExpandableItemsHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1034:1\n1#2:1035\n*E\n"})
public final class PTableExpandableItemsHandler
extends TableExpandableItemsHandler {
    @Nullable
    private TableCell expandedCell;

    public PTableExpandableItemsHandler(@NotNull PTableImpl table2) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        super((JTable)((Object)table2));
    }

    @TestOnly
    @Nullable
    public final Pair<Component, Rectangle> computeCellRendererAndBounds(@NotNull TableCell key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getCellRendererAndBounds(key);
    }

    @NotNull
    public Collection<TableCell> getExpandedItems() {
        Collection collection2;
        if (this.expandedCell == null) {
            collection2 = CollectionsKt.emptyList();
        } else {
            TableCell tableCell = this.expandedCell;
            Intrinsics.checkNotNull((Object)tableCell);
            collection2 = SetsKt.setOf((Object)tableCell);
        }
        return collection2;
    }

    @Nullable
    public TableCell getCellKeyForPoint(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        TableCell cell = this.computeRestrictedCellAtPoint(point);
        if (!Intrinsics.areEqual((Object)this.expandedCell, (Object)cell)) {
            TableCell tableCell = cell;
            if (tableCell != null) {
                this.invalidate(tableCell);
            }
            TableCell tableCell2 = this.expandedCell;
            if (tableCell2 != null) {
                this.invalidate(tableCell2);
            }
        }
        this.expandedCell = cell;
        return cell;
    }

    private final void invalidate(TableCell $this$invalidate) {
        ((JTable)this.myComponent).repaint(((JTable)this.myComponent).getCellRect($this$invalidate.row, $this$invalidate.column, true));
    }

    private final TableCell computeRestrictedCellAtPoint(Point point) {
        TableCell tableCell;
        TableCell tableCell2 = super.getCellKeyForPoint(point);
        if (tableCell2 == null) {
            return null;
        }
        TableCell cell = tableCell2;
        Object value2 = ((JTable)this.myComponent).getValueAt(cell.row, cell.column);
        TableCellRenderer renderer2 = ((JTable)this.myComponent).getCellRenderer(cell.row, cell.column);
        Component component = renderer2.getTableCellRendererComponent((JTable)this.myComponent, value2, false, false, cell.row, cell.column);
        Rectangle bounds = ((JTable)this.myComponent).getCellRect(cell.row, cell.column, true);
        Component component2 = SwingUtilities.getDeepestComponentAt(component, point.x - bounds.x, point.y - bounds.y);
        if (component2 == null) {
            return null;
        }
        Component componentUnderMouse = component2;
        Function0 isVisuallyRestricted = (Function0)ClientProperty.get((Component)componentUnderMouse, PTableExpandableComponentKt.getKEY_IS_VISUALLY_RESTRICTED());
        if (Intrinsics.areEqual((Object)cell, (Object)this.expandedCell) && isVisuallyRestricted != null) {
            return this.expandedCell;
        }
        TableCell it = tableCell = cell;
        boolean bl = false;
        return isVisuallyRestricted != null && (Boolean)isVisuallyRestricted.invoke() != false ? tableCell : null;
    }

    @Nullable
    public Pair<Component, Rectangle> getCellRendererAndBounds(@NotNull TableCell key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Pair pair = super.getCellRendererAndBounds(key);
        if (pair == null) {
            return null;
        }
        Pair rendererAndBounds = pair;
        Rectangle rectangle = (Rectangle)rendererAndBounds.second;
        rectangle.width += JBUIScale.scale((int)4);
        return rendererAndBounds;
    }

    public boolean isEnabled() {
        return true;
    }
}

