/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.classloading;

import com.android.tools.rendering.classloading.ClassLoaderPreloaderKt;
import com.android.tools.rendering.classloading.ClassTransform;
import com.android.tools.rendering.classloading.ModuleClassLoader;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\r\u0010\u0014\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002J \u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020 R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00018\u00008\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/rendering/classloading/Preloader;", "T", "Lcom/android/tools/rendering/classloading/ModuleClassLoader;", "", "moduleClassLoader", "executor", "Ljava/util/concurrent/Executor;", "classesToPreload", "", "", "<init>", "(Lcom/android/tools/rendering/classloading/ModuleClassLoader;Ljava/util/concurrent/Executor;Ljava/util/Collection;)V", "classLoader", "Ljava/lang/ref/SoftReference;", "kotlin.jvm.PlatformType", "isActive", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cancel", "", "dispose", "getClassLoader", "()Lcom/android/tools/rendering/classloading/ModuleClassLoader;", "isLoadingFor", "", "cl", "isForCompatible", "parent", "Ljava/lang/ClassLoader;", "projectTransformations", "Lcom/android/tools/rendering/classloading/ClassTransform;", "nonProjectTransformations", "getLoadedCount", "", "intellij.android.rendering"})
@SourceDebugExtension(value={"SMAP\nPreloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Preloader.kt\ncom/android/tools/rendering/classloading/Preloader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public class Preloader<T extends ModuleClassLoader> {
    @NotNull
    private final SoftReference<T> classLoader;
    @NotNull
    private AtomicBoolean isActive;

    public Preloader(@NotNull T moduleClassLoader, @NotNull Executor executor, @NotNull Collection<String> classesToPreload) {
        Intrinsics.checkNotNullParameter(moduleClassLoader, (String)"moduleClassLoader");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(classesToPreload, (String)"classesToPreload");
        this.classLoader = new SoftReference<T>(moduleClassLoader);
        this.isActive = new AtomicBoolean(true);
        if (!classesToPreload.isEmpty()) {
            ClassLoaderPreloaderKt.preload((ClassLoader)moduleClassLoader, (Function0<Boolean>)((Function0)() -> Preloader._init_$lambda$0(this)), classesToPreload, executor);
        }
    }

    public /* synthetic */ Preloader(ModuleClassLoader moduleClassLoader, Executor executor, Collection collection2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            collection2 = CollectionsKt.emptyList();
        }
        this(moduleClassLoader, executor, collection2);
    }

    public final void cancel() {
        this.isActive.set(false);
    }

    public final void dispose() {
        block0: {
            this.cancel();
            ModuleClassLoader classLoaderToDispose = (ModuleClassLoader)this.classLoader.get();
            this.classLoader.clear();
            ModuleClassLoader moduleClassLoader = classLoaderToDispose;
            if (moduleClassLoader == null) break block0;
            moduleClassLoader.dispose();
        }
    }

    @Nullable
    public final T getClassLoader() {
        this.cancel();
        return (T)((ModuleClassLoader)this.classLoader.get());
    }

    public final boolean isLoadingFor(@NotNull ModuleClassLoader cl) {
        Intrinsics.checkNotNullParameter((Object)cl, (String)"cl");
        return Intrinsics.areEqual(this.classLoader.get(), (Object)cl);
    }

    public final boolean isForCompatible(@Nullable ClassLoader parent, @NotNull ClassTransform projectTransformations, @NotNull ClassTransform nonProjectTransformations) {
        Intrinsics.checkNotNullParameter((Object)projectTransformations, (String)"projectTransformations");
        Intrinsics.checkNotNullParameter((Object)nonProjectTransformations, (String)"nonProjectTransformations");
        ModuleClassLoader moduleClassLoader = (ModuleClassLoader)this.classLoader.get();
        return moduleClassLoader != null ? moduleClassLoader.isCompatible(parent, projectTransformations, nonProjectTransformations) : false;
    }

    public final int getLoadedCount() {
        int n;
        ModuleClassLoader moduleClassLoader = (ModuleClassLoader)this.classLoader.get();
        if (moduleClassLoader != null) {
            ModuleClassLoader it = moduleClassLoader;
            boolean bl = false;
            n = it.getNonProjectLoadedClasses().size() + it.getProjectLoadedClasses().size();
        } else {
            n = 0;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean _init_$lambda$0(Preloader this$0) {
        if (!this$0.isActive.get()) return false;
        ModuleClassLoader moduleClassLoader = (ModuleClassLoader)this$0.classLoader.get();
        if (moduleClassLoader == null) return false;
        boolean bl = moduleClassLoader.isDisposed();
        if (bl) return false;
        return true;
    }
}

