/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.classloading.loaders;

import com.android.tools.rendering.classloading.UtilKt;
import com.android.tools.rendering.classloading.loaders.DelegatingClassLoader;
import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \b\u0002\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/rendering/classloading/loaders/ClassLoaderLoader;", "Lcom/android/tools/rendering/classloading/loaders/DelegatingClassLoader$Loader;", "classLoader", "Ljava/lang/ClassLoader;", "onLoadedClass", "Lkotlin/Function3;", "", "", "", "<init>", "(Ljava/lang/ClassLoader;Lkotlin/jvm/functions/Function3;)V", "loadClass", "fqcn", "intellij.android.rendering"})
public final class ClassLoaderLoader
implements DelegatingClassLoader.Loader {
    @NotNull
    private final ClassLoader classLoader;
    @NotNull
    private final Function3<String, String, byte[], Unit> onLoadedClass;

    @JvmOverloads
    public ClassLoaderLoader(@NotNull ClassLoader classLoader, @NotNull Function3<? super String, ? super String, ? super byte[], Unit> onLoadedClass) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter(onLoadedClass, (String)"onLoadedClass");
        this.classLoader = classLoader;
        this.onLoadedClass = onLoadedClass;
    }

    public /* synthetic */ ClassLoaderLoader(ClassLoader classLoader, Function3 function3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function3 = ClassLoaderLoader::_init_$lambda$0;
        }
        this(classLoader, (Function3<? super String, ? super String, ? super byte[], Unit>)function3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public byte[] loadClass(@NotNull String fqcn) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
        String diskName = UtilKt.fromPackageNameToBinaryName(fqcn) + ".class";
        URL uRL = this.classLoader.getResource(diskName);
        if (uRL == null) {
            return null;
        }
        URL classUrl = uRL;
        Closeable closeable = this.classLoader.getResourceAsStream(diskName);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            InputStream inputStream = it;
            byArray = (byte[])(inputStream == null ? null : ByteStreams.toByteArray((InputStream)inputStream));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] bytes2 = byArray;
        if (bytes2 != null) {
            String string = classUrl.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            this.onLoadedClass.invoke((Object)fqcn, (Object)string, (Object)bytes2);
        }
        return bytes2;
    }

    @JvmOverloads
    public ClassLoaderLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this(classLoader, null, 2, null);
    }

    private static final Unit _init_$lambda$0(String string, String string2, byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<unused var>");
        return Unit.INSTANCE;
    }
}

