/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res;

import com.android.ide.common.resources.ProtoXmlPullParser;
import com.android.ide.common.util.PathString;
import com.android.tools.apk.analyzer.BinaryXmlParser;
import com.android.tools.apk.analyzer.ResourceIdResolver;
import com.android.utils.XmlUtils;
import com.android.zipflinger.ZipMap;
import com.android.zipflinger.ZipRepo;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Shorts;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FileResourceReader {
    private static final String APK_PROTOCOL = "apk";
    private static final LoadingCache<String, ZipMap> sZipCache = CacheBuilder.newBuilder().maximumSize(10L).expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, ZipMap>(){

        public ZipMap load(@NotNull String path) throws IOException {
            return ZipMap.from((Path)Paths.get(path, new String[0]));
        }
    });

    @NotNull
    public static byte[] readBytes(@NotNull PathString resourcePath, @NotNull ResourceIdResolver resourceIdResolver) throws IOException {
        String scheme;
        switch (scheme = resourcePath.getFilesystemUri().getScheme()) {
            case "file": {
                return FileResourceReader.readFileBytes(resourcePath.getRawPath());
            }
            case "apk": 
            case "jar": {
                String path = resourcePath.getRawPath();
                int separatorPos = path.indexOf("!/");
                int separatorEnd = separatorPos + "!/".length();
                if (separatorPos <= 0 || separatorEnd == path.length()) {
                    throw new IllegalArgumentException("Invalid path in \"" + String.valueOf(resourcePath) + "\"");
                }
                byte[] rawContent = FileResourceReader.readZipEntryBytes(path.substring(0, separatorPos), path.substring(separatorEnd));
                if (FileResourceReader.isBinaryEncoded(scheme, path, rawContent)) {
                    return BinaryXmlParser.decodeXml((byte[])rawContent, (ResourceIdResolver)resourceIdResolver);
                }
                return rawContent;
            }
        }
        throw new IllegalArgumentException("Unknown schema in \"" + String.valueOf(resourcePath) + "\"");
    }

    private static boolean isBinaryEncoded(@NotNull String scheme, @NotNull String path, @NotNull byte[] resourceBytes) {
        return scheme.equals(APK_PROTOCOL) && path.endsWith(".xml") && resourceBytes.length > 2 && Shorts.fromBytes((byte)resourceBytes[1], (byte)resourceBytes[0]) == Chunk.Type.XML.code();
    }

    @NotNull
    public static byte[] readBytes(@NotNull String resourcePath) throws IOException {
        if (resourcePath.startsWith("apk:") || resourcePath.startsWith("jar:")) {
            int separatorPos;
            int prefixLength = "apk:".length();
            if (resourcePath.startsWith("//", prefixLength)) {
                prefixLength += "//".length();
            }
            if ((separatorPos = resourcePath.lastIndexOf("!/")) < prefixLength) {
                throw new IllegalArgumentException("Invalid resource path \"" + resourcePath + "\"");
            }
            return FileResourceReader.readZipEntryBytes(resourcePath.substring(prefixLength, separatorPos), resourcePath.substring(separatorPos + "!/".length()));
        }
        if (resourcePath.startsWith("file:")) {
            int prefixLength = "file:".length();
            if (resourcePath.startsWith("//", prefixLength)) {
                prefixLength += "//".length();
            }
            resourcePath = resourcePath.substring(prefixLength);
        }
        return FileResourceReader.readFileBytes(resourcePath);
    }

    @NotNull
    private static byte[] readFileBytes(String filePath) throws IOException {
        try (FileInputStream fileStream = new FileInputStream(filePath);){
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            ByteStreams.copy((InputStream)fileStream, (OutputStream)byteOutputStream);
            byte[] byArray = byteOutputStream.toByteArray();
            return byArray;
        }
    }

    @NotNull
    private static byte[] readZipEntryBytes(String zipPath, String zipEntryPath) throws IOException {
        ZipMap zipMap;
        try {
            zipMap = (ZipMap)sZipCache.get((Object)zipPath);
        }
        catch (ExecutionException e) {
            Throwable nested = e.getCause();
            if (nested instanceof IOException) {
                throw (IOException)nested;
            }
            if (nested instanceof RuntimeException) {
                throw (RuntimeException)nested;
            }
            if (nested instanceof Error) {
                throw (Error)nested;
            }
            throw new UncheckedExecutionException(nested);
        }
        try (ZipRepo zipRepo = new ZipRepo(zipMap);){
            ByteBuffer entryContent = zipRepo.getContent(zipEntryPath);
            byte[] bytes2 = new byte[entryContent.remaining()];
            entryContent.get(bytes2);
            byte[] byArray = bytes2;
            return byArray;
        }
    }

    @Nullable
    public static XmlPullParser createXmlPullParser(@NotNull PathString resourcePath, @NotNull ResourceIdResolver resIdResolver) throws IOException {
        try {
            byte[] contents = FileResourceReader.readBytes(resourcePath, resIdResolver);
            return FileResourceReader.createXmlPullParser(contents);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @NotNull
    public static XmlPullParser createXmlPullParser(@NotNull byte[] contents) {
        try {
            ProtoXmlPullParser parser;
            if (XmlUtils.isProtoXml((byte[])contents)) {
                parser = new ProtoXmlPullParser();
            } else {
                parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            }
            parser.setInput((InputStream)new ByteArrayInputStream(contents), null);
            return parser;
        }
        catch (XmlPullParserException e) {
            throw new Error("Internal error", e);
        }
    }

    private FileResourceReader() {
    }
}

