/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res.ids;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.RClassNaming;
import com.android.resources.ResourceType;
import com.android.tools.environment.Logger;
import com.android.tools.log.LogAnonymizer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ResourceClassGenerator {
    private static final Logger LOG = Logger.getInstance(ResourceClassGenerator.class);
    private long myIdGeneratorGeneration = -1L;
    private Map<ResourceType, Object2IntOpenHashMap<String>> myCache;
    private Map<String, IntArrayList> myStyleableCache;
    @NotNull
    private final ResourceRepository myResources;
    @NotNull
    private final NumericIdProvider myIdProvider;
    @NotNull
    private final ResourceNamespace myNamespace;

    private ResourceClassGenerator(@NotNull NumericIdProvider idProvider, @NotNull ResourceRepository resources, @NotNull ResourceNamespace namespace) {
        this.myIdProvider = idProvider;
        this.myResources = resources;
        this.myNamespace = namespace;
    }

    @NotNull
    public static ResourceClassGenerator create(@NotNull NumericIdProvider manager, @NotNull ResourceRepository resources, @NotNull ResourceNamespace namespace) {
        return new ResourceClassGenerator(manager, resources, namespace);
    }

    @Nullable
    public byte[] generate(String fqcn) {
        String className = fqcn.replace('.', '/');
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("generate(%s)", LogAnonymizer.anonymizeClassName(className)));
        }
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 49, className, null, Type.getInternalName(Object.class), null);
        int index = className.lastIndexOf(36);
        if (index != -1) {
            String typeName = className.substring(index + 1);
            ResourceType type = ResourceType.fromClassName((String)typeName);
            if (type == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("  type '%s' doesn't exist", typeName));
                }
                return null;
            }
            cw.visitInnerClass(className, className.substring(0, index), typeName, 25);
            long currentIdGeneration = this.myIdProvider.getGeneration();
            if (this.myIdGeneratorGeneration != currentIdGeneration || this.myCache == null) {
                this.myCache = Maps.newHashMap();
                this.myStyleableCache = null;
                this.myIdGeneratorGeneration = currentIdGeneration;
            }
            if (type == ResourceType.STYLEABLE) {
                if (this.myStyleableCache == null) {
                    this.myCache.put(ResourceType.STYLEABLE, (Object2IntOpenHashMap<String>)new Object2IntOpenHashMap());
                    this.myStyleableCache = Maps.newHashMap();
                    this.generateStyleable(cw, className);
                } else {
                    Object2IntOpenHashMap<String> indexFieldsCache = this.myCache.get(ResourceType.STYLEABLE);
                    assert (indexFieldsCache != null);
                    ResourceClassGenerator.generateFields(cw, indexFieldsCache);
                    this.generateIntArraysFromCache(cw, className);
                }
            } else {
                Object2IntOpenHashMap typeCache = this.myCache.get(type);
                if (typeCache == null) {
                    typeCache = new Object2IntOpenHashMap();
                    this.myCache.put(type, (Object2IntOpenHashMap<String>)typeCache);
                    this.generateValuesForType(cw, type, (Object2IntOpenHashMap<String>)typeCache);
                } else {
                    ResourceClassGenerator.generateFields(cw, typeCache);
                }
            }
        } else {
            for (ResourceType t : this.myResources.getResourceTypes(this.myNamespace)) {
                if (!t.getHasInnerClass()) continue;
                cw.visitInnerClass(className + "$" + t.getName(), className, t.getName(), 25);
            }
        }
        ResourceClassGenerator.generateConstructor(cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void generateValuesForType(@NotNull ClassWriter cw, @NotNull ResourceType resType, @NotNull Object2IntOpenHashMap<String> cache) {
        Set resourceNames = this.myResources.getResourceNames(this.myNamespace, resType);
        for (String name2 : resourceNames) {
            int initialValue = this.myIdProvider.getOrGenerateId(new ResourceReference(this.myNamespace, resType, name2));
            name2 = RClassNaming.getFieldNameByResourceName((String)name2);
            ResourceClassGenerator.generateField(cw, name2, initialValue);
            cache.put((Object)name2, initialValue);
        }
    }

    @NotNull
    private static List<ResourceReference> getStyleableAttributes(@NotNull ResourceItem item) {
        ResourceValue resourceValue = item.getResourceValue();
        assert (resourceValue instanceof StyleableResourceValue);
        StyleableResourceValue dv = (StyleableResourceValue)resourceValue;
        return Lists.transform((List)dv.getAllAttributes(), ResourceValue::asReference);
    }

    private void generateStyleable(@NotNull ClassWriter cw, String className) {
        String fieldName;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("generateStyleable(%s)", LogAnonymizer.anonymizeClassName(className)));
        }
        boolean debug2 = LOG.isDebugEnabled() && LogAnonymizer.isPublicClass(className);
        Object2IntOpenHashMap<String> indexFieldsCache = this.myCache.get(ResourceType.STYLEABLE);
        Set styleableNames = this.myResources.getResourceNames(this.myNamespace, ResourceType.STYLEABLE);
        ArrayList<MergedStyleable> mergedStyleables = new ArrayList<MergedStyleable>(styleableNames.size());
        for (String styleableName : styleableNames) {
            Object item2;
            List items = this.myResources.getResources(this.myNamespace, ResourceType.STYLEABLE, styleableName);
            if (items.isEmpty()) {
                if (!debug2) continue;
                LOG.debug("  No items for " + styleableName);
                continue;
            }
            fieldName = RClassNaming.getFieldNameByResourceName((String)styleableName);
            cw.visitField(25, fieldName, "[I", null, null);
            if (debug2) {
                LOG.debug("  Defined styleable " + fieldName);
            }
            LinkedHashSet<ResourceReference> mergedAttributes = new LinkedHashSet<ResourceReference>();
            for (Object item2 : items) {
                mergedAttributes.addAll(ResourceClassGenerator.getStyleableAttributes((ResourceItem)item2));
            }
            mergedStyleables.add(new MergedStyleable(styleableName, mergedAttributes));
            int idx = 0;
            item2 = mergedAttributes.iterator();
            while (item2.hasNext()) {
                ResourceReference attr = (ResourceReference)item2.next();
                String styleableEntryName = this.getResourceName(fieldName, attr);
                int fieldValue = idx++;
                cw.visitField(25, styleableEntryName, "I", null, (Object)fieldValue);
                indexFieldsCache.put((Object)styleableEntryName, fieldValue);
                if (!debug2) continue;
                LOG.debug("  Defined styleable " + styleableEntryName);
            }
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        for (MergedStyleable mergedStyleable : mergedStyleables) {
            fieldName = RClassNaming.getFieldNameByResourceName((String)mergedStyleable.name);
            IntArrayList values = new IntArrayList();
            for (ResourceReference attr : mergedStyleable.attrs) {
                values.add(this.myIdProvider.getOrGenerateId(attr));
            }
            this.myStyleableCache.put(fieldName, values);
            ResourceClassGenerator.generateArrayInitialization(mv, className, fieldName, values);
        }
        mv.visitInsn(177);
        mv.visitMaxs(4, 0);
        mv.visitEnd();
    }

    private static void generateFields(@NotNull ClassWriter cw, @NotNull Object2IntOpenHashMap<String> values) {
        values.forEach((name2, value2) -> ResourceClassGenerator.generateField(cw, name2, value2));
    }

    private static void generateField(@NotNull ClassWriter cw, String name2, int value2) {
        cw.visitField(25, name2, "I", null, (Object)value2).visitEnd();
    }

    private void generateIntArraysFromCache(@NotNull ClassWriter cw, String className) {
        for (String name2 : this.myStyleableCache.keySet()) {
            cw.visitField(25, name2, "[I", null, null);
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        this.myStyleableCache.forEach((arrayName, values) -> ResourceClassGenerator.generateArrayInitialization(mv, className, arrayName, values));
        mv.visitInsn(177);
        mv.visitMaxs(4, 0);
        mv.visitEnd();
    }

    private static void pushIntValue(@NotNull MethodVisitor mv, int value2) {
        if (value2 >= -1 && value2 <= 5) {
            mv.visitInsn(3 + value2);
        } else if (value2 >= -128 && value2 <= 127) {
            mv.visitIntInsn(16, value2);
        } else if (value2 >= Short.MIN_VALUE && value2 <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, value2);
        } else {
            mv.visitLdcInsn((Object)value2);
        }
    }

    private static void generateArrayInitialization(@NotNull MethodVisitor mv, String className, String fieldName, @NotNull IntArrayList values) {
        if (values.isEmpty()) {
            return;
        }
        ResourceClassGenerator.pushIntValue(mv, values.size());
        mv.visitIntInsn(188, 10);
        for (int idx = 0; idx < values.size(); ++idx) {
            mv.visitInsn(89);
            ResourceClassGenerator.pushIntValue(mv, idx);
            mv.visitLdcInsn((Object)values.get(idx));
            mv.visitInsn(79);
        }
        mv.visitFieldInsn(179, className, fieldName, "[I");
    }

    private static void generateConstructor(@NotNull ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public String getResourceName(String styleableName, @NotNull ResourceReference value2) {
        String packageName;
        StringBuilder sb = new StringBuilder(30);
        sb.append(styleableName);
        sb.append('_');
        if (!value2.getNamespace().equals((Object)this.myNamespace) && (packageName = value2.getNamespace().getPackageName()) != null) {
            ResourceClassGenerator.appendEscaped(sb, packageName);
            sb.append('_');
        }
        ResourceClassGenerator.appendEscaped(sb, value2.getName());
        return sb.toString();
    }

    private static void appendEscaped(@NotNull StringBuilder sb, @NotNull String v) {
        int n = v.length();
        for (int i = 0; i < n; ++i) {
            char c = v.charAt(i);
            if (c == '.' || c == ':' || c == '-') {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
    }

    public static interface NumericIdProvider {
        public long getGeneration();

        public int getOrGenerateId(@NotNull ResourceReference var1);
    }

    private static class MergedStyleable {
        @NotNull
        final String name;
        @NotNull
        final LinkedHashSet<ResourceReference> attrs;

        private MergedStyleable(@NotNull String name2, @NotNull LinkedHashSet<ResourceReference> attrs) {
            this.name = name2;
            this.attrs = attrs;
        }
    }
}

