/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sdk;

import com.android.io.CancellableFileIo;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkPaths {
    private SdkPaths() {
    }

    @NotNull
    public static ValidationResult validateAndroidSdk(@Nullable Path sdkPath, boolean includePathInMessage) {
        return SdkPaths.validatedSdkPath(sdkPath, "SDK", false, includePathInMessage);
    }

    @Deprecated
    @NotNull
    public static ValidationResult validateAndroidSdk(@Nullable File sdkFile, boolean includePathInMessage) {
        return SdkPaths.validateAndroidSdk(sdkFile == null ? null : sdkFile.toPath(), includePathInMessage);
    }

    @NotNull
    public static ValidationResult validatedSdkPath(@Nullable Path sdkPath, @NotNull String sdkName, boolean checkForWritable, boolean includePathInMessage) {
        if (sdkPath == null) {
            return ValidationResult.error("");
        }
        String cause = null;
        if (!CancellableFileIo.isDirectory((Path)sdkPath, (LinkOption[])new LinkOption[0])) {
            cause = "does not belong to a directory.";
        } else if (!CancellableFileIo.isReadable((Path)sdkPath)) {
            cause = "is not readable.";
        } else if (checkForWritable && !CancellableFileIo.isWritable((Path)sdkPath)) {
            cause = "is not writable.";
        }
        if (!Strings.isNullOrEmpty((String)cause)) {
            String message = includePathInMessage ? String.format("The %1$s path\n'%2$s'\n%3$s", sdkName, sdkPath, cause) : String.format("The %1$s path %2$s", sdkName, cause);
            return ValidationResult.error(message);
        }
        Path platformsDirPath = sdkPath.resolve("platforms");
        if (!CancellableFileIo.isDirectory((Path)platformsDirPath, (LinkOption[])new LinkOption[0])) {
            String message = includePathInMessage ? String.format("The %1$s at\n'%2$s'\ndoes not contain any platforms.", sdkName, sdkPath) : String.format("%1$s does not contain any platforms.", sdkName);
            return ValidationResult.error(message);
        }
        return ValidationResult.SUCCESS;
    }

    public static class ValidationResult {
        @NotNull
        public static final ValidationResult SUCCESS = new ValidationResult(true, null);
        public final boolean success;
        @Nullable
        public final String message;

        @NotNull
        public static ValidationResult error(@NotNull String message) {
            return new ValidationResult(false, message);
        }

        private ValidationResult(boolean success, @Nullable String message) {
            this.success = success;
            this.message = message;
        }
    }
}

