/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login2;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.util.Throwables;
import com.google.common.annotations.VisibleForTesting;
import com.google.gct.login2.CancellableRedirectServerKt;
import com.google.gct.login2.RequestCancelledException;
import com.google.gct.login2.common.LoginCallbackHandler;
import com.intellij.ide.BrowserUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001*B3\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020$J\u0006\u0010&\u001a\u00020$J\u001a\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010\bH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001e\u001a\u0004\u0018\u00010\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/google/gct/login2/CancellableRedirectServer;", "", "port", "", "handlers", "", "Lcom/google/gct/login2/common/LoginCallbackHandler;", "authSuccessLandingPage", "", "authFailureLandingPage", "<init>", "(ILjava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getPort", "()I", "setPort", "(I)V", "server", "Lorg/mortbay/jetty/Server;", "authUser", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "getCredential", "()Lcom/google/api/client/auth/oauth2/Credential;", "setCredential", "(Lcom/google/api/client/auth/oauth2/Credential;)V", "lock", "Ljava/util/concurrent/locks/Lock;", "callbackHandled", "Ljava/util/concurrent/locks/Condition;", "value", "error", "getError", "()Ljava/lang/String;", "success", "", "start", "", "await", "stop", "signalCallbackHandled", "isSuccess", "errorMessage", "CallbackHandler", "google-login"})
@StabilityInferred(parameters=0)
public final class CancellableRedirectServer {
    private int port;
    @NotNull
    private final List<LoginCallbackHandler> handlers;
    @Nullable
    private final String authSuccessLandingPage;
    @Nullable
    private final String authFailureLandingPage;
    @Nullable
    private Server server;
    private int authUser;
    @Nullable
    private Credential credential;
    @NotNull
    private final Lock lock;
    @NotNull
    private final Condition callbackHandled;
    @Nullable
    private String error;
    private boolean success;
    public static final int $stable = 8;

    public CancellableRedirectServer(@VisibleForTesting int port, @NotNull List<? extends LoginCallbackHandler> handlers, @Nullable String authSuccessLandingPage, @Nullable String authFailureLandingPage) {
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        this.port = port;
        this.handlers = handlers;
        this.authSuccessLandingPage = authSuccessLandingPage;
        this.authFailureLandingPage = authFailureLandingPage;
        this.authUser = -1;
        this.lock = new ReentrantLock();
        Condition condition = this.lock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"newCondition(...)");
        this.callbackHandled = condition;
    }

    public /* synthetic */ CancellableRedirectServer(int n, List list, String string, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        this(n, list, string, string2);
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @Nullable
    public final Credential getCredential() {
        return this.credential;
    }

    public final void setCredential(@Nullable Credential credential) {
        this.credential = credential;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    public final void start() {
        Server it;
        Server server;
        if (this.port == -1) {
            this.port = CancellableRedirectServerKt.access$getUnusedPort();
        }
        Server server2 = server = new Server(this.port);
        CancellableRedirectServer cancellableRedirectServer = this;
        boolean bl = false;
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])it.getConnectors());
        while (iterator2.hasNext()) {
            Connector c = (Connector)iterator2.next();
            c.setHost("localhost");
        }
        it = server;
        boolean bl2 = false;
        LoginCallbackHandler firstHandler = this.handlers.get(0);
        it.addHandler((Handler)new CallbackHandler((Iterator<? extends LoginCallbackHandler>)this.handlers.listIterator()));
        it.start();
        String string = firstHandler.getUrl("localhost", this.port, -1, null);
        if (string == null) {
            throw new IllegalStateException("Url is null.".toString());
        }
        String url = string;
        BrowserUtil.browse((String)url);
        CancellableRedirectServerKt.access$getLog$p().info("Opened url is " + url + ".");
        cancellableRedirectServer.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void await() {
        this.lock.lock();
        try {
            while (!this.success && this.error == null) {
                CancellableRedirectServerKt.access$getLog$p().info("Listening on port " + this.port + ": wait until all handlers are processed or error occurs.");
                this.callbackHandled.awaitUninterruptibly();
            }
            if (this.error != null) {
                if (Intrinsics.areEqual((Object)this.error, (Object)"Request cancelled.") || Intrinsics.areEqual((Object)this.error, (Object)"access_denied")) {
                    throw new RequestCancelledException();
                }
                throw new IOException("User authorization failed (" + this.error + ")");
            }
        }
        finally {
            this.lock.unlock();
            Server server = this.server;
            if (server != null) {
                server.stop();
            }
            this.server = null;
        }
    }

    public final void stop() {
        try {
            Server server = this.server;
            if (server != null) {
                server.stop();
            }
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new IOException(e);
        }
        this.signalCallbackHandled(false, "Request cancelled.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void signalCallbackHandled(boolean isSuccess, String errorMessage) {
        this.lock.lock();
        try {
            this.success = isSuccess;
            this.error = errorMessage;
            this.callbackHandled.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/google/gct/login2/CancellableRedirectServer$CallbackHandler;", "Lorg/mortbay/jetty/handler/AbstractHandler;", "handlerIterator", "", "Lcom/google/gct/login2/common/LoginCallbackHandler;", "<init>", "(Lcom/google/gct/login2/CancellableRedirectServer;Ljava/util/Iterator;)V", "currentHandler", "handle", "", "target", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "dispatch", "", "google-login"})
    @SourceDebugExtension(value={"SMAP\nCancellableRedirectServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CancellableRedirectServer.kt\ncom/google/gct/login2/CancellableRedirectServer$CallbackHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1#2:186\n*E\n"})
    public final class CallbackHandler
    extends AbstractHandler {
        @NotNull
        private final Iterator<LoginCallbackHandler> handlerIterator;
        @Nullable
        private LoginCallbackHandler currentHandler;

        public CallbackHandler(Iterator<? extends LoginCallbackHandler> handlerIterator) {
            Intrinsics.checkNotNullParameter(handlerIterator, (String)"handlerIterator");
            this.handlerIterator = handlerIterator;
            this.currentHandler = this.handlerIterator.next();
        }

        public void handle(@NotNull String target2, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response2, int dispatch) {
            block11: {
                Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                LoginCallbackHandler loginCallbackHandler = this.currentHandler;
                if (loginCallbackHandler == null) {
                    return;
                }
                LoginCallbackHandler activeHandler = loginCallbackHandler;
                try {
                    if (!activeHandler.canHandle(target2)) break block11;
                    Request request2 = request instanceof Request ? (Request)request : null;
                    if (request2 != null) {
                        request2.setHandled(true);
                    }
                    CancellableRedirectServer.this.error = request.getParameter("error");
                    if (CancellableRedirectServer.this.getError() != null) {
                        String string = CancellableRedirectServer.this.authFailureLandingPage;
                        if (string != null) {
                            String it = string;
                            boolean bl = false;
                            response2.sendRedirect(it);
                        }
                        response2.flushBuffer();
                        CancellableRedirectServer.this.signalCallbackHandled(false, "Request cancelled.");
                        break block11;
                    }
                    if (!activeHandler.handle(request, response2)) break block11;
                    Object object = request.getParameter("authuser");
                    if (object != null && (object = StringsKt.toIntOrNull((String)object)) != null) {
                        Object object2 = object;
                        CancellableRedirectServer bl = CancellableRedirectServer.this;
                        int it = ((Number)object2).intValue();
                        boolean bl2 = false;
                        bl.authUser = it;
                    }
                    String nextRedirectUrl = null;
                    while (this.handlerIterator.hasNext() && nextRedirectUrl == null) {
                        LoginCallbackHandler loginCallbackHandler2 = this.currentHandler = this.handlerIterator.next();
                        nextRedirectUrl = loginCallbackHandler2 != null ? loginCallbackHandler2.getUrl("localhost", CancellableRedirectServer.this.getPort(), CancellableRedirectServer.this.authUser, CancellableRedirectServer.this.getCredential()) : null;
                    }
                    String string = nextRedirectUrl;
                    if (string == null) {
                        string = CancellableRedirectServer.this.authSuccessLandingPage;
                    }
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        response2.sendRedirect(it);
                    }
                    response2.flushBuffer();
                    if (nextRedirectUrl == null) {
                        CancellableRedirectServer.this.signalCallbackHandled(true, null);
                    }
                }
                catch (Exception e) {
                    CancellableRedirectServer.this.signalCallbackHandled(false, e.getLocalizedMessage());
                }
            }
        }
    }
}

