/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.appspot.gsamplesindex.samplesindex.model.SampleCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SampleImportTreeManager {
    private final SampleCollection mySamples;
    private final Tree myTree;
    private final Map<DefaultMutableTreeNode, Sample> mySampleMap = new HashMap<DefaultMutableTreeNode, Sample>();
    private final Map<String, String> myFormattedNameMap = new HashMap<String, String>();
    private final Map<String, DefaultMutableTreeNode> myCategoryMap = new TreeMap<String, DefaultMutableTreeNode>();
    private final Map<String, List<DefaultMutableTreeNode>> myCategorySampleNodeMap = new HashMap<String, List<DefaultMutableTreeNode>>();

    public SampleImportTreeManager(@NotNull Tree tree, @NotNull SampleCollection samples) {
        this.myTree = tree;
        this.mySamples = samples;
        this.init();
    }

    private void init() {
        for (Sample sample : this.mySamples.getItems()) {
            if (StringUtil.isEmpty((String)sample.getTitle())) continue;
            String formattedName = SampleImportTreeManager.formatName(sample.getTitle());
            this.myFormattedNameMap.put(sample.getTitle(), formattedName);
            for (String category : sample.getCategories()) {
                DefaultMutableTreeNode sampleNode = new DefaultMutableTreeNode(formattedName);
                this.mySampleMap.put(sampleNode, sample);
                if (!this.myCategoryMap.containsKey(category)) {
                    DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode(StringUtil.capitalize((String)category));
                    this.myCategoryMap.put(category, categoryNode);
                }
                if (!this.myCategorySampleNodeMap.containsKey(category)) {
                    this.myCategorySampleNodeMap.put(category, new ArrayList());
                }
                this.myCategorySampleNodeMap.get(category).add(sampleNode);
            }
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Samples");
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.myTree.setModel((TreeModel)treeModel);
        this.myTree.setEditable(false);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setRootVisible(false);
        this.populateSamplesTree(this.mySamples.getItems(), true);
    }

    static String formatName(String name2) {
        if (StringUtil.isEmpty((String)name2) || name2.trim().isEmpty()) {
            return "Unnamed";
        }
        name2 = name2.replace("-", " - ");
        StringBuilder sb = new StringBuilder(2 * name2.length());
        int n = name2.length();
        boolean lastWasLowerCase = Character.isLowerCase(name2.charAt(0));
        for (int i = 0; i < n; ++i) {
            char c = name2.charAt(i);
            boolean isUpperCase = Character.isUpperCase(c);
            if (isUpperCase && lastWasLowerCase) {
                sb.append(' ');
            }
            lastWasLowerCase = Character.isLetter(c) && !isUpperCase;
            sb.append(c);
        }
        return sb.toString().replaceAll(" +", " ").trim();
    }

    private void populateSamplesTree(@NotNull Collection<Sample> samples, boolean expand) {
        DefaultTreeModel model = (DefaultTreeModel)this.myTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        root.removeAllChildren();
        for (String category : this.myCategoryMap.keySet()) {
            DefaultMutableTreeNode categoryNode = this.myCategoryMap.get(category);
            categoryNode.removeAllChildren();
            for (DefaultMutableTreeNode node : this.myCategorySampleNodeMap.get(category)) {
                if (!samples.contains((Object)this.mySampleMap.get(node))) continue;
                this.myCategoryMap.get(category).add(node);
            }
            if (categoryNode.getChildCount() <= 0) continue;
            root.add(categoryNode);
        }
        model.reload();
        if (expand) {
            for (int i = 0; i < this.myTree.getRowCount(); ++i) {
                this.myTree.expandRow(i);
            }
            try {
                this.myTree.setSelectionPath(new TreePath(root.getFirstLeaf().getPath()));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    @Nullable
    public Sample getSelectedSample() {
        DefaultMutableTreeNode selected = (DefaultMutableTreeNode)this.myTree.getLastSelectedPathComponent();
        if (selected == null || !selected.isLeaf()) {
            return null;
        }
        return this.mySampleMap.get(selected);
    }

    public boolean isEmpty() {
        return this.myTree.isEmpty();
    }

    @NotNull
    Set<Sample> filterSamples(@NotNull String query) {
        ImmutableSet filteredSamples = new HashSet(this.mySamples.getItems());
        HashSet<Sample> filterByWord = new HashSet<Sample>();
        for (String keyword : query.split(" ")) {
            filterByWord.clear();
            for (Sample sample : this.mySamples.getItems()) {
                if (!this.hasKeyword(sample, keyword)) continue;
                filterByWord.add(sample);
            }
            filteredSamples = Sets.intersection(filteredSamples, filterByWord).immutableCopy();
        }
        return filteredSamples;
    }

    private boolean hasKeyword(Sample sample, String keyword) {
        if (sample.getTitle() != null && (StringUtil.containsIgnoreCase((String)sample.getTitle(), (String)keyword) || StringUtil.containsIgnoreCase((String)this.myFormattedNameMap.get(sample.getTitle()), (String)keyword))) {
            return true;
        }
        if (sample.getDescription() != null && StringUtil.containsIgnoreCase((String)sample.getDescription(), (String)keyword)) {
            return true;
        }
        for (String category : sample.getCategories()) {
            if (category == null || !StringUtil.containsIgnoreCase((String)category, (String)keyword)) continue;
            return true;
        }
        return false;
    }

    public void filterTree(@NotNull String query) {
        this.populateSamplesTree(this.filterSamples(query), true);
    }
}

