/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.AndroidXConstants;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidClassMembersImplicitUsagesProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(@NotNull PsiElement element) {
        PsiMethod method2;
        if (element instanceof PsiField) {
            return AndroidClassMembersImplicitUsagesProvider.isImplicitFieldUsage((PsiField)element);
        }
        if (element instanceof PsiParameter) {
            return AndroidClassMembersImplicitUsagesProvider.isImplicitParameterUsage((PsiParameter)element);
        }
        if (element instanceof PsiMethod && (method2 = (PsiMethod)element).isConstructor()) {
            return this.isImplicitConstructorUsage(method2);
        }
        return false;
    }

    private static boolean isImplicitParameterUsage(@NotNull PsiParameter parameter) {
        if (AndroidFacet.getInstance((PsiElement)parameter) == null) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiMethod.class);
        if (method2 == null || !OnClickConverter.CONVERTER_FOR_LAYOUT.checkSignature(method2) && !OnClickConverter.CONVERTER_FOR_MENU.checkSignature(method2)) {
            return false;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method2, PsiClass.class);
        if (aClass == null) {
            return false;
        }
        PsiClass activityBaseClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("android.app.Activity", parameter.getResolveScope());
        if (activityBaseClass == null) {
            return false;
        }
        return aClass.isInheritor(activityBaseClass, true);
    }

    private static boolean isImplicitFieldUsage(@NotNull PsiField field2) {
        if (!"CREATOR".equals(field2.getName())) {
            return false;
        }
        PsiModifierList modifierList = field2.getModifierList();
        if (modifierList == null || !modifierList.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = field2.getContainingClass();
        return aClass != null && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"android.os.Parcelable");
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        return false;
    }

    public boolean isImplicitConstructorUsage(PsiMethod method2) {
        PsiClass aClass;
        if (!method2.isConstructor()) {
            return false;
        }
        if (!method2.hasModifierProperty("public")) {
            return false;
        }
        PsiParameterList parameterList = method2.getParameterList();
        int parameterCount = parameterList.getParametersCount();
        if (parameterCount == 0) {
            PsiClass aClass2 = method2.getContainingClass();
            return aClass2 != null && (InheritanceUtil.isInheritor((PsiClass)aClass2, (String)"android.app.Fragment") || InheritanceUtil.isInheritor((PsiClass)aClass2, (String)AndroidXConstants.CLASS_V4_FRAGMENT.oldName()) || InheritanceUtil.isInheritor((PsiClass)aClass2, (String)AndroidXConstants.CLASS_V4_FRAGMENT.newName()) || InheritanceUtil.isInheritor((PsiClass)aClass2, (String)"android.app.backup.BackupAgent"));
        }
        if (parameterCount < 1 || parameterCount > 3) {
            return false;
        }
        PsiParameter[] parameters2 = parameterList.getParameters();
        PsiType type = parameters2[0].getType();
        if (!(type instanceof PsiClassReferenceType)) {
            return false;
        }
        PsiClassReferenceType classType = (PsiClassReferenceType)type;
        PsiClass resolvedParameter = classType.resolve();
        if (resolvedParameter == null || !"android.content.Context".equals(resolvedParameter.getQualifiedName())) {
            return false;
        }
        if (parameterCount > 1) {
            type = parameters2[1].getType();
            if (!(type instanceof PsiClassReferenceType)) {
                return false;
            }
            classType = (PsiClassReferenceType)type;
            resolvedParameter = classType.resolve();
            if (resolvedParameter == null || !"android.util.AttributeSet".equals(resolvedParameter.getQualifiedName())) {
                return false;
            }
            if (parameterCount > 2) {
                type = parameters2[2].getType();
                if (!PsiTypes.intType().equals((Object)type)) {
                    return false;
                }
            }
        }
        if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method2, PsiClass.class)) == null) {
            return false;
        }
        PsiClass viewBaseClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("android.view.View", method2.getResolveScope());
        if (viewBaseClass == null) {
            return false;
        }
        return aClass.isInheritor(viewBaseClass, true) || parameterCount == 1 && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"android.view.ActionProvider");
    }
}

