/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.jetbrains.android.actions.CreateResourceDialogUtils;
import org.jetbrains.android.actions.CreateResourceDirectoryDialogBase;
import org.jetbrains.android.actions.ElementCreatingValidator;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.DeviceConfiguratorPanel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CreateResourceDirectoryDialog
extends CreateResourceDirectoryDialogBase {
    private JComboBox<ResourceFolderType> myResourceTypeComboBox;
    private JPanel myDeviceConfiguratorWrapper;
    private JTextField myDirectoryNameTextField;
    private JPanel myContentPanel;
    private JBLabel myErrorLabel;
    private JComboBox mySourceSetCombo;
    private JBLabel mySourceSetLabel;
    private final DeviceConfiguratorPanel myDeviceConfiguratorPanel;
    private ElementCreatingValidator myValidator;
    private final CreateResourceDirectoryDialogBase.ValidatorFactory myValidatorFactory;
    private final PsiDirectory myResDirectory;
    private final DataContext myDataContext;
    private final boolean myForceDirectoryDoesNotExist;

    public CreateResourceDirectoryDialog(@NotNull Project project, @Nullable Module module, @Nullable ResourceFolderType resType, @Nullable PsiDirectory resDirectory, @Nullable DataContext dataContext, @NotNull CreateResourceDirectoryDialogBase.ValidatorFactory validatorFactory) {
        this(project, module, resType, resDirectory, dataContext, validatorFactory, false);
    }

    public CreateResourceDirectoryDialog(@NotNull Project project, @Nullable Module module, @Nullable ResourceFolderType resType, @Nullable PsiDirectory resDirectory, @Nullable DataContext dataContext, @NotNull CreateResourceDirectoryDialogBase.ValidatorFactory validatorFactory, boolean forceDirectoryDoesNotExist) {
        super(project);
        this.setupUI();
        this.myResDirectory = resDirectory;
        this.myDataContext = dataContext;
        this.myValidatorFactory = validatorFactory;
        this.myForceDirectoryDoesNotExist = forceDirectoryDoesNotExist;
        this.myResourceTypeComboBox.setModel((ComboBoxModel<ResourceFolderType>)new EnumComboBoxModel(ResourceFolderType.class));
        this.myResourceTypeComboBox.setRenderer((ListCellRenderer<ResourceFolderType>)SimpleListCellRenderer.create((String)"", ResourceFolderType::getName));
        this.myDeviceConfiguratorPanel = this.setupDeviceConfigurationPanel(this.myResourceTypeComboBox, this.myDirectoryNameTextField, this.myErrorLabel);
        this.myDeviceConfiguratorWrapper.add((Component)this.myDeviceConfiguratorPanel, "Center");
        this.myResourceTypeComboBox.addActionListener(event -> this.myDeviceConfiguratorPanel.applyEditors());
        if (resType != null) {
            this.myResourceTypeComboBox.setSelectedItem(resType);
            this.myResourceTypeComboBox.setEnabled(false);
        } else {
            this.myResourceTypeComboBox.setSelectedItem(ResourceFolderType.VALUES);
        }
        AndroidFacet facet = module != null ? AndroidFacet.getInstance((Module)module) : null;
        CreateResourceDialogUtils.updateSourceSetCombo((JComponent)this.mySourceSetLabel, this.mySourceSetCombo, facet, this.myResDirectory);
        this.myDeviceConfiguratorPanel.updateAll();
        this.setOKActionEnabled(!this.myDirectoryNameTextField.getText().isEmpty());
        this.init();
    }

    @Nullable
    @VisibleForTesting
    public ValidationInfo doValidate() {
        PsiDirectory directory = this.getResourceDirectory(this.myDataContext);
        if (directory == null) {
            return null;
        }
        String name2 = this.myDirectoryNameTextField.getText();
        PsiDirectory subdirectory = directory.findSubdirectory(name2);
        if (subdirectory != null && !this.myForceDirectoryDoesNotExist) {
            return new ValidationInfo(subdirectory.getVirtualFile().getPresentableUrl() + " already exists. Use a different qualifier.");
        }
        if (ResourceFolderType.getFolderType((String)name2) == null) {
            return new ValidationInfo(String.format("'%s' is not a valid resource directory name", name2));
        }
        return null;
    }

    protected void doOKAction() {
        String dirName = this.myDirectoryNameTextField.getText();
        assert (dirName != null);
        PsiDirectory resourceDirectory = this.getResourceDirectory(this.myDataContext);
        if (resourceDirectory == null) {
            Module module = (Module)PlatformCoreDataKeys.MODULE.getData(this.myDataContext);
            Messages.showErrorDialog((String)AndroidBundle.message("check.resource.dir.error", module), (String)CommonBundle.getErrorTitle());
            super.doOKAction();
            return;
        }
        this.myValidator = this.myValidatorFactory.create(resourceDirectory);
        if (this.myValidator.checkInput(dirName) && this.myValidator.canClose(dirName)) {
            super.doOKAction();
        }
    }

    protected String getDimensionServiceKey() {
        return "AndroidCreateResourceDirectoryDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myResourceTypeComboBox.isEnabled()) {
            return this.myResourceTypeComboBox;
        }
        return this.myDirectoryNameTextField;
    }

    @VisibleForTesting
    JTextComponent getDirectoryNameTextField() {
        return this.myDirectoryNameTextField;
    }

    @TestOnly
    Collection<String> getSourceSets() {
        int size = this.mySourceSetCombo.getModel().getSize();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            builder.add((Object)this.mySourceSetCombo.getModel().getElementAt(i).toString());
        }
        return builder.build();
    }

    @Override
    @NotNull
    public PsiElement[] getCreatedElements() {
        return this.myValidator != null ? this.myValidator.getCreatedElements() : PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    private PsiDirectory getResourceDirectory(@Nullable DataContext context) {
        if (this.myResDirectory != null) {
            return this.myResDirectory;
        }
        if (context != null) {
            Module module = (Module)PlatformCoreDataKeys.MODULE.getData(context);
            assert (module != null);
            return CreateResourceDialogUtils.getOrCreateResourceDirectory(this.mySourceSetCombo, module);
        }
        return null;
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    private void setupUI() {
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPanel.setPreferredSize(new Dimension(800, 400));
        this.myResourceTypeComboBox = new JComboBox();
        this.myContentPanel.add(this.myResourceTypeComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Resource type:");
        jBLabel1.setDisplayedMnemonic('R');
        jBLabel1.setDisplayedMnemonicIndex(0);
        this.myContentPanel.add((Component)jBLabel1, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myDeviceConfiguratorWrapper = new JPanel();
        this.myDeviceConfiguratorWrapper.setLayout(new BorderLayout(0, 0));
        this.myContentPanel.add((Component)this.myDeviceConfiguratorWrapper, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Directory name:");
        label1.setDisplayedMnemonic('D');
        label1.setDisplayedMnemonicIndex(0);
        this.myContentPanel.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myDirectoryNameTextField = new JTextField();
        this.myDirectoryNameTextField.setEnabled(true);
        this.myContentPanel.add((Component)this.myDirectoryNameTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myErrorLabel = new JBLabel();
        this.myContentPanel.add((Component)this.myErrorLabel, new GridConstraints(4, 0, 1, 2, 0, 3, 0, 0, null, null, null, 0, false));
        this.mySourceSetLabel = new JBLabel();
        this.mySourceSetLabel.setText("Source set:");
        this.mySourceSetLabel.setDisplayedMnemonic('S');
        this.mySourceSetLabel.setDisplayedMnemonicIndex(0);
        this.myContentPanel.add((Component)this.mySourceSetLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.mySourceSetCombo = new JComboBox();
        this.myContentPanel.add((Component)this.mySourceSetCombo, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        jBLabel1.setLabelFor(this.myResourceTypeComboBox);
        label1.setLabelFor(this.myDirectoryNameTextField);
        this.mySourceSetLabel.setLabelFor(this.myResourceTypeComboBox);
    }

    public JComponent getRootComponent() {
        return this.myContentPanel;
    }
}

