/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import java.util.List;
import org.jetbrains.android.actions.CreateMultiRootResourceFileAction;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.dom.animation.AndroidAnimationUtils;
import org.jetbrains.android.dom.animator.AndroidAnimatorUtil;
import org.jetbrains.android.dom.color.AndroidColorDomUtil;
import org.jetbrains.android.dom.drawable.AndroidDrawableDomUtil;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.dom.transition.TransitionDomUtil;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class CreateResourceFileActionGroup
extends DefaultActionGroup {
    private final CreateResourceFileAction myMajorAction;

    public CreateResourceFileActionGroup() {
        CreateResourceFileAction a = new CreateResourceFileAction();
        a.add(new CreateMultiRootResourceFileAction(ResourceType.LAYOUT.getDisplayName(), ResourceFolderType.LAYOUT));
        a.add(new CreateMultiRootResourceFileAction(this, ResourceType.NAVIGATION.getDisplayName(), ResourceFolderType.NAVIGATION){

            @Override
            @NotNull
            public List<String> getAllowedTagNames(@NotNull AndroidFacet facet) {
                return NavigationSchema.getPossibleRootsMaybeWithoutSchema(facet.getModule());
            }
        });
        a.add(new CreateMultiRootResourceFileAction(this, ResourceType.XML.getDisplayName(), ResourceFolderType.XML){

            @Override
            @NotNull
            public List<String> getAllowedTagNames(@NotNull AndroidFacet facet) {
                return AndroidXmlResourcesUtil.getPossibleRoots(facet);
            }
        });
        a.add(new CreateMultiRootResourceFileAction(this, ResourceType.DRAWABLE.getDisplayName(), ResourceFolderType.DRAWABLE){

            @Override
            @NotNull
            public List<String> getAllowedTagNames(@NotNull AndroidFacet facet) {
                return AndroidDrawableDomUtil.getPossibleRoots(facet);
            }
        });
        a.add(new CreateMultiRootResourceFileAction(this, ResourceType.COLOR.getDisplayName(), ResourceFolderType.COLOR){

            @Override
            @NotNull
            public List<String> getAllowedTagNames(@NotNull AndroidFacet facet) {
                return AndroidColorDomUtil.getPossibleRoots();
            }
        });
        a.add(new CreateTypedResourceFileAction("Values", ResourceFolderType.VALUES, true, false));
        a.add(new CreateTypedResourceFileAction(ResourceType.MENU.getDisplayName(), ResourceFolderType.MENU, false, false));
        a.add(new CreateMultiRootResourceFileAction(this, ResourceType.ANIM.getDisplayName(), ResourceFolderType.ANIM){

            @Override
            @NotNull
            public List<String> getAllowedTagNames(@NotNull AndroidFacet facet) {
                return AndroidAnimationUtils.getPossibleRoots();
            }
        });
        a.add(new CreateMultiRootResourceFileAction(this, ResourceType.ANIMATOR.getDisplayName(), ResourceFolderType.ANIMATOR){

            @Override
            @NotNull
            public List<String> getAllowedTagNames(@NotNull AndroidFacet facet) {
                return AndroidAnimatorUtil.getPossibleRoots();
            }
        });
        a.add(new CreateMultiRootResourceFileAction(this, ResourceType.TRANSITION.getDisplayName(), ResourceFolderType.TRANSITION){

            @Override
            @NotNull
            public List<String> getAllowedTagNames(@NotNull AndroidFacet facet) {
                return TransitionDomUtil.getPossibleRoots();
            }
        });
        a.add(new CreateTypedResourceFileAction(ResourceType.FONT.getDisplayName(), ResourceFolderType.FONT, false, false));
        a.add(new CreateTypedResourceFileAction(ResourceType.RAW.getDisplayName(), ResourceFolderType.RAW, false, false));
        this.myMajorAction = a;
        this.add(a);
        for (CreateTypedResourceFileAction subaction : a.getSubactions()) {
            this.add(subaction);
        }
    }

    @NotNull
    public CreateResourceFileAction getCreateResourceFileAction() {
        return this.myMajorAction;
    }
}

